/*
  poplib.c -- Waterloo TCP POP client libraries.

  Copyright (C) 1997-1999  Rod Whitby
  Copyright (C) 1992       Walter Andrew Nolan

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version
  2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be 
  useful, but WITHOUT ANY WARRANTY; without even the implied
  warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
  PURPOSE.  See the GNU General Public License for more
  details.

  You should have received a copy of the GNU General Public
  License along with this program; if not, write to the Free
  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
  USA.

  $Source: A:/SRC/TCP/MTA/RCS/POPLIB.C $
  $Id: POPLIB.C 1.15 2000/04/09 07:02:50 rwhitby Exp $
*/

#include <conio.h>
#include <ctype.h>
#include <dos.h>
#include <mem.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "socklib.h"

/* Global Macros */

#define POP_PORT 110

static int POP_stat;

/*-------------------------------------------------------------
 -                                                            <
 -  POP Stuff                                                 <
 -                                                            <
/------------------------------------------------------------*/

#define SOCK_COMMAND(PROTOCOL, HANDLER) \
  strcpy(Sock_last, Sock_buffer); \
  SOCK_PUTS(PROTOCOL); \
  SOCK_GETS(PROTOCOL); \
  if (!strcmp(Sock_buffer, Sock_last)) { \
    SOCK_GETS(PROTOCOL); \
  } \
  if ( *Sock_buffer != '+' ) { \
    HANDLER; \
  }

tcp_Socket * pop_init(char *proxy, char *host, int port)
{
  tcp_Socket *POP_sock=NULL;
  char *p;

  POP_sock=(tcp_Socket *)malloc(sizeof(tcp_Socket));

  if (!socklib_connect( "POP", POP_sock, &POP_stat, proxy, host, port)) {
    fprintf(stderr, "POP> Unable to connect to %s", host);
    return 0;
  }

  if (proxy) {
    if (((p = strstr(Sock_buffer, "+OK ")) != NULL) ||
        ((p = strstr(Sock_buffer, "-ERR ")) != NULL)) {
      strcpy(Sock_buffer, p);
    }
    else {
      SOCK_GETS(POP);
    }
  }
  else {
    SOCK_GETS( POP );
  }

  if ( *Sock_buffer != '+' ) {
    SOCK_QUIT( POP, );
  }

  SOCK_READ_ERR(POP, );

  return POP_sock;
}

int pop_login(tcp_Socket *POP_sock, char *userid, char *password)
{

  sprintf( Sock_buffer, "USER %s", userid);
  SOCK_COMMAND ( POP, SOCK_QUIT( POP, ) );

  sprintf( Sock_buffer, "PASS %s", password );
  SOCK_COMMAND ( POP, SOCK_QUIT( POP, ) );

  SOCK_READ_ERR(POP, );

  return 1;
}

int pop_status(tcp_Socket *POP_sock, long *count, long *totlen)
{
  sprintf( Sock_buffer, "STAT" );
  SOCK_COMMAND ( POP, SOCK_FAIL( POP, ) );
  if (getnumbers(Sock_buffer, count, totlen, NULL) != 2) {
    SOCK_FAIL( POP, );
  }

  SOCK_READ_ERR(POP, );

  return 1;
}

long pop_length(tcp_Socket *POP_sock, long msg_num, long *size)
{
  long dummy;
  sprintf(Sock_buffer, "LIST %ld", msg_num);
  SOCK_COMMAND ( POP, SOCK_FAIL( POP, ) );
  if (getnumbers(Sock_buffer, &dummy, size, NULL) != 2) {
    SOCK_FAIL( POP, );
  }

  SOCK_READ_ERR(POP, );

  return *size;
}

static int pop_start_article(FILE *f)
{
  /* MMDF format */
  fprintf(f, "\001\001\001\001\n");
  return;
}

static int pop_end_article(FILE *f)
{
  /* MMDF format */
  fprintf(f, "\001\001\001\001\n");
  return;
}

int pop_retrieve(tcp_Socket *POP_sock, FILE *f, long msg_num,
                 long body_lines, char eol)
{
  int in_body = 0;
  int flush = 0;
  int status = 1;

  if (body_lines < 0) { 
    sprintf( Sock_buffer, "RETR %lu", msg_num );
  }
  else {
    sprintf( Sock_buffer, "TOP %lu %lu", msg_num, body_lines+1);
  }
  SOCK_COMMAND ( POP,  SOCK_FAIL( POP, ) );

  pop_start_article(f);

  do {
    SOCK_GETS( POP );
    if ((Sock_buffer[0] == '.') && (Sock_buffer[1] == 0)) break;
    if (flush) continue;
    if (in_body) {
      if (body_lines == 0) {
        fprintf(f, "[Truncated]\n");
        flush = 1;
        continue;
      }
      body_lines--;
    }
    else if (*Sock_buffer == 0) {
      in_body = 1;
    }
    else if (eol && !strncmp(Sock_buffer, "From:", 5)) {
      fprintf(stderr, "%c%s", eol, Sock_buffer); clreol();
    }
    else if (eol && !strncmp(Sock_buffer, "Subject:", 8)) {
      fprintf(stderr, "%c%s", eol, Sock_buffer); clreol();
    }
    if (fprintf(f, "%s\n", Sock_buffer) < 0) {
      flush = 1;
      status = 0;
    }
  } while (1);

  SOCK_READ_ERR(POP, pop_end_article(f));

  pop_end_article(f);

  return status;
}

int pop_delete(tcp_Socket *POP_sock, long msg_num)
{
  sprintf( Sock_buffer, "DELE %ld", msg_num );
  SOCK_COMMAND ( POP, SOCK_FAIL( POP, ) );

  SOCK_READ_ERR(POP, );

  return 1;
}

int pop_shutdown(tcp_Socket *POP_sock)
{
  if (sock_established(POP_sock)) {
    sprintf(Sock_buffer, "QUIT");
    SOCK_PUTS( POP );
    SOCK_GETS( POP );
    sock_close( POP_sock );
  }
  else {
    sock_abort( POP_sock );
  }
  SOCK_READ_ERR(POP, sock_abort(POP_sock));
  return 1;
}

/* End of poplib.c */
