/* $Id: NEWKOVR.C 1.3 1999/01/09 06:03:29 rwhitby Exp $ */
/* $Source: A:/SRC/TCP/NCSATCP/SRC/RCS/NEWKOVR.C $ */

/*
 * Portions developed by the Educational Resources Center, Clarkson University.
 * Portions developed by the National Center for Supercomputing Applications,
 * University of Illinois at Urbana-Champaign.
 */

#include <alloc.h>
#include <ctype.h>
#include <stdio.h>
#include <string.h>

#include "config.h"
#include "windat.h"
#include "newwin.h"
#include "vsdata.h"
#include "netevent.h"
#include "hostform.h"
#include "mem.h"

#include "newkeys.h"

/* #define	DEBUG	1 */

extern	KeyLib	*KeyLibs;		/* our currently loaded keylibs */
extern int kbcodes;
extern struct config Scon;
extern KeyLib	*Default_Key;
extern	KeyLib	*Default_Key_Config;	/* from config.tel */
extern int	Key_silent;		/* true if we are to be quiet */
extern	Macro	*Key_Find_Macro(char *s);

static int
Key_Sort(a,b)
     KeyList *a,*b;			/* used by qsort */
{
  return(a->Key_keycode - b->Key_keycode);
}


KeyLib
*Key_Load_File(fname)			/* load this keymap, return ptr */
     char	*fname;
{
  FILE	*fptr;
  KeyLib	*KL;

  if(!fname)
    return(NULL);
  if(KL = Key_Find_Lib(fname)) {
    if(!Key_silent)
      nprintf(CONSOLE,"Keyfile %s already loaded\r\n",fname);
    KL->Key_Refs++;
    return(KL);
  }

  if(!(fptr = fopen(fname,"rt"))) {
    if(!Key_silent)
      nprintf(CONSOLE,"Can't open keyfile %s\r\n",fname);
    return(NULL);
  }
  KL = Key_Read_Keyfile(fptr, fname);
  fclose(fptr);
  if(KL) {	/* qsort the table */
    if(!Key_silent)
      nprintf(CONSOLE,"Sorting key defs %d keys, size %d... ",KL->Key_Entries,sizeof(KeyList));
    qsort(KL->Key_List, KL->Key_Entries, sizeof(KeyList), Key_Sort);
    if(!Key_silent)
      nprintf(CONSOLE,"Done\n\r");
  }
  KL->Key_next = NULL;
  if(!KeyLibs)
    KeyLibs = KL;
  else {
    KL->Key_next = KeyLibs;
    KeyLibs = KL;
  }
  KL->Key_Refs++;
  KL->Key_Flags |= KEY_FLAG_DYNAMIC;
  return(KL);
}


KeyLib
*Key_Read_Keyfile(fptr,fname)		/* read the file handle */
     FILE	*fptr;
     char	*fname;
{
  char	tbuff[512];
  int	skipping,state;
  unsigned int keycode;
  KeyDefs	*kd;
  KeyLib	*KL;
  KeyList	*kl;
  unsigned char	*c,d,*i;
  char	*msg = NULL;
  int	bytes,keymode,ismacro;
  int	lineno,keys,len;
  long	offset;
  static	char	modes[]={' ','+','-','$',0};

  kd = KL = kl = NULL;
  offset = ftell(fptr);
 restart:;

  bytes = keys = lineno = skipping = 0;

  while(!feof(fptr)) {
    state = 0;
    if(!fgets(tbuff,511,fptr))
      break;
    lineno++;
    tbuff[strlen(tbuff)-1] = 0;	/* chop LF */

    /* sigh, I'd love to have a nice lex parser here... */
    i = tbuff;
    while(*i && isspace(*i))
      i++;
    if(!*i)
      continue;
    if(*i == ';')
      continue;	/* comment */
    if(!ncstrncmp(i, "ext",3)) {
      if(!(kbcodes & 0x10)) {
	skipping = 1;	/* 1 means we're skipping */
	msg = "skipping";
	continue;
      }
      skipping = 0;
      continue;
    }
    if(!ncstrncmp(i, "not",3)) {
      if(kbcodes & 0x10) {
	skipping = 1;
	msg = "skipping";
	continue;
      }
      skipping = 0;
      continue;
    }
    if(skipping)
      continue;

    if(c = strrchr(i,';')) {
      if(c != i) {
	if(*(c-1) != '\\')
	  *(c) = 0;	/* chop trailing comments */
      }
    }
    msg = "set";
    if(ncstrncmp(i, "set",3)) {
    oops:;
      nprintf(CONSOLE,"Syntax error, (%s) line %d, file %s\n\r",
	      msg ? msg : "none", lineno, fname);

    reoops:;
      continue;
    }
    msg = "1st space";
    i = strchr(i,' ');
    if(!i)
      goto oops;
    i++;
    msg = "key";
    if(ncstrncmp(i, "key",3))
      goto oops;
    msg = "mode space";
    i = strchr(i,' ');	/* now at +, $ - or number */
    if(!i)
      goto oops;
    keymode = 0;
    i++;
    msg = "mode";
    c = strchr(modes,*i);
    if(c) {
      keymode = c - modes;
      i = strchr(i,' ');
      msg = "after mode space";
      if(!i)
	goto oops;
      i++;
    }
    keycode = 0;
    msg = "keycode";
    sscanf(i,"%x",&keycode);
    if(!keycode) {
      nprintf(CONSOLE,"Bad key mode or keycode, line %d, file %s\n\r",lineno, fname);
      continue;
    }
    i = strchr(i,' ');
    if(!i)
      goto oops;
    while(isascii(*i) && *i && isspace(*i))
      i++;
    msg = "none defined";
    if(!*i)
      goto oops;
    /* now we're talking! */
    state = 0;
    c = tbuff;
    ismacro = 0;
    while(*i) {
      Macro *m;
      unsigned char *z;

      switch  (state) {

      case 0 :	/* copying */
	if(*i == '\\') 
	  state = 1;
	else
	  *c++ = *i;
	break;
      case 1 :	/* some special escape */
	switch (*i) {

	case 'e' :
	  *c++ = 27;
	  break;
	case 'r' :
	  *c++ = 13;
	  break;
	case 'n' :
	  *c++ = 10;
	  break;
	case '\\' :
	  *c++ = '\\';
	  break;
	case ';' :
	  *c++ = ';';
	  break;
	case '"' :	/* macros */
	  if(z = strchr(i+1,'"')) {
	    *z = 0;
	    if(m = Key_Find_Macro(i+1)) {
	      if(m->M_code < 256 && !m->M_func) {
		*c++ = m->M_code & 0xff;
		i = z;
	      }
	      else {
		*z = '"';
		*c++ = '\\';
		*c++ = '"';
		ismacro = 1;
	      }
	    }
	    else {
	      nprintf(CONSOLE,"Unknown Macro '%s', line %d, file %s\n\r",
		      i+1,lineno,fname);
	      goto reoops;
	    }
	  }
	  else {
	    nprintf(CONSOLE,"Missing trialing \" in macro, line %d, file %s\n\r",
		    lineno,fname);
	    goto reoops;
	  }
	  break;
	default :
	  if(*i >= '0' && *i <= '3') {
	    d = (*i-'0') * 64;
	    state = 2;
	    i++;
	    continue;
	  }
	  nprintf(CONSOLE,"Invalid escape character, line %d, file %s\n\r",
		  lineno, fname);
	  goto reoops;
	} /* end escape switch */
	state = 0;
	break;
      case 2 :		/* 2nd octal escape char */
	if(*i >= '0' && *i <= '7') {
	  d += (*i-'0') * 8;
	  state = 3;
	}
	else {
	  nprintf(CONSOLE,"Invalid 2nd char in octal escape, line %d, file %s\n\r",
		  lineno, fname);
	  goto reoops;
	}
	break;
      case 3 :		/* 3rd and last octal char */
	if(*i >= '0' && *i <= '7') {
	  d += (*i-'0') ;
	  state = 0;
	  *c++ = d;
	}
	else {
	  nprintf(CONSOLE,"Invalid 3rd char in octal escape, line %d, file %s\n\r",
		  lineno, fname);
	  goto reoops;
	}
	break;
      }	/* end big switch */
      i++;
    }	/* end while *i */
    len = (c - tbuff);
    if(len > 255) {
      nprintf(CONSOLE,"Key definition too long, line %d, file %s\n\r",
	      lineno, fname);
      continue;
    }
    if(KL) 	{ /* if we are storing key list */
      kl->Key_offset = bytes & KEY_OFFSET_MASK;
      kl->Key_keycode = keycode;
      kl->Key_mode = keymode;
      if(len > 1) {
	KeyDefs *kkd = (KeyDefs *) (((char *) kd) + bytes);
	kkd->Key_length = len;
	memcpy(kkd->Key_data, tbuff, len);
	kl->Key_Is_char = 0;
	kl->Key_Macros = ismacro;
      }
      else {
	kl->Key_char = tbuff[0];
	kl->Key_Is_char = 1;
	kl->Key_Macros = 0;
      }
      kl++;	/* point to next KD */
    }
    if(len > 1)
      bytes += len+1;	/* total bytes required */
    keys++;
  }	/* end read file loop */
  if(!KL)		{ /* now go back and rescan list */
    if(!keys) {
      nprintf(CONSOLE,"Error! No key definitions found in file %s\n\r",fname);
      return(NULL);
    }
    else
      nprintf(CONSOLE,"Found %d key definitions in %d bytes, file %s\n\rRescanning file...\r\n",
	      keys, bytes, fname);
    if(bytes > 8192) {
      nprintf(CONSOLE,"Error! Key definitions limited to 8192 bytes. Key defs too large\n\r");
      return(NULL);
    }
    if(!(KL = mem_calloc(sizeof(KeyLib),1))) {
    blastoff:;
      nprintf(CONSOLE,"Not enough memory for key definition table\n\r");
      if(KL)
	mem_free(KL);
      if(kl)
	mem_free(kl);
      if(kd)
	mem_free(kd);
      return(NULL);
    }
    if(bytes)
      if(!(kd = mem_calloc(bytes,1)))
	goto blastoff;
    if(!(kl = mem_calloc(keys, sizeof(KeyList))))
      goto blastoff;
    KL->Key_name = mem_strdup(fname);
    KL->Key_List = kl;
    KL->Key_Defs = kd;
    KL->Key_Entries = keys;
    KL->Key_Size = bytes;
    fseek(fptr,offset,SEEK_SET);
    goto restart;
  }
  return(KL);
}	/* end function */


int
ncstrncmp(a,b,len)
     char	*a;
     char	*b;
     int	len;
{
  char	*c;
  int	z = len;

  c = a;
  while(*c && z--) {
    if(isalpha(*c) && islower(*c))
      *c = toupper(*c);
    c++;
  }
  c = b;
  z = len;
  while(*c && z--) {
    if(isalpha(*c) && islower(*c))
      *c = toupper(*c);
    c++;
  }

  return(strncmp(a,b,len));
}

/* End of newkovr.c */
