/* $Id: RLOGIN.C 1.4 1999/05/22 11:49:31 rwhitby Exp $ */
/* $Source: A:/SRC/TCP/NCSATCP/SRC/RCS/RLOGIN.C $ */

/*
 * Portions developed by the Educational Resources Center, Clarkson University.
 * Portions developed by the National Center for Supercomputing Applications,
 * University of Illinois at Urbana-Champaign.
 */

#include <dos.h>
#include <mem.h>
#include <stdio.h>
#include <string.h>
#include <time.h>

#include "config.h"
#include "protocol.h"
#include "hostform.h"
#include "data.h"
#include "windat.h"
#include "newwin.h"

/* #define	DEBUG 	1 */

extern struct config Scon;

char	destuser[32],*destuserptr = Scon.username;

struct winsize {
  short ws_row;
  short ws_col;
  short ws_xpixel;
  short ws_ypixel;
};

#define	TIOCPKT_WINDOW	0x80
extern  int     temptek, rgdevice,capon,viewmode;

void
RloginGetPort()		/* set netfromport to a privilaged port */
{
  int	portnum;
  struct port *p;
  int 	x,tries;
  int	bad = 0;

  for(tries = 0; tries < 100; tries++) {
    while((portnum = (rand() % 1024)) < 512);
    for(x=0; x < NPORTS; x++) {
      if(portnum == intswap(portlist[x]->tcpout.t.source))
	bad = 1;
    }
    if(!bad)
      break;
  }

  netfromport(portnum);
}



int
Rlogin_Handler(pnum, bytes, urg)		/* handle urgent data */
     int pnum;
     int bytes;			/* number of bytes until end of urgent data */
     unsigned char  urg;		/* the last byte of urgent data */
{


  int	dbuff[256];		/* dummy buffer */

#ifdef	DEBUG
  printf("\n\rUrgent Handler bytes %u urg 0x%x port %d\n",bytes, urg, pnum);
#endif
  if(pnum < 0)
    return;
  netclearurgent(pnum);
  if(urg & TIOCPKT_WINDOW) {
    Rlogin_Window(pnum);
    urg |= 2;	/* flush out junk, a crock */
  }
  if(urg & 2) {	/* flush write */
    while(bytes > 0) {
      netread(pnum, dbuff, bytes > 256 ? 256 : bytes);
      bytes -= 256;
    }
  }
}

int
Rlogin_Window(pnum)			/* send window size to other side */
     int pnum;

{
  unsigned char obuf[4 + sizeof(struct winsize)];
  struct winsize *wp = (struct winsize *) &obuf[4];

  obuf[0] = 0377;
  obuf[1] = 0377;
  obuf[2] = 's';
  obuf[3] = 's';

  wp->ws_row = intswap(NUMLINES+1);
  wp->ws_col = intswap(cols);
  wp->ws_xpixel = intswap(640);
  wp->ws_ypixel = intswap(200);
  netwrite(pnum, obuf, sizeof(obuf));
}


void
RshellInit(tw)
     struct twin *tw;
{
  char  buff[512];
  int  len = 0;
  int portnum = tw->pnum;
#ifdef	NOTNEEDED
  neturgent(portnum, Rlogin_Handler);	/* install urgent data handler */
#endif
  strcpy(buff,"");		/* return port number for stderr (0 means none) */
  len = 1;
  strcpy(&buff[len],Scon.username);
  len += strlen(Scon.username) + 1;	/* userid on client side */

  strcpy(&buff[len],destuserptr);
  len += strlen(destuserptr) + 1;	/* userid on server host side */
  destuserptr = Scon.username;

  strcpy(&buff[len],tw->linemode);
  len += strlen(tw->linemode)+1;
  netwrite(portnum, buff, len);
  tw->echo = 1;
  tw->binary = 1;
  VSwrite(tw->vs,"\033[20h",5);	/* enable LNM */
  statline();
}


void
RloginInit(tw)		/* initialize rlogin sequence */
     struct twin *tw;
{
  char  buff[512];
  int  len = 0;
  int portnum = tw->pnum;

  neturgent(portnum, Rlogin_Handler);	/* install urgent data handler */

  strcpy(buff,"");		/* return port number for stderr (0 means none) */
  len = 1;
  strcpy(&buff[len],Scon.username);
  len += strlen(Scon.username) + 1;	/* userid on client side */

  strcpy(&buff[len],destuserptr);
  len += strlen(destuserptr) + 1;	/* userid on server host side */

  destuserptr = Scon.username;

  strcpy(&buff[len],"vt102/38400");
  len += 12;
  netwrite(portnum, buff, len);
  tw->echo = 1;
  tw->binary = 1;
  statline();
}

/* End of rlogin.c */
