/*********************************
 * Screen routines for the NC100 *
 *********************************/

#include <stdio.h>

// Saves the contents of $B003 (used for paging in/out the screen memory).
#asm
savemem:
        defb 0
#endasm

/*
 * Pages in the screen memory ($F000 - $FFFF).
 */
void pagein(void)
{
#asm
        ld a,($B003)
        ld (savemem),a
        ld a,67
        ld ($B003),a
        out ($13),a
#endasm
}

/*
 * Pages out the screen memory.
 */
void pageout(void)
{
#asm
        ld a,(savemem)
        ld ($B003),a
        out ($13),a
#endasm
}

void __FASTCALL__ textOut(char* s)
{
#asm
    call $B81E
#endasm
}

/*
 * Clears current window and moves cursor to top left.
 */
void txtClearWindow(void)
{
#asm
        call $B824
#endasm
}

/*
 * Moves the cursor.
 */
void txtSetCursor(unsigned char row, unsigned char col)
{
    // ENTRY - H = column (between 0 and 79)
    //         L = row (between 0 and 7)
#asm
        pop bc      ; ret addr
        pop de      ; col in E
        pop hl      ; row in L
        push hl
        push de
        push bc
        ld h,e      ; col in H
        call $B836
#endasm
}

void txtBoldOff(void)
{
#asm
        call $B83F
#endasm
}

void txtBoldOn(void)
{
#asm
        call $B842
#endasm
}

void txtInverseOff(void)
{
#asm
        call $B845
#endasm
}

void txtInverseOn(void)
{
#asm
        call $B848
#endasm
}

void txtUnderlineOff(void)
{
#asm
        call $B84B
#endasm
}

void txtUnderlineOn(void)
{
#asm
        call $B84E
#endasm
}

/*
 * Initialises the screen, i.e. clears the screen and makes sure the screen
 * buffer is fully expanded with 33 bytes per line.
 */
void cls(void)
{
    //printf("\x0C");
    txtClearWindow();
}

/*
 * Converts row/column coordinates to screen memory address.
 */
unsigned char* cyx2saddr(unsigned char row, unsigned char col)
{
    unsigned char* p;
    
    p = 0xF000;
    p += ((unsigned int) row) << 6; // add row*64
    p += col;
    
    return p;
}

/*
 * Prints a string at the specified postion.
 */
void printStringAt(char row, char col, char* s)
{
    pagein();
    txtSetCursor(row, col);
    textOut(s);
    pageout();
}
