/////////////////////////////////////////////////////////////////////////////
// GliD3D_HiLevelRender.cpp : No comment
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
// Directive

#include "GliD3D.h"
#include "gl2ideal.h"

/////////////////////////////////////////////////////////////////////////////
// Defines / Variables

/////////////////////////////////////////////////////////////////////////////
// Prototypes

/////////////////////////////////////////////////////////////////////////////
// Implements

GREXPORT FX_ENTRY void FX_CALL guAlphaSource (GrAlphaSource_t mode)
{
	TRACEFUNCTION ("guAlphaSource");

	switch (mode)
	{
	case GR_ALPHASOURCE_CC_ALPHA:
		i_grAlphaCombine (GR_COMBINE_FUNCTION_LOCAL, GR_COMBINE_FACTOR_ONE,
			GR_COMBINE_LOCAL_CONSTANT, GR_COMBINE_OTHER_NONE, FXFALSE);
//		ERROROUT("GR_ALPHASOURCE_CC_ALPHA");
		break;
	case GR_ALPHASOURCE_ITERATED_ALPHA:
		i_grAlphaCombine (GR_COMBINE_FUNCTION_LOCAL, GR_COMBINE_FACTOR_ONE,
			GR_COMBINE_LOCAL_ITERATED, GR_COMBINE_OTHER_NONE, FXFALSE);
//		ERROROUT("GR_ALPHASOURCE_ITERATED_ALPHA");
		break;
	case GR_ALPHASOURCE_TEXTURE_ALPHA:
		i_grAlphaCombine (GR_COMBINE_FUNCTION_SCALE_OTHER,
			GR_COMBINE_FACTOR_ONE, GR_COMBINE_LOCAL_NONE,
			GR_COMBINE_OTHER_TEXTURE, FXFALSE);
//		ERROROUT("GR_ALPHASOURCE_TEXTURE_ALPHA");
		break;
	case GR_ALPHASOURCE_TEXTURE_ALPHA_TIMES_ITERATED_ALPHA:
		i_grAlphaCombine (GR_COMBINE_FUNCTION_SCALE_OTHER,
			GR_COMBINE_FACTOR_LOCAL, GR_COMBINE_LOCAL_ITERATED,
			GR_COMBINE_OTHER_TEXTURE, FXFALSE);
//		ERROROUT("GR_ALPHASOURCE_TEXTURE_ALPHA_TIMES_ITERATED_ALPHA");
		break;
	}

	flushDrawState = 1;
}

GREXPORT FX_ENTRY void FX_CALL guColorCombineFunction (GrColorCombineFnc_t fnc)
{
	TRACEFUNCTION ("guColorCombineFunction");

	switch (fnc)
	{
	case GR_COLORCOMBINE_ZERO:
		i_grColorCombine (GR_COMBINE_FUNCTION_ZERO, GR_COMBINE_FACTOR_NONE,
			GR_COMBINE_LOCAL_NONE, GR_COMBINE_OTHER_NONE, FXFALSE);
//		ERROROUT("GR_COLORCOMBINE_ZERO");
		break;
	case GR_COLORCOMBINE_ITRGB:
		i_grColorCombine (GR_COMBINE_FUNCTION_LOCAL, GR_COMBINE_FACTOR_ONE,
			GR_COMBINE_LOCAL_ITERATED, GR_COMBINE_OTHER_NONE, FXFALSE);
//		ERROROUT("GR_COLORCOMBINE_ITRGB");
		break;
	case GR_COLORCOMBINE_DECAL_TEXTURE:
		i_grColorCombine (GR_COMBINE_FUNCTION_SCALE_OTHER,
			GR_COMBINE_FACTOR_ONE, GR_COMBINE_LOCAL_NONE,
			GR_COMBINE_OTHER_TEXTURE, FXFALSE);
//		ERROROUT("GR_COLORCOMBINE_DECAL_TEXTURE");
		break;
	case GR_COLORCOMBINE_TEXTURE_TIMES_CCRGB:
		i_grColorCombine (GR_COMBINE_FUNCTION_SCALE_OTHER,
			GR_COMBINE_FACTOR_LOCAL, GR_COMBINE_LOCAL_CONSTANT,
			GR_COMBINE_OTHER_TEXTURE, FXFALSE);
//		ERROROUT("GR_COLORCOMBINE_TEXTURE_TIMES_CCRGB");
		break;
	case GR_COLORCOMBINE_TEXTURE_TIMES_ITRGB:
		i_grColorCombine (GR_COMBINE_FUNCTION_SCALE_OTHER,
			GR_COMBINE_FACTOR_LOCAL, GR_COMBINE_LOCAL_ITERATED,
			GR_COMBINE_OTHER_TEXTURE, FXFALSE);
//		ERROROUT("GR_COLORCOMBINE_TEXTURE_TIMES_ITRGB");
		break;
	case GR_COLORCOMBINE_TEXTURE_TIMES_ITRGB_ADD_ALPHA:
		i_grColorCombine (GR_COMBINE_FUNCTION_SCALE_OTHER_ADD_LOCAL_ALPHA,
			GR_COMBINE_FACTOR_LOCAL, GR_COMBINE_LOCAL_ITERATED,
			GR_COMBINE_OTHER_TEXTURE, FXFALSE);
//		ERROROUT("GR_COLORCOMBINE_TEXTURE_TIMES_ITRGB_ADD_ALPHA");
		break;
	case GR_COLORCOMBINE_TEXTURE_TIMES_ALPHA:
		i_grColorCombine (GR_COMBINE_FUNCTION_SCALE_OTHER,
			GR_COMBINE_FACTOR_LOCAL_ALPHA,
			GR_COMBINE_LOCAL_ITERATED, GR_COMBINE_OTHER_TEXTURE, FXFALSE);
//		ERROROUT("GR_COLORCOMBINE_TEXTURE_TIMES_ALPHA");
		break;
	case GR_COLORCOMBINE_TEXTURE_ADD_ITRGB:
		i_grColorCombine (GR_COMBINE_FUNCTION_SCALE_OTHER_ADD_LOCAL,
			GR_COMBINE_FACTOR_ONE, GR_COMBINE_LOCAL_ITERATED,
			GR_COMBINE_OTHER_TEXTURE, FXFALSE);
//		ERROROUT("GR_COLORCOMBINE_TEXTURE_ADD_ITRGB");
		break;
	case GR_COLORCOMBINE_TEXTURE_SUB_ITRGB:
		i_grColorCombine (GR_COMBINE_FUNCTION_SCALE_OTHER_MINUS_LOCAL,
			GR_COMBINE_FACTOR_ONE, GR_COMBINE_LOCAL_ITERATED,
			GR_COMBINE_OTHER_TEXTURE, FXFALSE);
//		ERROROUT("GR_COLORCOMBINE_TEXTURE_SUB_ITRGB");
		break;
	case GR_COLORCOMBINE_CCRGB:
		i_grColorCombine (GR_COMBINE_FUNCTION_LOCAL, GR_COMBINE_FACTOR_ONE,
			GR_COMBINE_LOCAL_CONSTANT, GR_COMBINE_OTHER_NONE, FXFALSE);
//		ERROROUT("GR_COLORCOMBINE_CCRGB");
		break;
	case GR_COLORCOMBINE_ONE:
		i_grColorCombine (GR_COMBINE_FUNCTION_LOCAL, GR_COMBINE_FACTOR_NONE,
			GR_COMBINE_LOCAL_NONE, GR_COMBINE_OTHER_NONE, FXFALSE);
//		ERROROUT("GR_COLORCOMBINE_ONE");
		break;
	case GR_COLORCOMBINE_CCRGB_BLEND_ITRGB_ON_TEXALPHA:
	case GR_COLORCOMBINE_DIFF_SPEC_A:
	case GR_COLORCOMBINE_DIFF_SPEC_B:
	default:
//		ERROROUT("GR_COLORCOMBINE_SOMTHING_ELSE");
		return;
	}
	flushDrawState = 1;
}

GREXPORT FX_ENTRY int FX_CALL guEncodeRLE16 (void *dst,
	void *src,
	FxU32 width,
	FxU32 height)
{
	TRACEFUNCTION ("guEncodeRLE16");

	return 0;
}

GREXPORT FX_ENTRY FxU16 *FX_CALL
  guTexCreateColorMipMap (void)
{
	TRACEFUNCTION ("guTexCreateColorMipMap");

	return 0;
}

/////////////////////////////////////////////////////////////////////////////
