/////////////////////////////////////////////////////////////////////////////
// GliD3D_SST.cpp : No comment
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
// Directive

#include "GliD3D.h"
#include "gl2ideal.h"

/////////////////////////////////////////////////////////////////////////////
// Defines / Variables

/////////////////////////////////////////////////////////////////////////////
// Prototypes

/////////////////////////////////////////////////////////////////////////////
// Implements

FX_ENTRY void FX_CALL grSstIdle (void)
{
	TRACEFUNCTION ("grSstIdle");

}

FX_ENTRY FxU32 FX_CALL
  grSstVideoLine (void)
{
	TRACEFUNCTION ("grSstVideoLine");

	return 0;
}

FX_ENTRY FxBool FX_CALL
  grSstVRetraceOn (void)
{
	TRACEFUNCTION ("grSstVRetraceOn");

	return FXFALSE;
}

FX_ENTRY FxBool FX_CALL
  grSstIsBusy (void)
{
	TRACEFUNCTION ("grSstIsBusy");

	return FXFALSE;
}

FX_ENTRY FxBool FX_CALL
  grSstWinOpen (
	FxU32 hWnd,
	GrScreenResolution_t screen_resolution,
	GrScreenRefresh_t refresh_rate,
	GrColorFormat_t color_format,
	GrOriginLocation_t origin_location,
	int nColBuffers,
	int nAuxBuffers)
{
	TRACEFUNCTION ("grSstWinOpen");

	INT i, j;

	// Destroy old windows 
	if(g_gr_hWnd){
		wglMakeCurrent (NULL, NULL);
		wglDeleteContext (g_gr_glRC);
		ReleaseDC (g_gr_hWnd, g_gr_hDC);
		DestroyWindow (g_gr_hWnd);
	}


	// Get some info from Profile
	CHAR pszProfileName[260] = "";
	CHAR *pszSection = "Misc";	// Video info

	GetSystemDirectory (pszProfileName, sizeof (pszProfileName));
	if (pszProfileName[lstrlen (pszProfileName) - 1] != '\\')
		lstrcat (pszProfileName, "\\");
	lstrcat (pszProfileName, GLID3D_PROFILENAME);

///	g_gr_bPrecisionFix = GetPrivateProfileInt(pszSection, GLID3DPROF_VIDEO_PRECISIONFIX, TRUE, pszProfileName);
///	g_gr_bUseZInverse = GetPrivateProfileInt(pszSection, GLID3DPROF_VIDEO_USEZINVERSE, TRUE, pszProfileName);
	g_gr_bFullScreen = GetPrivateProfileInt(pszSection, GLID3DPROF_VIDEO_FULLSCREEN, TRUE, pszProfileName);
	g_gr_bUseTexEnvAdd = GetPrivateProfileInt(pszSection, GLID3DPROF_VIDEO_USETEXENVADD, TRUE, pszProfileName);
	g_gr_bUseTexEnvCombine = GetPrivateProfileInt(pszSection, GLID3DPROF_VIDEO_USETEXENVCOMBINE, TRUE, pszProfileName);
	g_gr_bUseTexEnvCombine4 = GetPrivateProfileInt(pszSection, GLID3DPROF_VIDEO_USETEXENVCOMBINE4, TRUE, pszProfileName);
///	g_gr_bUseTexEnvBlendEmu = GetPrivateProfileInt(pszSection, GLID3DPROF_VIDEO_USETEXENVBLENDEMU, TRUE, pszProfileName);
	g_gr_fogMode = GetPrivateProfileInt(pszSection, GLID3DPROF_VIDEO_FOG_MODE, 1, pszProfileName);
	g_gr_fogFactor = GetPrivateProfileInt(pszSection, GLID3DPROF_VIDEO_FOG_FACTOR, 100, pszProfileName);
	g_gr_nWinCustom = GetPrivateProfileInt(pszSection, GLID3DPROF_VIDEO_WIN_CUSTOM, 0, pszProfileName);
	g_gr_nWinWidth = GetPrivateProfileInt(pszSection, GLID3DPROF_VIDEO_WIN_WIDTH, 0, pszProfileName);
	g_gr_nWinHeight = GetPrivateProfileInt(pszSection, GLID3DPROF_VIDEO_WIN_HEIGHT, 0, pszProfileName);
	g_gr_glHint = GetPrivateProfileInt(pszSection, GLID3DPROF_VIDEO_GL_HINT, 0, pszProfileName);
	g_gr_fix1 = GetPrivateProfileInt(pszSection, GLID3DPROF_VIDEO_FIX1, 0, pszProfileName);


	// Initialize system variables

	// Initialize states
	g_gr_hWnd = NULL;
	g_gr_nWidth = 0;
	g_gr_nHeight = 0;
	g_gr_bOpenedWindow = TRUE;

	// System
	g_gr_state.color_format = GR_COLORFORMAT_ABGR;
	g_gr_state.origin_location = GR_ORIGIN_UPPER_LEFT;
	g_gr_state.render_buffer = GR_BUFFER_BACKBUFFER;
	g_gr_state.cull_mode = GR_CULL_DISABLE;

	// Clip window
//  	g_gr_state.clip_window_minx = 0;
//  	g_gr_state.clip_window_miny = 0;
//  	g_gr_state.clip_window_maxx = 640;
//  	g_gr_state.clip_window_maxy = 480;

	// Chromakey
//  	g_gr_state.chromakey_mode = GR_CHROMAKEY_DISABLE;
//  	g_gr_state.chromakey_value = 0;

	// Depth buffer
	g_gr_state.depth_buffer_mode = GR_DEPTHBUFFER_DISABLE;
	g_gr_state.depth_mask = FXTRUE;
	g_gr_state.depth_buffer_function = GR_CMP_LEQUAL;
	g_gr_state.depth_bias_level = 0;

	// Color combine
	g_gr_state.constant_color_value = 0;
	g_gr_state.color_combine_function = GR_COMBINE_FUNCTION_LOCAL;
	g_gr_state.color_combine_factor = GR_COMBINE_FACTOR_NONE;
	g_gr_state.color_combine_local = GR_COMBINE_LOCAL_CONSTANT;
	g_gr_state.color_combine_other = GR_COMBINE_OTHER_NONE;

	// Alpha combine / function
	g_gr_state.alpha_combine_function = GR_COMBINE_FUNCTION_LOCAL;
	g_gr_state.alpha_combine_factor = GR_COMBINE_FACTOR_NONE;
	g_gr_state.alpha_combine_local = GR_COMBINE_LOCAL_CONSTANT;
	g_gr_state.alpha_combine_other = GR_COMBINE_OTHER_NONE;
	g_gr_state.alpha_blend_function_rgb_sf = GR_BLEND_ONE;
	g_gr_state.alpha_blend_function_rgb_df = GR_BLEND_ZERO;
	g_gr_state.alpha_blend_function_alpha_sf = GR_BLEND_ZERO;
	g_gr_state.alpha_blend_function_alpha_df = GR_BLEND_ZERO;

	// TMU
	for (i = 0; i < GLID3D_NUM_TMU; i++){
		for (j = 0; j <= GLID3D_TEXMAXADDRESS; j++) {
			g_gr_tmu[i].texture[j].texId = TEXID_INVALID;
		}
	}


	// Setup video mode and 3d device
	if (hWnd)
		g_gr_hWndOld = (HWND) hWnd;
	else
		g_gr_hWndOld = GetActiveWindow ();


	switch (screen_resolution)
	{
	case GR_RESOLUTION_320x240:
		g_gr_nWidth = 320;
		g_gr_nHeight = 240;
		break;
	case GR_RESOLUTION_512x384:
		g_gr_nWidth = 512;
		g_gr_nHeight = 384;
		break;
	case GR_RESOLUTION_640x400:
		g_gr_nWidth = 640;
		g_gr_nHeight = 400;
		break;
	case GR_RESOLUTION_640x480:
	default:
		g_gr_nWidth = 640;
		g_gr_nHeight = 480;
		break;
	case GR_RESOLUTION_800x600:
		g_gr_nWidth = 800;
		g_gr_nHeight = 600;
		break;
	case GR_RESOLUTION_1024x768:
		g_gr_nWidth = 1024;
		g_gr_nHeight = 768;
		break;
	case GR_RESOLUTION_1280x1024:
		g_gr_nWidth = 1280;
		g_gr_nHeight = 1024;
		break;
	case GR_RESOLUTION_1600x1200:
		g_gr_nWidth = 1600;
		g_gr_nHeight = 1200;
		break;
	}
	if(!g_gr_nWinCustom){
		g_gr_nWinWidth = g_gr_nWidth;
		g_gr_nWinHeight = g_gr_nHeight;
	}

	g_gr_state.color_format = color_format;
	g_gr_state.origin_location = origin_location;
//  	g_gr_state.clip_window_minx = 0;
//  	g_gr_state.clip_window_miny = 0;
//  	g_gr_state.clip_window_maxx = g_gr_nWidth;
//  	g_gr_state.clip_window_maxy = g_gr_nHeight;

	InitBlendMap ();

//	g_gr_hWnd = CreateOpenGLWindow (g_gr_hWndOld, "GlideWrapper", 0, 0, g_gr_nWidth, g_gr_nHeight,
	g_gr_hWnd = CreateOpenGLWindow (g_gr_hWndOld, "GlideWrapper", 0, 0, g_gr_nWinWidth, g_gr_nWinHeight,
		PFD_TYPE_RGBA, PFD_DOUBLEBUFFER);
	if (g_gr_hWnd == NULL){
		ERROROUT("Error in CreateOpenGLWindow()");
		return FXFALSE;
	}

	g_gr_hDC = GetDC (g_gr_hWnd);
	g_gr_glRC = wglCreateContext (g_gr_hDC);
	wglMakeCurrent (g_gr_hDC, g_gr_glRC);

	UpdateWindow (g_gr_hWnd);
	BringWindowToTop (g_gr_hWnd);
	SetForegroundWindow (g_gr_hWndOld);
	SetActiveWindow (g_gr_hWndOld);
	glDisable (GL_FOG);
	//glDisable (GL_DITHER);

#ifdef USEVERTEXARRAY
	glEnableClientState(GL_VERTEX_ARRAY);
	glEnableClientState(GL_COLOR_ARRAY);
	glEnableClientState(GL_TEXTURE_COORD_ARRAY);
	glTexCoordPointer (2, GL_FLOAT, 0, TexCoordArray);
	glColorPointer( 4, GL_FLOAT, 0, ColorArray);
	glVertexPointer( 4, GL_FLOAT, 0, CoordArray);
	ArrayCount = 0;
#else
#ifdef CACHETRIANGLES
	g_gr_DrawingTriangles = FALSE;
#endif	//CACHETRIANGLES
#endif	//USEVERTEXARRAY

	glTexEnvi(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE);
	g_gr_texenv = GL_MODULATE;
	glDisable(GL_BLEND);
	g_gr_BlendOn = FALSE;
	glEnable(GL_ALPHA_TEST);
	g_gr_AlphaTestOn = TRUE;
	glDisable(GL_TEXTURE_2D);
	g_gr_Texture2DOn = FALSE;
	glDepthFunc (GL_LEQUAL);
	g_gr_state.depth_buffer_function = GR_CMP_LEQUAL;

	glPixelStorei(GL_UNPACK_ALIGNMENT, 4);		// Force 4-byte alignment
	glPixelStorei(GL_UNPACK_ROW_LENGTH, 0);
	glPixelStorei(GL_UNPACK_SKIP_ROWS, 0);
	glPixelStorei(GL_UNPACK_SKIP_PIXELS, 0);

	GLenum	hint = GL_NICEST;
	bool	smooth = true;
	switch(g_gr_glHint){
	case 0:
		hint = GL_FASTEST;
		smooth = false;
		break;
	case 1:
		hint = GL_DONT_CARE;
		break;
	};
	glHint (GL_PERSPECTIVE_CORRECTION_HINT, hint);
	glHint (GL_LINE_SMOOTH_HINT, hint);
	glHint (GL_POINT_SMOOTH_HINT, hint);
	glHint (GL_POLYGON_SMOOTH_HINT, hint);
	glHint (GL_FOG_HINT, hint);
	if(smooth){
		glEnable(GL_POINT_SMOOTH);
		glEnable(GL_LINE_SMOOTH);
		glEnable(GL_POLYGON_SMOOTH);
	}
	GLfloat	color[] = { 1.0, 1.0, 1.0, 1.0};
	glFogfv(GL_FOG_COLOR, color);

	grSstOrigin(origin_location);

	InitGLExt();
	InitDrawState();
	InitCombineSetup();

	return FXTRUE;
}

FX_ENTRY void FX_CALL grSstWinClose (void)
{
	TRACEFUNCTION ("grSstWinClose");
	FlushTriangleVertex();
	INT i, j;

	for (i = 0; i < GLID3D_NUM_TMU; i++)
	{
		for (j = 0; j <= GLID3D_TEXMAXADDRESS; j++)
		{
			if(g_gr_tmu[i].texture[j].texId != TEXID_INVALID)
			 glDeleteTextures (1, &g_gr_tmu[i].texture[j].texId);
		}
	}

	if(g_gr_hWnd){
		wglMakeCurrent (NULL, NULL);
		wglDeleteContext (g_gr_glRC);
		ReleaseDC (g_gr_hWnd, g_gr_hDC);
		DestroyWindow (g_gr_hWnd);
		ChangeDisplaySettings (0, 0);
		g_gr_hWnd = NULL;
	}

	return;
}

/* enable disable 3dfx view */
FX_ENTRY FxBool FX_CALL
  grSstControl (FxU32 code)
{
	TRACEFUNCTION ("grSstControl");

	return GR_CONTROL_ACTIVATE;
}

FX_ENTRY FxBool FX_CALL
  grSstQueryHardware (GrHwConfiguration * hwconfig)
{
	TRACEFUNCTION ("grSstQueryHardware");

	hwconfig->num_sst = 1;
	hwconfig->SSTs[0].type = GR_SSTTYPE_VOODOO;
	hwconfig->SSTs[0].sstBoard.VoodooConfig.fbRam = 2;
	hwconfig->SSTs[0].sstBoard.VoodooConfig.fbiRev = 2;
	hwconfig->SSTs[0].sstBoard.VoodooConfig.nTexelfx = 1;
	hwconfig->SSTs[0].type = GR_SSTTYPE_VOODOO;
	hwconfig->SSTs[0].sstBoard.VoodooConfig.sliDetect = FXFALSE;
	for (INT i = 0; i < GLIDE_NUM_TMU; i++)
	{
		hwconfig->SSTs[0].sstBoard.VoodooConfig.tmuConfig[i].tmuRam = 2;
		hwconfig->SSTs[0].sstBoard.VoodooConfig.tmuConfig[i].tmuRev = 1;
	}

	return FXTRUE;
}

FX_ENTRY FxBool FX_CALL
  grSstQueryBoards (GrHwConfiguration * hwconfig)
{
	TRACEFUNCTION ("grSstQueryBoards");

	return grSstQueryHardware(hwconfig);
}

#ifdef PRJ_PERSPECTIVE
#include <GL/glu.h>
#endif // PRJ_PERSPECTIVE

FX_ENTRY void FX_CALL grSstOrigin (GrOriginLocation_t origin)
{
	TRACEFUNCTION ("grSstOrigin");

	GLfloat	top, bottom;
	GLint	front;

	FlushTriangleVertex();

	glLoadIdentity ();
	glViewport (0, 0, g_gr_nWinWidth, g_gr_nWinHeight);

	g_gr_state.origin_location = origin;

	if(g_gr_state.origin_location == GR_ORIGIN_UPPER_LEFT){
		top = 0.0f;
		bottom = g_gr_nHeight;
		front = GL_CCW;
	}else{
		top = g_gr_nHeight;
		bottom = 0.0f;
		front = GL_CW;
	}

	glFrontFace(front);

	glMatrixMode (GL_PROJECTION);
	glLoadIdentity ();
#ifdef PRJ_PERSPECTIVE
	if(g_gr_state.origin_location == GR_ORIGIN_UPPER_LEFT){
		glTranslatef(-1, 1, 0);
	}else{
		glTranslatef(-1, -1, 0);
	}
	gluPerspective(90, 1, fPrecisionFix, 65536);
	glScalef(2.0/g_gr_nWidth, 2.0/(top - bottom), 1);
#else
	if (g_gr_bUseZInverse) {
		if (g_gr_bPrecisionFix)
			glOrtho (0, g_gr_nWidth, bottom, top, -1/fPrecisionFix, 0);
		else
			glOrtho (0, g_gr_nWidth, bottom, top, -1.05f, 0.01);
	}else{
		glOrtho (0, g_gr_nWidth, bottom, top, 0.0f, -1.0f);
	}
#endif // PRJ_PERSPECTIVE
	glMatrixMode (GL_MODELVIEW);
}

FX_ENTRY void FX_CALL grSstSelect (int which_sst)
{
	TRACEFUNCTION ("grSstSelect");

}

FX_ENTRY FxU32 FX_CALL
  grSstScreenHeight (void)
{
	TRACEFUNCTION ("grSstScreenHeight");

	return g_gr_nHeight;
}

FX_ENTRY FxU32 FX_CALL
  grSstScreenWidth (void)
{
	TRACEFUNCTION ("grSstScreenWidth");

	return g_gr_nWidth;
}

FX_ENTRY FxU32 FX_CALL
  grSstStatus (void)
{
	TRACEFUNCTION ("grSstStatus");

	return 1;
}
