#include "stdafx.h"

int texWidth, texHeight;
FxU32 curStartAddress;
GrTexInfo curTexInfo;

extern TEXINFO texInfo;

extern "C" __declspec(dllexport)
void grTexSource(GrChipID_t tmu,
                 FxU32 startAddress,
                 FxU32 evenOdd,
                 GrTexInfo *info)
{
   curTexInfo = *info;
   curStartAddress = startAddress;

   glBindTexture(GL_TEXTURE_2D, startAddress + 1);
   glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, texInfo.magFilter);
   glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, texInfo.minFilter);
   glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, texInfo.wraps);
   glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, texInfo.wrapt);

   texHeight = 256;
	texWidth = 256;

	switch(info->aspectRatio)
	{
		case GR_ASPECT_8x1:
			texHeight >>= 3;
         break;
		case GR_ASPECT_4x1:
			texHeight >>= 2;
			break;
		case GR_ASPECT_2x1:
			texHeight >>= 1;
			break;
		case GR_ASPECT_1x1:
			break;
		case GR_ASPECT_1x2:
			texWidth >>= 1;
			break;
		case GR_ASPECT_1x4:
			texWidth >>= 2;
			break;
		case GR_ASPECT_1x8:
			texWidth >>= 3;
			break;
	}
   
   if(texHeight == 0) texHeight = 1;
   if(texWidth == 0) texWidth = 1;
}