// 2003.03.12, 2005.04
//****************************************
//**  Copyright  (C)  W.ch  1999-2005   **
//**  Web:  http://www.winchiphead.com  **
//****************************************
//**  EXE for PCI interface chip CH365  **
//**  C, VC5.0                          **
//****************************************
//
// PCI߽ӿоƬCH365Ӧòʾ V1.2
// Ͼߺ޹˾  : W.ch 2005.04
// л: Windows 98/ME, Windows 2000/XP
//


#include	<windows.h>
#include	<stdio.h>
#include	<stdlib.h>
#include    <malloc.h>
#include	<string.h>
#include    <iostream.h>
#include    <string.h>
#include	"CH365DLL.H"
#include	"DEBUG365.H"

HINSTANCE   mSaveInstance;		// ʵ
HWND        mSaveDialogMain;	// Ի

CHAR	mCaptionInform[] = " Ϣʾ ";
UINT	mIndex;
mPCH365_IO_REG mBaseAddr;
mPCH365_MEM_REG mMemAddr;
USHORT Off;

typedef struct _VAR_TYPE{
	union{
		UCHAR cVar;
		UINT iVar;
		USHORT sVar;
		ULONG lVar;
	};
}	mVAR_TYPE, *mpVAR_TYPE;
typedef UCHAR pOut[8];


LRESULT CALLBACK mDialogMain( HWND, UINT, WPARAM, LPARAM );
UCHAR	mCharToBcd(	UCHAR iChar);				//ASCIIַתΪһλBCD
mVAR_TYPE mCharToVar( UCHAR *, UINT, UINT );	//ַתֵ
void mSetI2C(HWND hDialog,int iIndex);			//I2Cд
void AddrRefresh( HWND, int );					//ȡַ
void mMemReadWrite( HWND );					//洢д
void mIOReadWrite( HWND );						//I/O˿ڶд
void mConReadWrite( HWND );						//ÿռд
void mSetA15( HWND );							//A15_A8
int GetDevIndex( HWND );						//ȡ豸
BOOL mCheckWord(PVOID,int);						//ֺ˫ֵַ
void mInitCheckBox( HWND );						//ʼĬѡеѡ
void mShowDllVer( HWND );						//ʾDLL汾
void mShowDevVer( HWND );						//ʾ汾

//
int	APIENTRY	WinMain( HINSTANCE hInstance, HINSTANCE hPrevInst, LPSTR lpCmdLine, int nShowCmd )
{
	mSaveInstance = hInstance;
	if( DialogBox( hInstance, "IDD_MAIN", NULL, mDialogMain ) == -1)
		return 0 ;    //Ի
	else
		return 1;
}

//Ի¼
LRESULT CALLBACK mDialogMain( HWND hDialog, UINT uMessage, WPARAM wParam, LPARAM lParam )
{

	switch( uMessage )
	{
		case WM_INITDIALOG:        //ʼ
		{
				mSaveDialogMain = hDialog;
				mIndex = 0;
				SetDlgItemText(hDialog,IDC_EDTINDEX,"0");
				mInitCheckBox( hDialog );		
				// ҪʹDLLҪȼ
#ifdef _WIN64
				if ( LoadLibrary( "CH365DLL64.DLL" ) == NULL )  // DLLʧ,δװϵͳ
#else
                if ( LoadLibrary( "CH365DLL.DLL" ) == NULL )  // DLLʧ,δװϵͳ
#endif
				{
					MessageBox( hDialog, "޷CH365DLL", mCaptionInform, MB_ICONSTOP | MB_OK );
					EndDialog( hDialog, 0x81 );  // رնԻ
					return( TRUE );
				}
				if ( CH365mOpenDevice( mIndex,TRUE,TRUE ) == INVALID_HANDLE_VALUE )  // ʹ֮ǰ豸 
				{
					MessageBox( hDialog, "޷CH365豸", mCaptionInform, MB_ICONSTOP | MB_OK );
					EndDialog( hDialog, 0x81 );  // رնԻ
					return( TRUE );
				}   
			
				mShowDllVer(hDialog);		//ʾDLL汾			1
				mShowDevVer(hDialog);		//ʾ汾		
		}
			return (TRUE);
			break;

		case WM_COMMAND:
		{
			switch(LOWORD(wParam))
			{
				case IDC_BTNIO:            //I/O˿ڶдһֽ
					{
						mIOReadWrite(hDialog);
					}
					return (TRUE);
					break;

				case IDC_BTNCONBYTE:                 //ÿռĶд
					{
						mConReadWrite( hDialog );
					}
					return (TRUE);
					break;

				case IDC_BTNMEM:                 //洢Ķд
					{
						 mMemReadWrite(hDialog);
					}
					return (TRUE);
					break;
				case IDC_BTNI2C:                 //I2Cӿڲ
					{
						mIndex = GetDevIndex(hDialog);
						mSetI2C( hDialog,mIndex );
					}
					return (TRUE);
					break;
				case IDC_BTNA15:
					{
						mSetA15( hDialog );			//A15_A8			
					}
					return (TRUE);
					break;
				case IDC_REFRESH:
					{
						mIndex = GetDevIndex(hDialog);
						AddrRefresh(hDialog, mIndex);
					}
					return (TRUE);
					break;
				case IDC_CLOSE:						//ر豸
					{
						mIndex = GetDevIndex(hDialog); 
						CH365mCloseDevice(mIndex);  
					}
					return (TRUE);
					break;
				case IDC_OPEN:						//豸
					{
						mIndex = GetDevIndex(hDialog); 
						if ( CH365mOpenDevice(mIndex, TRUE, TRUE ) == INVALID_HANDLE_VALUE )  
						{
							MessageBox( hDialog, "޷CH365豸", mCaptionInform, MB_ICONSTOP | MB_OK );
							return( TRUE );
						}
					}
					return (TRUE);
					break;
				case IDC_RADI2CA15:
					{
						CheckDlgButton(hDialog,IDC_RADI2CA15,BST_CHECKED);
						CheckDlgButton(hDialog,IDC_RADI2CSYS,BST_UNCHECKED);
					}
					return (TRUE);
					break;
				case IDC_RADI2CSYS:
					{
						CheckDlgButton(hDialog,IDC_RADI2CSYS,BST_CHECKED);
						CheckDlgButton(hDialog,IDC_RADI2CA15,BST_UNCHECKED);
					}
					return (TRUE);
					break;
				case IDC_EXIT:
				case WM_DESTROY:                     //˳  
					EndDialog(hDialog,1);
					return (TRUE);
					break;
			}
		}
		return (TRUE);
		break;
	}
	return (FALSE);  
}

// ASCIIַתΪһλBCD,Чַ0-9,A-F,a-f,Чַ0FFH
UCHAR	mCharToBcd(UCHAR	iChar )  // ASCIIַ
{
	UCHAR	mBCD;
	if ( iChar >= '0' && iChar <= '9' ) mBCD = iChar -'0';
	else if ( iChar >= 'A' && iChar <= 'Z' ) mBCD = iChar - 'A' + 0x0a;
	else if ( iChar >= 'a' && iChar <= 'z' ) mBCD = iChar - 'a' + 0x0a;
	else mBCD = 0xff;
	return( mBCD );
}

// ַתֵ
mVAR_TYPE mCharToVar(UCHAR * sChar,UINT sLen,UINT sFlag)
{
	UINT i;
	mVAR_TYPE mVarType;
	if(sLen != 0)
	{
		if(sLen > 1)	//ַȴ1
		{
			if(sFlag == 1)		//sFlagΪ1 ʾULONG
			{
				ULONG lReturn = 0;
				for(i=0;i<sLen;i++)	
				{
					lReturn <<= 4;
					lReturn |= mCharToBcd(sChar[i]); 
				}
				mVarType.lVar = lReturn;
			}
			else if(sFlag == 0)		//sFlagΪ0 ʾUSHORT
			{
				USHORT sReturn = 0;
				for(i=0;i<sLen;i++)
				{
					sReturn <<= 4;
					sReturn |= mCharToBcd(sChar[i]);
				}
				mVarType.sVar = sReturn;
			}
			else if(sFlag == 2)		//sFlagΪ2 ʾUINT
			{
				UINT iReturn = 0;
				for(i=0;i<sLen;i++)
				{
					iReturn <<= 4;
					iReturn |= mCharToBcd(sChar[i]);
				}
				mVarType.iVar = iReturn;
			}
			else if(sFlag == 3)
			{
				UCHAR cReturn = 0;
				cReturn = (mCharToBcd(sChar[0])<<4) | mCharToBcd(sChar[1]);
				mVarType.cVar = cReturn;
			}
		}
		else	//ַȵ1
		{
			mVarType.lVar = mCharToBcd(sChar[0]);
			mVarType.sVar = mCharToBcd(sChar[0]);
			mVarType.iVar = mCharToBcd(sChar[0]);
			mVarType.cVar = mCharToBcd(sChar[0]);
		}
	}
	else
	{
		mVarType.iVar = 0;
		mVarType.lVar = 0;
		mVarType.sVar = 0;
		mVarType.cVar = 0;
	}
	return mVarType;
}

void mIOReadWrite(HWND hDialog)
{
	mVAR_TYPE mVarType;
	UCHAR iAddr[8];
	UINT iAddrLen = 0;
	USHORT mAddr=0;
	iAddrLen = GetDlgItemText(hDialog,IDC_EDTIOADDR,iAddr,5);	
	mVarType = mCharToVar(iAddr,iAddrLen,0);	//ȡֵַ		
	mAddr = mVarType.sVar;
	mIndex = GetDevIndex(hDialog);
	/*********I/O˿ֽڶд********/
	if(IsDlgButtonChecked(hDialog,IDC_RADIOBYTE) == BST_CHECKED)  
	{
		UCHAR oByte[8];
		UCHAR cByte;
		//ֽ
		if (IsDlgButtonChecked(hDialog,IDC_RADIOREAD) == BST_CHECKED)
		{
			if(iAddrLen)
			{
				if(IsDlgButtonChecked(hDialog,IDC_RADOFF) == BST_CHECKED)	//ƫƵַ
				{	//I/O˿ڶ
					if(CH365mReadIoByte( mIndex, &mBaseAddr->mCh365IoPort[mAddr], &cByte ))
					{
						UCHAR sByte[8];
						sprintf( sByte,"%02X\x0", cByte);
						SetDlgItemText(hDialog,IDC_EDTIODATA,sByte);
					}
					else
						MessageBox(hDialog,"ʧܣ","ʾ",MB_OK|MB_ICONSTOP);
				}
				else if(IsDlgButtonChecked(hDialog,IDC_RADIME) == BST_CHECKED)	//ֱӵַ
				{
					if(CH365mReadIoByte( mIndex, (PVOID)mAddr, &cByte ))
					{
						UCHAR sByte[8];
						sprintf( sByte,"%02X\x0", cByte);
						SetDlgItemText(hDialog,IDC_EDTIODATA,sByte);
					}
					else
						MessageBox(hDialog,"ʧܣ","ʾ",MB_OK|MB_ICONSTOP);
					}
				}
			else
				MessageBox(hDialog,"ַ!","ʾ",MB_OK);
		}
		//дֽ
		else if(IsDlgButtonChecked(hDialog,IDC_RADIOWRITE) == BST_CHECKED)
		{
			UINT oByteLen;
			mVAR_TYPE mVarByte;
			oByteLen = GetDlgItemText(hDialog,IDC_EDTIODATA,oByte,5);	//ȡ
			mVarByte = mCharToVar(oByte,oByteLen,3);		//תΪӦֵ
			cByte = mVarByte.cVar;
			if( iAddrLen && oByteLen )	//дַͿݲΪ
			{
				if(IsDlgButtonChecked(hDialog,IDC_RADOFF) == BST_CHECKED)	//ƫƵַ
				{
					//I/O˿д
					if(CH365mWriteIoByte(mIndex, &mBaseAddr->mCh365IoPort[mAddr], cByte))
						MessageBox(hDialog,"дݳɹ","ʾ",MB_OK);
					else
						MessageBox(hDialog,"дʧܣ","ʾ",MB_OK|MB_ICONSTOP);
				}
				else if(IsDlgButtonChecked(hDialog,IDC_RADIME) == BST_CHECKED)	//ֱӵַ
				{
					//I/O˿д
					if(CH365mWriteIoByte(mIndex, (PVOID)mAddr, cByte))
						MessageBox(hDialog,"дݳɹ","ʾ",MB_OK);
					else
						MessageBox(hDialog,"дʧܣ","ʾ",MB_OK|MB_ICONSTOP);
				}
			}
			else
				MessageBox(hDialog,"ַ!","ʾ",MB_OK);
		}
	}
	/************I/O˿ֲ****************/
	else if(IsDlgButtonChecked(hDialog,IDC_RADIOWORD) == BST_CHECKED)
	{
		UCHAR cWord[8];      //
		UINT num;
		USHORT oWord = 0;
		//Ƿֵַͷ	
		if(!mCheckWord((PVOID)mAddr,4))
		{
			MessageBox(hDialog,"ܴ洢ֵʼַ","ʾ",MB_OK|MB_ICONSTOP);
			return;
		}
		if (IsDlgButtonChecked(hDialog,IDC_RADIOREAD) == BST_CHECKED)	//ѡж
		{
			if( iAddrLen )
			{
				if(IsDlgButtonChecked(hDialog,IDC_RADOFF) == BST_CHECKED)	//ƫƵַ
				{
					if(CH365mReadIoWord( mIndex, &mBaseAddr->mCh365IoPort[mAddr], &oWord ))	//I/O˿ڶһ
					{
						UCHAR sByte[8];
						sprintf( sByte,"%02X%02X\x0", oWord & 0xFF, (oWord>>8) & 0xFF );
						SetDlgItemText(hDialog,IDC_EDTIODATA,sByte);	//
					}
					else
						MessageBox(hDialog,"ʧܣ","ʾ",MB_OK|MB_ICONSTOP);	
				}
				else if(IsDlgButtonChecked(hDialog,IDC_RADIME) == BST_CHECKED)	//ֱӵַ
				{
					if(CH365mReadIoWord( mIndex, (PVOID)mAddr, &oWord ))	//I/O˿ڶһ
					{
						UCHAR sByte[8];
						sprintf( sByte,"%02X%02X\x0", oWord & 0xFF, (oWord>>8) & 0xFF );
						SetDlgItemText(hDialog,IDC_EDTIODATA,sByte);	//
					}
					else
						MessageBox(hDialog,"ʧܣ","ʾ",MB_OK|MB_ICONSTOP);	
				}
			}
			else
				MessageBox(hDialog,"˿ڵַ","ʾ",MB_OK);		
		}
		else if(IsDlgButtonChecked(hDialog,IDC_RADIOWRITE) == BST_CHECKED)	//ѡд
		{
			num = GetDlgItemText(hDialog,IDC_EDTIODATA,cWord,5);	//ȡ						
			if( iAddrLen &&	num )  //ȡַ
			{
				mVAR_TYPE mVarWord;
				mVarWord = mCharToVar(cWord,num,0);		//תΪӦֵ
				oWord = mVarWord.sVar;
				if(IsDlgButtonChecked(hDialog,IDC_RADOFF) == BST_CHECKED)	//ƫƵַ
				{
					if(CH365mWriteIoWord(mIndex, &mBaseAddr->mCh365IoPort[mAddr], oWord))	//I/O˿дһ
						MessageBox(hDialog,"дݳɹ","ʾ",MB_OK);
					else
						MessageBox(hDialog,"дʧܣ","ʾ",MB_OK|MB_ICONSTOP);
				}
				else if(IsDlgButtonChecked(hDialog,IDC_RADIME) == BST_CHECKED)	//ֱӵַ
				{
					if(CH365mWriteIoWord(mIndex, (PVOID)mAddr, oWord))	//I/O˿дһ
						MessageBox(hDialog,"дݳɹ","ʾ",MB_OK);
					else
						MessageBox(hDialog,"дʧܣ","ʾ",MB_OK|MB_ICONSTOP);
				}
			}
			else
				MessageBox(hDialog,"ַݣ","ʾ",MB_OK);
		}
	}
	/**********I/O˿˫ֲ*************/
	else if(IsDlgButtonChecked(hDialog,IDC_RADIODWORD) == BST_CHECKED)
	{
		ULONG oDword = 0;
		UCHAR cDword[12];      //
		ULONG num;
		//Ƿ˫ֵַͷ							
		if(!mCheckWord((PVOID)mAddr,8))
		{
			MessageBox(hDialog,"ܴ洢˫ֵʼַ","ʾ",MB_OK|MB_ICONSTOP);
			return;
		}
		//ѡI/O˿ڶ
		if (IsDlgButtonChecked(hDialog,IDC_RADIOREAD) == BST_CHECKED)	
		{
			if(iAddrLen)
			{
				if(IsDlgButtonChecked(hDialog,IDC_RADOFF) == BST_CHECKED)	//ƫƵַ
				{
					//I/O˿ڶȡһ˫
					if(CH365mReadIoDword( mIndex, &mBaseAddr->mCh365IoPort[mAddr], &oDword ))
					{
						UCHAR sByte[12];
						sprintf( sByte,"%02X%02X%02X%02X\x0", oDword & 0xFF, (oDword>>8) & 0xFF, (oDword>>16) & 0xFF, (oDword>>24) & 0xFF );
						SetDlgItemText( hDialog, IDC_EDTIODATA, sByte );	//ֵ
					}
					else
						MessageBox(hDialog,"ʧܣ","ʾ",MB_OK|MB_ICONSTOP);
				}
				else if(IsDlgButtonChecked(hDialog,IDC_RADIME) == BST_CHECKED)	//ֱӵַ
				{
					//I/O˿ڶȡһ˫
					if(CH365mReadIoDword( mIndex,(PVOID)mAddr, &oDword ))
					{
						UCHAR sByte[12];
						sprintf( sByte,"%02X%02X%02X%02X\x0", oDword & 0xFF, (oDword>>8) & 0xFF, (oDword>>16) & 0xFF, (oDword>>24) & 0xFF );
						SetDlgItemText( hDialog, IDC_EDTIODATA, sByte );	//ֵ
					}
					else
						MessageBox(hDialog,"ʧܣ","ʾ",MB_OK|MB_ICONSTOP);
				}
			}
			else		//ȡַ
				MessageBox(hDialog,"˿ڵַ","ʾ",MB_OK);
		}
		//ѡI/O˿д
		else if(IsDlgButtonChecked(hDialog,IDC_RADIOWRITE) == BST_CHECKED)
		{
			num = GetDlgItemText(hDialog,IDC_EDTIODATA,cDword,9);	//ȡ	
			if( iAddrLen &&	num)	//ȡַ
			{
				mVAR_TYPE mTypeDword;
				mTypeDword = mCharToVar(cDword,num,1);
				oDword = mTypeDword.lVar;
				if(IsDlgButtonChecked(hDialog,IDC_RADOFF) == BST_CHECKED)	//ƫƵַ
				{
					if(CH365mWriteIoDword(mIndex, &mBaseAddr->mCh365IoPort[mAddr], oDword))	//I/O˿дһ˫
						MessageBox(hDialog,"дݳɹ","ʾ",MB_OK);
					else
						MessageBox(hDialog,"дʧܣ","ʾ",MB_OK|MB_ICONSTOP);
				}
				else if(IsDlgButtonChecked(hDialog,IDC_RADIME) == BST_CHECKED)	//ֱӵַ
				{
					if(CH365mWriteIoDword(mIndex, (PVOID)mAddr, oDword))	//I/O˿дһ˫
						MessageBox(hDialog,"дݳɹ","ʾ",MB_OK);
					else
						MessageBox(hDialog,"дʧܣ","ʾ",MB_OK|MB_ICONSTOP);
				}
			}
			else
				MessageBox(hDialog,"!","ʾ",MB_OK);
		}									
	}
	else
	{
		MessageBox(hDialog,"ѡдֽڡֻ˫֣","ʾ",MB_OK);
	}
}

//ȡI/Oַ洢ַжϺ
void AddrRefresh(HWND hDialog,int iIndex)
{
	ULONG oIntLine;
	//ȡжϺ
//	mPCH365_IO_REG  mBase=NULL;
	if(CH365mGetIntLine(iIndex, &oIntLine)) {
		UCHAR sByte[128];
		sprintf( sByte,"%02X\x0", oIntLine );
		SetDlgItemText(hDialog,IDC_EDTINTLINE,sByte);
	}
	else
	{
		MessageBox(hDialog,"жϺʧܣ","ʾ",MB_OK|MB_ICONSTOP);
		SetDlgItemText(hDialog,IDC_EDTINTLINE,"");
	}
	//ȡI/Oַ
	if(CH365mGetIoBaseAddr(iIndex, &mBaseAddr))
	{
		CHAR sByte[128]="";
		sprintf( sByte,"%04p\x0", mBaseAddr );
		SetDlgItemText(hDialog,IDC_EDTBASEADDR,sByte);
	}
	else
	{
		MessageBox(hDialog,"I/Oַʧܣ","ʾ",MB_OK|MB_ICONSTOP);
		SetDlgItemText(hDialog,IDC_EDTBASEADDR,"");
	}
	//ȡ洢ַ
	if(CH365GetMemBaseAddr( &mMemAddr ))
	{
		CHAR sByte[128]="";
		sprintf( sByte,"%04p\x0", mMemAddr );
		SetDlgItemText(hDialog,IDC_EDTMEM,sByte);
	}
	else
	{
		MessageBox(hDialog,"üĴַʧܣ","ʾ",MB_OK|MB_ICONSTOP);
		SetDlgItemText(hDialog,IDC_EDTMEM,"");
	}

}

void mMemReadWrite(HWND hDialog)
{
	UCHAR iAddr[128];    //ַ
	USHORT mAddr=0;
	UINT MemAddrLen;
	mVAR_TYPE mVarType;
	MemAddrLen = GetDlgItemText(hDialog,IDC_EDTMEMADDR,iAddr,5);
	mIndex = GetDevIndex(hDialog);
	//ȡַת
	mVarType = mCharToVar(iAddr,MemAddrLen,0);
	mAddr = mVarType.sVar;
	//ѡжֽڲ
	if(IsDlgButtonChecked(hDialog,IDC_RADMEMBYTE) == BST_CHECKED)   
	{
		UCHAR cByte;
		if (IsDlgButtonChecked(hDialog,IDC_RADMEMREAD) == BST_CHECKED)	//ѡж
		{
			if(MemAddrLen)
			{
				if(CH365mReadMemByte( mIndex, &mMemAddr->mCh365MemPort[mAddr], &cByte ))   // Ӵ洢ȡһֽ
				{
					UCHAR sByte[8];
					sprintf( sByte,"%02X\x0", cByte );
					SetDlgItemText(hDialog,IDC_EDTMEMDATA,sByte);
				}
				else
					MessageBox(hDialog,"ʧܣ","ʾ",MB_OK|MB_ICONSTOP);					
			}
			else
				MessageBox(hDialog,"ַ","ʾ",MB_OK|MB_ICONSTOP);					
		}
		else if(IsDlgButtonChecked(hDialog,IDC_RADMEMWRITE) == BST_CHECKED)	//ѡд
		{
			UCHAR oByte[8];
			UINT oByteLen;
			mVAR_TYPE mVarByte;
			oByteLen = GetDlgItemText(hDialog,IDC_EDTMEMDATA,oByte,3);
			mVarByte = mCharToVar(oByte,oByteLen,3);
			cByte = mVarByte.cVar;
			if(oByteLen && MemAddrLen)		//ȡ
			{
				//oByte=0x00;
				if(CH365mWriteMemByte(mIndex,&mMemAddr->mCh365MemPort[mAddr],cByte))	//ÿռдһֽ
					MessageBox(hDialog,"дݳɹ","ʾ",MB_OK);
				else
					MessageBox(hDialog,"дʧܣ","ʾ",MB_OK|MB_ICONSTOP);
			}
			else
				MessageBox(hDialog,"ַ!","ʾ",MB_OK);
		}
	}
	//ѡж˫ֲ
	else if(IsDlgButtonChecked(hDialog,IDC_RADMEMDWORD) == BST_CHECKED)		
	{
		ULONG oDword = 0;
		char cDword[12];      //
		ULONG num;
		//Ƿ˫ֵַͷ	
		if(!mCheckWord((PVOID)mAddr,8))
		{
			MessageBox(hDialog,"ܴ洢˫ֵʼַ","ʾ",MB_OK|MB_ICONSTOP);
			return;
		}
		if (IsDlgButtonChecked(hDialog,IDC_RADMEMREAD) == BST_CHECKED)	//ѡж
		{
			if(CH365mReadMemDword( mIndex, &mMemAddr->mCh365MemPort[mAddr], &oDword ))	//Ӵ洢һ˫
			{
				UCHAR sByte[12];
				sprintf( sByte,"%02X%02X%02X%02X\x0", oDword & 0xFF, (oDword>>8) & 0xFF, (oDword>>16) & 0xFF, (oDword>>24) & 0xFF );
				SetDlgItemText(hDialog,IDC_EDTMEMDATA,sByte);		//ȡֵ
			}
			else
				MessageBox(hDialog,"ʧܣ","ʾ",MB_OK|MB_ICONSTOP);
		}
		else if(IsDlgButtonChecked(hDialog,IDC_RADMEMWRITE) == BST_CHECKED)	//ѡд
		{
			mVAR_TYPE mVarDword;
			num = GetDlgItemText(hDialog,IDC_EDTMEMDATA,cDword,9);
			mVarDword = mCharToVar(cDword,num,1);
			oDword = mVarDword.lVar;
			if(num && MemAddrLen)	//ȡ		
			{
				if(CH365mWriteMemDword(mIndex, &mMemAddr->mCh365MemPort[mAddr], oDword))	//洢дһ˫
					MessageBox(hDialog,"дݳɹ","ʾ",MB_OK);
				else
					MessageBox(hDialog,"дʧܣ","ʾ",MB_OK|MB_ICONSTOP);
			}
			else
				MessageBox(hDialog,"!","ʾ",MB_OK);
		}
	}
	else
		MessageBox(hDialog,"ѡдֽڻ˫֣","ʾ",MB_OK);
}

void mConReadWrite(HWND hDialog)
{
	UCHAR iAddr[8];
	USHORT mAddr;
	UCHAR oByte[8];
	UCHAR cByte;
	UINT iAddrLen;
	mVAR_TYPE mVarType;
	mIndex = GetDevIndex(hDialog);
	iAddrLen = GetDlgItemText(hDialog,IDC_EDTCONBYTEADDR,iAddr,5);	//ȡַ
	mVarType = mCharToVar(iAddr,iAddrLen,0);
	mAddr = mVarType.sVar;
	if (IsDlgButtonChecked(hDialog,IDC_RADCONBYTEREAD) == BST_CHECKED)	//ѡдÿռһֽڵĲ
	{
		if(iAddrLen)		//ȡַ
		{
			if(CH365mReadConfig( mIndex,(PVOID) mAddr, &cByte ))	//ÿռһֽ
			{
				UCHAR sByte[8];
				sprintf( sByte,"%02X\x0", cByte );
				SetDlgItemText(hDialog,IDC_EDTCONBYTEDATA,sByte);
			}
			else
				MessageBox(hDialog,"ʧܣ","ʾ",MB_OK|MB_ICONSTOP);
		}
		else
			MessageBox(hDialog,"ַ!","ʾ",MB_OK);
	}
	else if(IsDlgButtonChecked(hDialog,IDC_RADCONBYTEWRITE) == BST_CHECKED)	//ѡÿռдֽڲ
	{
		UINT oByteLen = 0;
		mVAR_TYPE mVarByte;
		oByteLen = GetDlgItemText(hDialog,IDC_EDTCONBYTEDATA,oByte,3);	//ȡ
		mVarByte = mCharToVar(oByte,oByteLen,3);
		cByte = mVarByte.cVar;
		if( iAddrLen && oByteLen )	
		{
			if(CH365mWriteConfig(mIndex, (PVOID)mAddr, cByte))	//ÿռдһֽ
				MessageBox(hDialog,"дݳɹ","ʾ",MB_OK);
			else
				MessageBox(hDialog,"дʧܣ","ʾ",MB_OK|MB_ICONSTOP);
		}
		else
			MessageBox(hDialog,"ַ!","ʾ",MB_OK);
	}
}

//A15_A8
void mSetA15(HWND hDialog)
{
	UCHAR iA15_A8[12];
	UCHAR mA15_A8 = 0;
	UINT iA15_A8Len;
	int i;
	mIndex = GetDevIndex(hDialog);
	iA15_A8Len = GetDlgItemText(hDialog,IDC_EDTA15,iA15_A8,7);
	//볤Ϊ6
	if(iA15_A8Len != 0x06)
		MessageBox(hDialog,"λƣ","ʾ",MB_OK|MB_ICONSTOP);
	
	//жǷǶ
	for(i=0;i<6;i++)		
		if( ( iA15_A8[i] != '0' ) && (iA15_A8[i] != '1') )
		{
			MessageBox(hDialog,"ƣ","ʾ",MB_OK|MB_ICONSTOP);
			return;
		}
	//תӦֵ
	for(i=0;i<6;i++)
		mA15_A8 += (mCharToBcd(iA15_A8[i])<<(7-i));
	if(iA15_A8Len)
	{
		if(!CH365mSetA15_A8(mIndex,mA15_A8))
			MessageBox(hDialog,"","",MB_OK|MB_ICONSTOP);
	}
	else
	{
		MessageBox(hDialog,"ֵ!","ʾ",MB_OK);
	}
}

//I2C
void mSetI2C(HWND hDialog,int iIndex)
{
	UCHAR iAddr[8];
	UINT iAddrLen;
	UCHAR dAddr[8];
	UINT dAddrLen;
	UCHAR imAddr;			//豸ַ
	UCHAR idAddr;			//ݵԪַ
	UCHAR oByte[8];
	UCHAR cByte;
	mVAR_TYPE mVarTypei,mVarTyped;
	//жʱA15SYS_EX
	if(IsDlgButtonChecked(hDialog,IDC_RADI2CA15) == BST_CHECKED) {  // A15
		CH365mReadIoByte(iIndex,&mBaseAddr->mCh365IoCtrl,&cByte);  // A15״̬,ΪA15ΪߵƽʱI2C
		if ( cByte & 0x01 ) CH365mWriteIoByte(iIndex,&mBaseAddr->mCh365IoCtrl,(UCHAR)(cByte&0xfe));  // A15=0,ҲD0ģʽ
		CH365mWriteIoByte(iIndex,&mBaseAddr->mCh365I2cCtrl,0);  // ѡA15ΪSCL,Ĭֵ
	}
	else if(IsDlgButtonChecked(hDialog,IDC_RADI2CSYS) == BST_CHECKED)  // SYS_EX
		CH365mWriteIoByte(iIndex,&mBaseAddr->mCh365I2cCtrl,0x80);  // ѡSYS_EXΪSCL
	iAddrLen = GetDlgItemText(hDialog,IDC_EDTDEVADDR,iAddr,3);	//ȡ豸ַ
	dAddrLen = GetDlgItemText(hDialog,IDC_EDTDATADDR,dAddr,3) ;	//ȡݵԪַ
	mVarTypei = mCharToVar(iAddr,iAddrLen,3);
	imAddr = mVarTypei.cVar;
	mVarTyped = mCharToVar(dAddr,dAddrLen,3);
	idAddr = mVarTyped.cVar;
	if (IsDlgButtonChecked(hDialog,IDC_RADI2CREAD) == BST_CHECKED)	//ֽ
	{
		if( iAddrLen && dAddrLen )	//ȡݵԪַ
		{
			if(CH365mReadI2C( iIndex, imAddr, idAddr, &cByte ))		//I2Cӿڶһֽ
			{
				UCHAR sByte[8];
				sprintf( sByte,"%02X\x0", cByte );
				SetDlgItemText(hDialog,IDC_EDTI2CDATA,sByte);
			}
			else
				MessageBox(hDialog,"ʧܣ","ʾ",MB_OK|MB_ICONSTOP);
		}
		else
			MessageBox(hDialog,"ַ!","ʾ",MB_OK);
	}
	else if(IsDlgButtonChecked(hDialog,IDC_RADI2CWRITE) == BST_CHECKED)		//ѡI2Cд
	{
		UINT oByteLen;
		UCHAR cByte;
		mVAR_TYPE mVarByte;
		oByteLen = GetDlgItemText(hDialog,IDC_EDTI2CDATA,oByte,3);	//ȡд
		mVarByte = mCharToVar(oByte,oByteLen,0);
		cByte = mVarByte.cVar;
		if( iAddrLen && dAddrLen && oByteLen )	
		{
			if(CH365mWriteI2C(iIndex, imAddr, idAddr, cByte))		//I2Cдһֽ
				MessageBox(hDialog,"дݳɹ","ʾ",MB_OK);
			else
				MessageBox(hDialog,"дʧܣ","ʾ",MB_OK|MB_ICONSTOP);
		}
		else
			MessageBox(hDialog,"ַ!","ʾ",MB_OK);
	}
}

//ȡ豸
int GetDevIndex(HWND hDialog)
{
	char index[8];
	int mIndexLen;
	mIndexLen = GetDlgItemText(hDialog,IDC_EDTINDEX,index,2);
	if(mIndexLen)
		mIndex = atoi(index); 
	else
		mIndex = 0;
	return mIndex;
}

//ַǷܴ洢ֻ˫
BOOL mCheckWord(PVOID mWord,int dFlag)
{
	if(dFlag == 4)
	{	
		if(((USHORT)mWord % 2)  == 0)
			return TRUE;
		else
			return FALSE;
	}
	else if(dFlag == 8)
	{
		if(((USHORT)mWord % 4)  == 0)
			return TRUE;
		else
			return FALSE;
	}
	return FALSE;
}

//ʼĬϵѡ
void mInitCheckBox(HWND hDialog)
{
	CheckDlgButton(hDialog,IDC_RADOFF,BST_CHECKED);         	//ֱӵַΪĬѡ
	CheckDlgButton(hDialog,IDC_RADIOBYTE,BST_CHECKED);    		//I/O ֽڲΪĬѡ
	CheckDlgButton(hDialog,IDC_RADIOREAD,BST_CHECKED); 		//I/O дΪĬѡ
	CheckDlgButton(hDialog,IDC_RADCONBYTEREAD,BST_CHECKED);	//ÿռдֽΪĬϲ
	CheckDlgButton(hDialog,IDC_RADI2CREAD,BST_CHECKED);		//I2CдΪĬѡ
	CheckDlgButton(hDialog,IDC_RADMEMBYTE,BST_CHECKED);			//ô洢жֽڲΪĬѡ
	CheckDlgButton(hDialog,IDC_RADMEMREAD,BST_CHECKED);		//ô洢дΪĬѡ
	CheckDlgButton(hDialog,IDC_RADI2CSYS,BST_CHECKED);			//SYS_EXΪĬʱ
}

//DLL汾
void mShowDllVer(HWND hDialog)
{
	ULONG ver = 0;
	char vers[8];
	ver = CH365GetVersion();  
	_ltoa(ver,vers,16);
	if(!SetDlgItemText(hDialog,IDC_EDTDLLVER,vers))
		MessageBox(hDialog,"δܳɹDLL汾ţ","ʾ",MB_ICONSTOP | MB_OK);
}

//汾
void mShowDevVer(HWND hDialog)
{
	ULONG ver = 0;
	char vers[8];
	ver = CH365GetDrvVersion();  
	_ltoa(ver,vers,16);
	if(!SetDlgItemText(hDialog,IDC_EDTDEVVER,vers))
		MessageBox(hDialog,"δܳɹ汾ţ","ʾ",MB_ICONSTOP | MB_OK);
}
