/* 2004.06.05
****************************************
**  Copyright  (C)  W.ch  1999-2004   **
**  Web:  http://www.winchiphead.com  **
****************************************
**  USB Host File Interface for CH375 **
**  TC2.0@PC, KC7.0@MCS51             **
****************************************
*/
/* CH375 ļϵͳӿ */
/* ֧: FAT12/FAT16/FAT32ֻ */

/* MCS-51ƬCԵUļдʾ, 89C52߸ռĵƬ */
/* óUе/C51/CH375HFT.CļеСдĸתɴдĸ, д½ļNEWFILE.TXT,
   ҲԭļCH375HFT.C, ôóʾC51Ŀ¼CH375ͷļ, ½NEWFILE.TXTļдʾϢ,
   ҲC51Ŀ¼, ôóʾĿ¼µļ, ½NEWFILE.TXTļдʾϢ
*/
/* CH375INT#Ųòѯʽ, ݸƷʽΪ"DPTR", ٶȽ, MCS51Ƭ */


/* C51   CH375HFT.C */
/* LX51  CH375HFT.OBJ , CH375HF3.LIB */
/* OHX51 CH375HFT */

#include <reg52.h>
#include <stdio.h>

/* ¶ϸ˵뿴CH375HF3.Hļ */
#define LIB_CFG_DISK_IO			1		/* ̶дݵĸƷʽ,1Ϊ"DPTR",2Ϊ"˫DPTR",3Ϊ"DPTRP2+R0" */
#define LIB_CFG_FILE_IO			1		/* ļдݵĸƷʽ,0Ϊ"ⲿӳ",1Ϊ"DPTR",2Ϊ"˫DPTR",3Ϊ"DPTRP2+R0" */
#define LIB_CFG_INT_EN			0		/* CH375INT#ӷʽ,0Ϊ"ѯʽ",1Ϊ"жϷʽ" */

#define CH375_CMD_PORT_ADDR		0xBDF1	/* CH375˿ڵI/Oַ */
#define CH375_DAT_PORT_ADDR		0xBCF0	/* CH375ݶ˿ڵI/Oַ */
/* 62256ṩ32KBRAMΪ: 0000H-01FFHΪ̶д, 0200H-7FFFHΪļݻ */
#define	DISK_BASE_BUF_ADDR		0x0000	/* ⲿRAMĴݻʼַ,ӸõԪʼĻΪSECTOR_SIZE */
#define DISK_BASE_BUF_LEN		4096	/* ĬϵĴݻСΪ512ֽ,ѡΪ20484096֧ĳЩU,Ϊ0ֹ.Hļж建ӦópDISK_BASE_BUFָ */
#define FILE_DATA_BUF_ADDR		0x1000	/* ⲿRAMļݻʼַ,ȲСһζдݳ */
/* ʾõ62256ֻ32Kֽ,CH375ӳ512ֽ,ⲿRAMʣ೤Ϊ32256ֽ */
#define FILE_DATA_BUF_LEN		0x6800	/* ⲿRAMļݻ,ȲСһζдݳ */
/* ׼ʹ˫д,ôҪFILE_DATA_BUF_LEN,ڲַָ,CH375FileReadXCH375FileRead,CH375FileWriteXCH375FileWrite */

#define CH375_INT_WIRE			INT0	/* P3.2, INT0, CH375жINT#,CH375INT#,ڲѯж״̬ */

#define NO_DEFAULT_CH375_F_ENUM		1		/* δCH375FileEnumerʽֹԽԼ */
#define NO_DEFAULT_CH375_F_QUERY	1		/* δCH375FileQueryʽֹԽԼ */

#include "..\CH375HF3.H"				/* Ҫ֧FAT32,ôѡCH375HF4.H */

/* P1.4һLEDڼʾĽ,͵ƽLED,U̲ */
sbit P1_4  = P1^4;
#define LED_OUT_INIT( )		{ P1_4 = 1; }	/* P1.4 ߵƽ */
#define LED_OUT_ACT( )		{ P1_4 = 0; }	/* P1.4 ͵ƽLEDʾ */
#define LED_OUT_INACT( )	{ P1_4 = 1; }	/* P1.4 ͵ƽLEDʾ */
sbit P1_5  = P1^5;
/* P1.5һLEDڼʾĽ,͵ƽLED,U̲ʱ */
#define LED_RUN_ACT( )		{ P1_5 = 0; }	/* P1.5 ͵ƽLEDʾ */
#define LED_RUN_INACT( )	{ P1_5 = 1; }	/* P1.5 ͵ƽLEDʾ */
sbit P1_6  = P1^6;
/* P1.6һLEDڼʾĽ,͵ƽLED,Uдʱ */
#define LED_WR_ACT( )		{ P1_6 = 0; }	/* P1.6 ͵ƽLEDʾ */
#define LED_WR_INACT( )		{ P1_6 = 1; }	/* P1.6 ͵ƽLEDʾ */

/* ԺΪλʱ,ȷ,24MHzʱ */
void	mDelaymS( UINT8 delay )
{
	unsigned char	i, j, c;
	for ( i = delay; i != 0; i -- ) {
		for ( j = 200; j != 0; j -- ) c += 3;  /* 24MHzʱʱ500uS */
		for ( j = 200; j != 0; j -- ) c += 3;  /* 24MHzʱʱ500uS */
	}
}

/* ռַƵڲRAM,ַ */
UINT8	mCopyCodeStringToIRAM( UINT8 idata *iDestination, UINT8 code *iSource )
{
	UINT8	i = 0;
	while ( *iDestination = *iSource ) {
		iDestination ++;
		iSource ++;
		i ++;
	}
	return( i );
}

/* ״̬,ʾ벢ͣ */
void	mStopIfError( UINT8 iError )
{
	if ( iError == ERR_SUCCESS ) return;  /* ɹ */
	printf( "Error: %02X\n", (UINT16)iError );  /* ʾ */
	while ( 1 ) {
		LED_OUT_ACT( );  /* LED˸ */
		mDelaymS( 100 );
		LED_OUT_INACT( );
		mDelaymS( 100 );
	}
}

/* Ϊprintfgetkeyʼ */
void	mInitSTDIO( )
{
	SCON = 0x50;
	PCON = 0x80;
	TMOD = 0x20;
	TH1 = 0xf3;  /* 24MHz, 9600bps */
	TR1 = 1;
	TI = 1;
}

main( ) {
	UINT8	i, c, SecCount;
	UINT16	NewSize, count;  /* ΪʾRAMֻ32KB,NewSizeΪ16λ,ʵļ32256ֽ,Ӧ÷ּζдҽNewSizeΪUINT32Աۼ */
	UINT8	code *pCodeStr;
	LED_OUT_INIT( );
	LED_OUT_ACT( );  /* LEDһʾ */
	mDelaymS( 100 );  /* ʱ100 */
	LED_OUT_INACT( );
	mInitSTDIO( );  /* Ϊüͨڼʾ */
	printf( "Start\n" );

#if DISK_BASE_BUF_LEN == 0
	pDISK_BASE_BUF = &my_buffer[0];  /* .HļжCH375רû,ûָָӦóĻںԽԼRAM */
#endif

	i = CH375LibInit( );  /* ʼCH375CH375оƬ,ɹ0 */
	mStopIfError( i );
/* ·ʼ */

	while ( 1 ) {
		printf( "Wait Udisk\n" );
//		while ( CH375DiskStatus != DISK_CONNECT ) xQueryInterrupt( );  /* ѯCH375жϲж״̬,ȴU̲ */
		while ( CH375DiskStatus < DISK_CONNECT ) {  /* ѯCH375жϲж״̬,ȴU̲ */
			if ( CH375DiskConnect( ) == ERR_SUCCESS ) break;  /* 豸򷵻سɹ,CH375DiskConnectͬʱȫֱCH375DiskStatus */
			mDelaymS( 20 );
		}
		LED_OUT_ACT( );  /* LED */
		mDelaymS( 250 );  /* ʱ,ѡ,еUSB洢Ҫʮʱ */

/* UǷ׼,ĳЩU̱Ҫִһܹ */
		for ( i = 0; i < 5; i ++ ) {  /* еUǷδ׼,Ա */
			mDelaymS( 100 );
			printf( "Ready ?\n" );
			if ( CH375DiskReady( ) == ERR_SUCCESS ) break;  /* ѯǷ׼ */
		}
#if DISK_BASE_BUF_LEN
		if ( DISK_BASE_BUF_LEN < CH375vSectorSize ) {  /* ݻǷ㹻,CH375vSectorSizeU̵ʵС */
			printf( "Too large sector size\n" );
			while ( CH375DiskConnect( ) == ERR_SUCCESS ) mDelaymS( 100 );
			continue;
		}
#endif
/* ѯ */
/*		printf( "DiskSize\n" );
		i = CH375DiskSize( );  
		mStopIfError( i );
		printf( "TotalSize = %u MB \n", (unsigned int)( mCmdParam.DiskSize.mDiskSizeSec * (CH375vSectorSize/512) / 2048 ) );  // ʾΪMBΪλ
		// ԭ㷽 (unsigned int)( mCmdParam.DiskSize.mDiskSizeSec * CH375vSectorSize / 1000000 ) пǰ˺, ޸ĳʽ
*/
		LED_RUN_ACT( );  /* ʼU */
/* ȡԭļ */
		printf( "Open\n" );
		mCopyCodeStringToIRAM( mCmdParam.Open.mPathName, "\\C51\\CH375HFT.C" );  /* ļ,ļC51Ŀ¼ */
		i = CH375FileOpen( );  /* ļ */
		if ( i == ERR_MISS_DIR || i == ERR_MISS_FILE ) {  /* ûҵļ */
/* гļ */
			if ( i == ERR_MISS_DIR ) pCodeStr = "\\*";  /* C51Ŀ¼гĿ¼µļ */
			else pCodeStr = "\\C51\\CH375*";  /* CH375HFT.Cļг\C51Ŀ¼µCH375ͷļ */
			printf( "List file %s\n", pCodeStr );
			for ( c = 0; c < 254; c ++ ) {  /* ǰ254ļ */
				i = mCopyCodeStringToIRAM( mCmdParam.Open.mPathName, pCodeStr );  /* ļ,*Ϊͨ,ļĿ¼ */
/* һöٷǣ˴cΪ0xFFȻöŴCH375vFileSizeУӶ254ļ02147483647 */
				mCmdParam.Open.mPathName[ i ] = c;  /* ַȽ滻Ϊ,0254 */
				i = CH375FileOpen( );  /* ļ,ļкͨ*,Ϊļ */
				if ( i == ERR_MISS_FILE ) break;  /* Ҳƥļ,Ѿûƥļ */
				if ( i == ERR_FOUND_NAME ) {  /* ͨƥļ,ļ· */
					printf( "  match file %03d#: %s\n", (unsigned int)c, mCmdParam.Open.mPathName );  /* ʾźƥļĿ¼ */
					continue;  /* һƥļ,´ʱŻ1 */
				}
				else {  /*  */
					mStopIfError( i );
					break;
				}
			}
			pCodeStr = "Ҳ/C51/CH375HFT.Cļ\xd\n";
			for ( i = 0; i != 255; i ++ ) {
				if ( ( FILE_DATA_BUF[i] = *pCodeStr ) == 0 ) break;
				pCodeStr++;
			}
			NewSize = i;  /* ļĳ */
			SecCount = 1;  /* (NewSize+CH375vSectorSize-1)/CH375vSectorSize, ļ,ΪдΪλ */
		}
		else {  /* ҵļ߳ */
			mStopIfError( i );
/*			printf( "Query\n" );
			i = CH375FileQuery( );  ѯǰļϢ
			mStopIfError( i );*/
			printf( "Read\n" );
			if ( CH375vFileSize > FILE_DATA_BUF_LEN ) {  /* ʾõ62256ֻ32Kֽ,CH375ӳ512ֽ,ֻȡ63,Ҳǲ32256ֽ */
				SecCount = FILE_DATA_BUF_LEN / CH375vSectorSize;  /* ʾõ62256ֻ32Kֽ,CH375ӳ512ֽ,ֻȡ63,Ҳǲ32256ֽ */
				NewSize = FILE_DATA_BUF_LEN;  /* RAMƳ */
			}
			else {  /* ԭļС,ôʹԭ */
				SecCount = ( CH375vFileSize + CH375vSectorSize-1 ) / CH375vSectorSize;  /* ļ,ΪдΪλ,ȼCH375vSectorSize-1Ϊ˶ļβ1Ĳ */
				NewSize = (UINT16)CH375vFileSize;  /* ԭļĳ */
			}
			printf( "Size=%ld, Len=%d, Sec=%d\n", CH375vFileSize, NewSize, (UINT16)SecCount );
			mCmdParam.Read.mSectorCount = SecCount;  /* ȡȫ,60ֻȡ60 */
/*			current_buffer = & FILE_DATA_BUF[0];  ļдݵĸƷʽΪ"ⲿӳ",ôҪôݵĻʼַ */
			CH375vFileSize += CH375vSectorSize-1;  /* Ĭ,ʽȡʱ,޷ļβ1Ĳ,ԱʱӴļԶȡβͷ */
			i = CH375FileRead( );  /* ļȡ */
			CH375vFileSize -= CH375vSectorSize-1;  /* ָԭļ */
			mStopIfError( i );
/*
		ļȽϴ,һζ,ٵCH375FileReadȡ,ļָԶƶ
		while ( 1 ) {
			c = 32;   ÿζȡ32
			mCmdParam.Read.mSectorCount = c;   ָȡ
			CH375FileRead();   ļָԶ
			
			if ( mCmdParam.Read.mSectorCount < c ) break;   ʵʶС˵ļѾ
		}

	    ϣָλÿʼд,ƶļָ
		mCmdParam.Locate.mSectorOffset = 3;  ļǰ3ʼд
		i = CH375FileLocate( );
		mCmdParam.Read.mSectorCount = 10;
		CH375FileRead();   ֱӶȡļĵ(CH375vSectorSize*3)ֽڿʼ,ǰ3

	    ϣӵԭļβ,ƶļָ
		i = CH375FileOpen( );
		mCmdParam.Locate.mSectorOffset = 0xffffffff;  Ƶļβ,Ϊλ,ԭļ3ֽ,CH375vSectorSizeֽڿʼ
		i = CH375FileLocate( );
		mCmdParam.Write.mSectorCount = 10;
		CH375FileWrite();   ԭļĺ

ʹCH375FileReadXжݻʼַ
		mCmdParam.ReadX.mSectorCount = 2;
		mCmdParam.ReadX.mDataBuffer = 0x2000;  ݷŵ2000HʼĻ
		CH375FileReadX();   ļжȡ2ָ

ʹCH375FileWriteXжݻʼַ
		mCmdParam.WiiteX.mSectorCount = 2;
		mCmdParam.WriteX.mDataBuffer = 0x4600;  4600HʼĻед
		CH375FileWriteX();   ָед2ļ

*/
			printf( "Close\n" );
			i = CH375FileClose( );  /* رļ */
			mStopIfError( i );

			i = FILE_DATA_BUF[100];
			FILE_DATA_BUF[100] = 0;  /* ַ־,ʾ100ַ */
			printf( "Line 1: %s\n", FILE_DATA_BUF );
			FILE_DATA_BUF[100] = i;  /* ָԭַ */
			for ( count=0; count < NewSize; count ++ ) {  /* ļеСдַתΪд */
				c = FILE_DATA_BUF[ count ];
				if ( c >= 'a' && c <= 'z' ) FILE_DATA_BUF[ count ] = c - ( 'a' - 'A' );
			}
		}

/* ֽΪλȡԭļ */
		LED_WR_ACT( );
		mDelaymS( 200 );
		LED_WR_INACT( );
		printf( "Open2\n" );
		mCopyCodeStringToIRAM( mCmdParam.Open.mPathName, "/C51/CH375HFT.C" );  /* ļ,ļC51Ŀ¼ */
		i = CH375FileOpen( );  /* ļ */
		if ( i == ERR_MISS_DIR || i == ERR_MISS_FILE ) {  /* δҵĿ¼δҵļ */
			for ( c = 0; c < 100; c ++ ) {
				printf( "Enum AnyFile %d#\n", (UINT16)c );
				mCmdParam.Open.mPathName[0] = '/';  /* Ŀ¼µһļ */
				mCmdParam.Open.mPathName[1] = '*';
				mCmdParam.Open.mPathName[2] = 0xFF;  /* CH375vFileSizeΪö */
				CH375vFileSize = c;  /* ö */
				i = CH375FileOpen( );  /* ļ */
				if ( i != ERR_FOUND_NAME ) break;  /* δҵļĿ¼ */
				if ( CH375vFileSize != 0xFFFFFFFF ) {  /* Ϊ0xFFFFFFFFĿ¼,Ϊļ */
					printf( "FileName [%s]\n", mCmdParam.Open.mPathName );
					for ( i = 0; i <= MAX_BYTE_IO; i ++ ) {  /* ȡļ·ܳ */
						if ( mCmdParam.Open.mPathName[ i ] == 0 ) break;
					}
					while ( i ) {
						i --;
						if ( mCmdParam.Open.mPathName[ i ] == '.' ) break;  /* չ */
						if ( mCmdParam.Open.mPathName[ i ] == '/' || mCmdParam.Open.mPathName[ i ] == '\\' ) break;  /* ûչ */
					}
					if ( mCmdParam.Open.mPathName[ i ] == '.' ) {  /* չ */
						i ++;
						if ( mCmdParam.Open.mPathName[ i ] == 'C' && mCmdParam.Open.mPathName[ i+1 ] == 0  /* .Cļ */
							|| mCmdParam.Open.mPathName[ i ] == 'H' && mCmdParam.Open.mPathName[ i+1 ] == 0  /* .Hļ */
							|| mCmdParam.Open.mPathName[ i ] == 'T' && mCmdParam.Open.mPathName[ i+1 ] == 'X' && mCmdParam.Open.mPathName[ i+2 ] == 'T' && mCmdParam.Open.mPathName[ i+3 ] == 0 ) {  /* .TXTļ */
							i = ERR_SUCCESS;  /* C/H/TXTļ */
							break;
						}
					}
				}
				else {  /* Ŀ¼ */
					printf( "DirName [%s]\n", mCmdParam.Open.mPathName );
				}
			}
		}
		if ( i != ERR_MISS_DIR && i != ERR_MISS_FILE ) {  /* ҵļ߳ */
			mStopIfError( i );
			count = 200;  /* ׼ȡܳ */
			printf( "ļжǰ%dַ:\n",count );
			while ( count ) {  /* ļȽϴ,һζ,ٵCH375ByteReadȡ,ļָԶƶ */
				if ( count > MAX_BYTE_IO ) c = MAX_BYTE_IO;  /* ʣݽ϶,ƵζдĳȲܳ sizeof( mCmdParam.ByteRead.mByteBuffer ) */
				else c = count;  /* ʣֽ */
				mCmdParam.ByteRead.mByteCount = c;  /* ʮֽ */
				i = CH375ByteRead( );  /* ֽΪλȡݿ,ζдĳȲܳMAX_BYTE_IO,ڶεʱŸղŵ */
				mStopIfError( i );
				count -= mCmdParam.ByteRead.mByteCount;  /* ,ȥǰʵѾַ */
				for ( i=0; i!=mCmdParam.ByteRead.mByteCount; i++ ) printf( "%C", mCmdParam.ByteRead.mByteBuffer[i] );  /* ʾַ */
				if ( mCmdParam.ByteRead.mByteCount < c ) {  /* ʵʶַҪַ,˵ѾļĽβ */
					printf( "\n" );
					printf( "ļѾ\n" );
					break;
				}
			}
/*	    ϣָλÿʼд,ƶļָ
		mCmdParam.ByteLocate.mByteOffset = 608;  ļǰ608ֽڿʼд
		CH375ByteLocate( );
		mCmdParam.ByteRead.mByteCount = 5;  ȡ5ֽ
		CH375ByteRead( );   ֱӶȡļĵ608ֽڵ612ֽ,ǰ608ֽڱ
*/
			printf( "Close\n" );
			i = CH375FileClose( );  /* رļ */
			mStopIfError( i );
		}

		LED_RUN_INACT( );
		printf( "Take out\n" );
//		while ( CH375DiskStatus != DISK_DISCONNECT ) xQueryInterrupt( );  /* ѯCH375жϲж״̬,ȴṴγ */
		while ( CH375DiskStatus >= DISK_CONNECT ) {  /* ѯCH375жϲж״̬,ȴṴγ */
			if ( CH375DiskConnect( ) != ERR_SUCCESS ) break;
			mDelaymS( 100 );
		}
		LED_OUT_INACT( );  /* LED */
		mDelaymS( 200 );
	}
}
