// FMSETFRQ.C
// This program first initializes the FM Synthesizer chip, then
// sets voice 0 to a piano configuration. It then plays a middle 
// C over that voice, the frequency of which is changed several  
// times by the fmSetFrequency() function, called within a loop.
// The program then turns off the note and uninitializes the chip.

#include <stdlib.h>
#include "cvxfmsy.h"

VOID main( VOID )
{
   WORD counterI, counterJ;

   _FM_INIT_DATA   fmInitData;      // Initialization structure

   _BNK_INSTRUMENT   bnkInstrument  =    
   {
       0,  0,  1,  3,  3, 15,  5,  0,  1,  3,
      15,  0,  0,  0,  1,  0,  7,  0, 15,  7,
       0,  2,  4,  0,  0,  0,  1,  1,  0,  0
   }; // Piano

   // Set the port to port A( 388h )
   fmInitData.port = _FM_PORT_A;

   // Initialize the FM libraries
   if( !( fmInit( ( _FM_INIT_DATA * )&fmInitData ) ) )
   {
      // Set the instrument on voice 0
      if(!( fmSetInstrument((_BNK_INSTRUMENT far *)&bnkInstrument, 0 )))
      {
         // Turn the note on, voice 0 - middle C.
         if( !fmNoteOn( 0, _fmMidiScale[ C5 ] ) )
         {
            // Loop through a series of tones.
            for( counterI = 0; counterI < 86; counterI++ )
            {
               // Do a delay loop.
               for( counterJ = 0; counterJ < 65534; counterJ++ );

               // Set the frequency to a specific tone on voice 0.
               if( fmSetFrequency( 0, _fmMidiScale[ counterI ] ) )
               {
                  printf( "ERROR : fmSetFrequency()" );
                  printf( " not successful.\n" );
               }
            }

            // Turn the note off on channel 0.
            if( fmNoteOff( 0 ) )
               printf( "ERROR : fmNoteOff() not successful.\n" );
         }
         else
            printf( "ERROR : fmNoteOn() not successful.\n" );
      }
      else
         printf( "ERROR : fmSetInstrument() not successful.\n" );


      // Uninitialize the FM system
      if( fmUninit() )
         printf( "ERROR : fmUninit() not successful.\n" );
   }
   else
      printf( "ERROR : fmInit() not successful.\n" );
} 


