;****************************************************************************
;
; File                  : fmout.asm	
; Date                  : 2-26-91	
; Description           : Function to output data to the YM3812 chip	
;				
;
; Progammer(s)          : Don Fowler, Lance Williams	
; Last Modifications    : 	
;
; Additional Notes      : Extraneous cycles are needed to let the chip settle	
;
;***************************************************************************
;               Copyright (c) 1991,  Covox, Inc.  All Rights Reserved      
;***************************************************************************

ifdef  Smodel
        .model SMALL,c
endif

ifdef  Mmodel
        .model MEDIUM,c
endif

ifdef  Cmodel
        .model COMPACT,c
endif

ifdef  Lmodel
        .model LARGE,c
endif
				
				public	fmSetRegister 	  
				public  _fmPort

.data 

_fmPort         dw      0
               
.code
;****************************************************************************
; Function              : SetRegister
;  
; Called As		: VOID fmSetRegister   ( unsigned char Register, 
;					         unsigned char Value )
;
; Description           : Outputs a byte to the YM3812 register specified.
;
; Entry Parameters      : Register - Register on YM3812 to write to
;			  Value	   - Data to write to register.		
;
; Returns               : NULL
;
;****************************************************************************    
fmSetRegister		PROC	Register : BYTE,\
			Value	 : BYTE
		;
		; Get the port address of the YM8312 chip
		;
		mov	dx, _fmPort

		;
		; Output the register value to the base port of the YM3812.
		; This is done to select the register to write to.
		;
		mov	al, Register
		out	dx, al

		;
		; Select Base Port+1 to	write data to the selected register
		;
		inc	dx

		;
		; Wait for 12 cycles( 3.6 Mhz ) to let the chip settle
		;
		in	al, dx
		in	al, dx
		in	al, dx
		in	al, dx
		in	al, dx
		in	al, dx

		;
		; Output the data to the reigster
		;
		mov	al, Value
		out	dx, al
		dec	dx

		;
		; 84 cyles delay ( 3.6 Mhz )
		;
		in	al, dx
		in	al, dx
		in	al, dx
		in	al, dx
		in	al, dx
		in	al, dx
		in	al, dx
		in	al, dx
		in	al, dx
		in	al, dx
		in	al, dx
		in	al, dx
		in	al, dx
		in	al, dx
		in	al, dx
		in	al, dx
		in	al, dx
		in	al, dx
		in	al, dx
		in	al, dx
		in	al, dx
		in	al, dx
		in	al, dx
		in	al, dx
		in	al, dx
		in	al, dx
		in	al, dx
		in	al, dx
		in	al, dx
		in	al, dx
		in	al, dx
		in	al, dx
		in	al, dx
		in	al, dx
		in	al, dx

		;
		; Return to caller
		;
		ret

fmSetRegister	ENDP

		END



                               

