PAGE 118,121
TITLE TEST5 ---- 06/10/85  EXCEPTION INTERRUPT TEST HANDLERS
.286C
.XLIST
INCLUDE IAPX286.INC
INCLUDE DSEG.INC
INCLUDE POSTEQU.INC
INCLUDE SYSDATA.INC
.LIST
CODE	SEGMENT BYTE PUBLIC

	PUBLIC	POST5
	PUBLIC	SYSINIT1

;----------------------------------------
;	EXCEPTION INTERRUPT ROUTINE	:
;----------------------------------------

	ASSUME	CS:CODE,DS:ABS0
POST5:
EXC_00:
	MOV	AL,90H			;	<><> SET CHECKPOINT <><>
	JMP	TEST_EXC		; GO TEST IF EXCEPTION WAS EXPECTED
EXC_01:
	MOV	AL,91H			;	<><> SET CHECKPOINT <><>
	JMP	TEST_EXC		; GO TEST IF EXCEPTION WAS EXPECTED
EXC_02:
	MOV	AL,92H			;	<><> SET CHECKPOINT <><>
	JMP	TEST_EXC		; GO TEST IF EXCEPTION WAS EXPECTED
EXC_03:
	MOV	AL,93H			;	<><> SET CHECKPOINT <><>
	JMP	TEST_EXC		; GO TEST IF EXCEPTION WAS EXPECTED
EXC_04:
	MOV	AL,94H			;	<><> SET CHECKPOINT <><>
	JMP	TEST_EXC		; GO TEST IF EXCEPTION WAS EXPECTED
EXC_05:
	PUSH	ES
	PUSH	BYTE PTR ES_TEMP	; LOAD ES REGISTER WITH SELECTOR
	POP	ES

;-----	FIX BOUND PARAMETERS

	SUB	DI,DI			; POINT BEGINNING OF THE BLOCK
	MOV	WORD PTR ES:[DI],0	; SET FIRST WORD TO ZERO
	MOV	WORD PTR ES:[DI+2],07FFFH ; SET SECOND TO 07FFFH
	POP	ES
	MOV	AL,95H			;	<><> SET CHECKPOINT <><>
	JMP	TEST_EXC		; GO TEST IF EXCEPTION WAS EXPECTED

EXC_06:
	MOV	AL,96H			;	<><> SET CHECKPOINT <><>
	JMP	SHORT TEST_EXC		; GO TEST IF EXCEPTION WAS EXPECTED
EXC_07:
	MOV	AL,97H			;	<><> SET CHECKPOINT <><>
	JMP	SHORT TEST_EXC		; GO TEST IF EXCEPTION WAS EXPECTED
EXC_08:
	MOV	AL,98H			;	<><> SET CHECKPOINT <><>
	JMP	SHORT TEST_EXC		; GO TEST IF EXCEPTION WAS EXPECTED
EXC_09:
	MOV	AL,99H			;	<><> SET CHECKPOINT <><>
	JMP	SHORT TEST_EXC		; GO TEST IF EXCEPTION WAS EXPECTED
EXC_10:
	MOV	AL,9AH			;	<><> SET CHECKPOINT <><>
	JMP	SHORT TEST_EXC		; GO TEST IF EXCEPTION WAS EXPECTED
EXC_11:
	MOV	AL,9BH			;	<><> SET CHECKPOINT <><>
	JMP	SHORT TEST_EXC		; GO TEST IF EXCEPTION WAS EXPECTED
EXC_12:
	MOV	AL,9CH			;	<><> SET CHECKPOINT <><>
	JMP	SHORT TEST_EXC		; GO TEST IF EXCEPTION WAS EXPECTED
EXC_13:
	MOV	AL,9DH			;	<><> SET CHECKPOINT <><>
	JMP	SHORT TEST_EXC		; GO TEST IF EXCEPTION WAS EXPECTED
EXC_14:
	MOV	AL,9EH			;	<><> SET CHECKPOINT <><>
	JMP	SHORT TEST_EXC		; GO TEST IF EXCEPTION WAS EXPECTED
EXC_15:
	MOV	AL,9FH			;	<><> SET CHECKPOINT <><>
	JMP	SHORT TEST_EXC		; GO TEST IF EXCEPTION WAS EXPECTED
EXC_16:
	MOV	AL,0A0H 		;	<><> SET CHECKPOINT <><>
	JMP	SHORT TEST_EXC		; GO TEST IF EXCEPTION WAS EXPECTED
EXC_17:
	MOV	AL,0A1H 		;	<><> SET CHECKPOINT <><>
	JMP	SHORT TEST_EXC		; GO TEST IF EXCEPTION WAS EXPECTED
EXC_18:
	MOV	AL,0A2H 		;	<><> SET CHECKPOINT <><>
	JMP	SHORT TEST_EXC		; GO TEST IF EXCEPTION WAS EXPECTED
EXC_19:
	MOV	AL,0A3H 		;	<><> SET CHECKPOINT <><>
	JMP	SHORT TEST_EXC		; GO TEST IF EXCEPTION WAS EXPECTED
EXC_20:
	MOV	AL,0A4H 		;	<><> SET CHECKPOINT <><>
	JMP	SHORT TEST_EXC		; GO TEST IF EXCEPTION WAS EXPECTED
EXC_21:
	MOV	AL,0A5H 		;	<><> SET CHECKPOINT <><>
	JMP	SHORT TEST_EXC		; GO TEST IF EXCEPTION WAS EXPECTED
EXC_22:
	MOV	AL,0A6H 		;	<><> SET CHECKPOINT <><>
	JMP	SHORT TEST_EXC		; GO TEST IF EXCEPTION WAS EXPECTED
EXC_23:
	MOV	AL,0A7H 		;	<><> SET CHECKPOINT <><>
	JMP	SHORT TEST_EXC		; GO TEST IF EXCEPTION WAS EXPECTED
EXC_24:
	MOV	AL,0A8H 		;	<><> SET CHECKPOINT <><>
	JMP	SHORT TEST_EXC		; GO TEST IF EXCEPTION WAS EXPECTED
EXC_25:
	MOV	AL,0A9H 		;	<><> SET CHECKPOINT <><>
	JMP	SHORT TEST_EXC		; GO TEST IF EXCEPTION WAS EXPECTED
EXC_26:
	MOV	AL,0AAH 		;	<><> SET CHECKPOINT <><>
	JMP	SHORT TEST_EXC		; GO TEST IF EXCEPTION WAS EXPECTED
EXC_27:
	MOV	AL,0ABH 		;	<><> SET CHECKPOINT <><>
	JMP	SHORT TEST_EXC		; GO TEST IF EXCEPTION WAS EXPECTED
EXC_28:
	MOV	AL,0ACH 		;	<><> SET CHECKPOINT <><>
	JMP	SHORT TEST_EXC		; GO TEST IF EXCEPTION WAS EXPECTED
EXC_29:
	MOV	AL,0ADH 		;	<><> SET CHECKPOINT <><>
	JMP	SHORT TEST_EXC		; GO TEST IF EXCEPTION WAS EXPECTED
EXC_30:
	MOV	AL,0AEH 		;	<><> SET CHECKPOINT <><>
	JMP	SHORT TEST_EXC		; GO TEST IF EXCEPTION WAS EXPECTED
EXC_31:
	MOV	AL,0AFH 		;	<><> SET CHECKPOINT <><>
	JMP	SHORT TEST_EXC		; GO TEST IF EXCEPTION WAS EXPECTED
SYS_32:
	MOV	AL,0B0H 		;	<><> SET CHECKPOINT <><>
	JMP	SHORT TEST_EXC		; GO TEST IF INTERRUPT WAS EXPECTED
SYS_33:
	MOV	AL,0B1H 		;	<><> SET CHECKPOINT <><>
	JMP	SHORT TEST_EXC		; GO TEST IF INTERRUPT WAS EXPECTED
SYS_34:
	MOV	AL,0B2H 		;	<><> SET CHECKPOINT <><>
	JMP	SHORT TEST_EXC		; GO TEST IF INTERRUPT WAS EXPECTED
SYS_35:
	MOV	AL,0B3H 		;	<><> SET CHECKPOINT <><>
	JMP	SHORT TEST_EXC		; GO TEST IF INTERRUPT WAS EXPECTED
SYS_36:
	MOV	AL,0B4H 		;	<><> SET CHECKPOINT <><>
	JMP	SHORT TEST_EXC		; GO TEST IF INTERRUPT WAS EXPECTED
SYS_37:
	MOV	AL,0B5H 		;	<><> SET CHECKPOINT <><>
	JMP	SHORT TEST_EXC		; GO TEST IF INTERRUPT WAS EXPECTED
SYS_38:
	MOV	AL,0B6H 		;	<><> SET CHECKPOINT <><>
					; GO TEST IF INTERRUPT WAS EXPECTED

TEST_EXC:
	OUT	MFG_PORT,AL		; OUTPUT THE CHECKPOINT
	CMP	AL,0AFH 		; CHECK FOR EXCEPTION
	JA	TEST_EXC0		; GO IF A SYSTEM INTERRUPT

	PUSH	DS			; SAVE THE CURRENT DATA SEGMENT
	PUSH	BYTE PTR GDT_PTR
	POP	DS
	MOV	DS:ES_TEMP.SEG_LIMIT,MAX_SEG_LEN
	MOV	BYTE PTR DS:(ES_TEMP.DATA_ACC_RIGHTS),CPL0_DATA_ACCESS
	PUSH	BYTE PTR ES_TEMP
	POP	ES
	POP	DS			; RESTORE REGISTERS
	POP	DX			; CHECK IF CODE SEGMENT SECOND ON STACK
	POP	CX
	PUSH	CX
	CMP	CX,SYS_ROM_CS
	JNZ	TEST_EXC0		; CONTINUE IF ERROR CODE

	PUSH	DX			; PUT SEGMENT BACK ON STACK
TEST_EXC0:
	XCHG	AH,AL			; SAVE THE CHECKPOINT
	IN	AL,DMA_PAGE+0AH
	CMP	AL,AH			; WAS THE EXCEPTION EXPECTED?
	JZ	TEST_EXC3		; GO IF YES
TEST_EXC1:
	IN	AL,MFG_PORT		; CHECK THE CURRENT CHECKPOINT
	CMP	AL,03BH 		;  HALT IF CHECKPOINT BELOW 3BH
	JB	TEST_EXC2
	IRET

TEST_EXC2:
	XCHG	AH,AL			; OUTPUT THE CURRENT CHECKPOINT
	OUT	MFG_PORT,AL		;   <><> CHECKPOINT  90 THRU B5 <><>
	HLT
	JMP	TEST_EXC2		; INSURE SYSTEM HALT

TEST_EXC3:
	SUB	AL,AL			; CLEAR DMA PAGE
	OUT	DMA_PAGE+0AH,AL
	MOV	AX,0100H		; FOR BOUND INSTRUCTION EXPECTED (INT 5)
	IRET				; RETURN

;---------------------------------------------------------------------------
;	THIS BUILDS THE DESCRIPTOR TABLES REQUIRED FOR PROTECTED MODE	:
;		PROCESSOR MUST BE IN REAL MODE	:
;---------------------------------------------------------------------------
	ASSUME CS:CODE,DS:NOTHING,ES:NOTHING,SS:NOTHING

SYSINIT1	PROC	NEAR
	CLI				; NO INTERRUPTS ALLOWED
	PUSH	BP			; SAVE BP
	MOV	AL,81H			;	<><><><><><><><><><><><>
	OUT	MFG_PORT,AL		;	<><> CHECKPOINT  81 <><>
	CALL	SIDT_BLD
	MOV	BP,DI			; SAVE THE POINTER TO JUST PAST THE IDT
					; AS WE HAVE NO SDA, USE THE SIX BYTES
					;   HERE TO LOAD THE IDTR. WE WILL SIDT
					;   WHEN WE GET TO SDA INITIALIZATION.
	MOV	AX,SYS_IDT_LEN		; SEGMENT LIMIT - LENGTH OF IDT
	STOSW				; STORE THAT AS IDT LIMIT
	MOV	AX,SYS_IDT_LOC		; IDT ADDRESS
	STOSW				;   AND ACCESS RIGHTS BYTE (UNDEFINED)
	MOV	AX,0
	STOSW
	SEGOV	ES			; LOAD THE IDT
	LIDT	[BP]			;   REGISTER FROM THIS AREA
	MOV	DI,BP			; ES:DI NOW --> END OF IDT AGAIN

;-----	BUILD THE GDT.

	MOV	DI,GDT_LOC
	CALL	GDT_BLD
	MOV	BP,DI			; SAVE THE ES:DI POINTER
	MOV	AX,GDT_LEN		; AX = LENGTH OF THE GDT
	STOSW				; PUT THAT IN THE LIMIT FIELD
	MOV	AX,GDT_LOC		; AX = LOW WORD OF GDT ADDRESS
	STOSW				; PUT THAT IN BASE FIELD - LOW
	MOV	AX,0			; AX = HIGH BYTE OF ADDRESS, AND
	STOSW				; ACCESS RIGHTS BYTE 15 UNDEFINED
	SEGOV	ES			; LOAD THE GDTR
	LGDT	[BP]			; FROM THIS AREA
	MOV	DI,BP			; RESTORE THE ES:DI POINTER
	STOSW
	STOSW
	MOV	DI,BP

;-----	SWITCH TO VIRTUAL MODE

	POP	BP			; RESTORE BP
	MOV	AX,VIRTUAL_ENABLE	; MACHINE STATUS WORD NEEDED TO
	LMSW	AX			;  SWITCH TO VIRTUAL MODE
	 DB	 0EAH			; JUMP FAR TO PURGE PRE-FETCH QUEUE
	 DW	 OFFSET DONE		;   TO OFFSET
	 DW	 SYS_ROM_CS		;   IN SEGMENT
DONE:
	MOV	AL,85H			;	<><><><><><><><><><><><>
	OUT	MFG_PORT,AL		;	<><> CHECKPOINT  82 <><>
	RET				; SYSTEM INITIALIZATION

SYSINIT1	ENDP


GDT_BLD PROC	NEAR
	MOV	SI,OFFSET GDT_DATA_START	   ; DS:SI --> GDT
	MOV	CX,(OFFSET GDT_DATA_END-OFFSET GDT_DATA_START)/2  ; WORD COUNT
	REP	MOVSW				   ; COPY GDT INTO MEMORY
	RET
GDT_BLD ENDP


SIDT_BLD	PROC	NEAR

;-----	BUILD THE IDT.	THE IDT WILL CONTAIN VECTORS FOR EXCEPTION HANDLERS

	MOV	SI,OFFSET SYS_IDT_OFFSETS  ; MAKE DS:SI POINT TO
	MOV	AX,CS			; INTERRUPT ENTRY POINTS
	MOV	DS,AX
	MOV	DI,SYS_IDT_LOC		; POINT TO SYS_IDT_LOC
	SUB	AX,AX
	MOV	ES,AX			;	WHERE THE IDT WILL BE.
	MOV	BX,SYS_ROM_CS		; CS IS THE SAME FOR ALL INTERRUPTS
	MOV	DH,TRAP_GATE		; ACCESS RIGHTS BYTE FOR THE GATE
	MOV	DL,0			; THE WORD COUNT FIELD IS UNUSED
	MOV	CX,32			; THERE ARE 32 RESERVED INTERRUPTS
LOW_IDT:				; THIS LOOP BUILDS 32 DESCRIPTORS IN THE
					;   IDT FOR THE RESERVED INTERRUPTS
	MOVSW				; GET A ROUTINE ENTRY POINT
					;   AND PUT IT IN THE OFFSET FIELD
	MOV	AX,BX			; GET THE SYSTEM CODE SEGMENT SELECTOR
	STOSW				;   AND PUT IT IN THE SELECTOR FIELD
	MOV	AX,DX			; GET THE INTERRUPT GATE BYTE
	STOSW				;  AND PUT IN THE ACCESS RIGHTS FIELD
	MOV	AX,0			; ZERO OUT
	STOSW				;   THE RESERVED POSITIONS
	LOOP	LOW_IDT 		;     AND REPEAT AS DIRECTED
	MOV	CX,256-32		; 256 TOTAL - 32 DONE = WHATEVER IS LEFT
	MOV	BP,OFFSET FREE_INTS	; THERE IS A COPY OF AN UN-INITIALIZED
					;   INTERRUPT DESCRIPTOR AT FREE_INTS
HIGH_IDT:
	MOV	SI,BP			; DS:SI --> FREE DESCRIPTOR
					; (ES:DI LEFT OFF AT INT 32)
	MOVSW				; MOVE OFFSET OF THE IRET INSTRUCTION
	MOVSW				; MOVE THE CS SELECTOR
	MOVSW				; MOVE THE ACCESS RIGHTS BYTE
	STOSW				; ZERO OUT THE RESERVED WORD
	LOOP	HIGH_IDT		; FILL THE REMAINDER OF THE TABLE

;-----	INITIALIZE THE ENTRY POINTS FOR POST TEST

	MOV	ES:(SYS_IDT_LOC+(032*DESC_LEN).ENTRY_POINT),OFFSET SYS_32
	MOV	ES:(SYS_IDT_LOC+(033*DESC_LEN).ENTRY_POINT),OFFSET SYS_33
	MOV	ES:(SYS_IDT_LOC+(034*DESC_LEN).ENTRY_POINT),OFFSET SYS_34
	MOV	ES:(SYS_IDT_LOC+(035*DESC_LEN).ENTRY_POINT),OFFSET SYS_35
	MOV	ES:(SYS_IDT_LOC+(036*DESC_LEN).ENTRY_POINT),OFFSET SYS_36
	MOV	ES:(SYS_IDT_LOC+(037*DESC_LEN).ENTRY_POINT),OFFSET SYS_37
	MOV	ES:(SYS_IDT_LOC+(038*DESC_LEN).ENTRY_POINT),OFFSET SYS_38
	RET

IRET_ADDR	LABEL	WORD		; FOR UN-INITIALIZED INTERRUPTS
	IRET				; NULL RETURN
PAGE
;	THE FOLLOWING DATA DEFINES THE PRE-INITIALIZED GDT FOR POST TESTS.
;	THESE MUST BE INITIALIZED IN THE ORDER IN WHICH THEY APPEAR IN THE
;	GDT_DEF STRUCTURE DEFINITION AS IT IS IN "SYSDATA.INC".

GDT_DATA_START	EQU	$

;-----	FIRST ENTRY UNUSABLE  - (UNUSED-ENTRY)

	DW	0			; SEGMENT LIMIT
	DW	0			; SEGMENT SASE ADDRESS - LOW WORD
	DB	0			; SEGMENT BASE ADDRESS - HIGH BYTE
	DB	0			; ACCESS RIGHTS BYTE
	DW	0			; RESERVED - MUST BE ZERO

;-----	THE GDT ITSELF	- (GDT_PTR)

	DW	GDT_LEN 		; SEGMENT LIMIT
	DW	GDT_LOC 		; SEGMENT BASE ADDRESS - LOW WORD
	DB	0			; SEGMENT BASE ADDRESS - HIGH BYTE
	DB	CPL0_DATA_ACCESS	; ACCESS RIGHTS BYTE
	DW	0			; RESERVED - MUST BE ZERO

;-----	THE SYSTEM IDT DESCRIPTOR  - (SYS_IDT_PTR)

	DW	SYS_IDT_LEN		; SEGMENT LIMIT
	DW	SYS_IDT_LOC		; SEGMENT BASE ADDRESS - LOW WORD
	DB	0			; SEGMENT BASE ADDRESS - HIGH BYTE
	DB	CPL0_DATA_ACCESS	; ACCESS RIGHTS BYTE
	DW	0			; RESERVED - MUST BE ZERO

;-----	THE SYSTEM DATA AREA DESCRIPTOR  - (RSDA_PTR)

	DW	SDA_LEN 		; SEGMENT LIMIT
	DW	SDA_LOC 		; SEGMENT BASE ADDRESS - LOW WORD
	DB	0			; SEGMENT BASE ADDRESS - HIGH BYTE
	DB	CPL0_DATA_ACCESS	; ACCESS RIGHTS BYTE
	DW	0			; RESERVED - MUST BE ZERO

;-----	COMPATIBLE MONOCHROME DISPLAY REGEN BUFFER  - (C_BWCRT_PTR)

	DW	MCRT_SIZE		; SEGMENT LIMIT
	DW	MCRT@_LO		; SEGMENT BASE ADDRESS - LOW WORD
	DB	MCRT@_HI		; SEGMENT BASE ADDRESS - HIGH BYTE
	DB	CPL0_DATA_ACCESS	; ACCESS RIGHTS BYTE
	DW	0			; RESERVED - MUST BE ZERO

;-----	COMPATIBLE COLOR DISPLAY REGEN BUFFER  - (C_CCRT_PTR)

	DW	CCRT_SIZE		; SEGMENT LIMIT
	DW	CCRT@_LO		; SEGMENT BASE ADDRESS - LOW WORD
	DB	CCRT@_HI		; SEGMENT BASE ADDRESS - HIGH BYTE
	DB	CPL0_DATA_ACCESS	; ACCESS RIGHTS BYTE
	DW	0			; RESERVED - MUST BE ZERO

;-----	ENHANCED GRAPHIC ADAPTER REGEN BUFFER  - (E_CCRT_PTR)

	DW	ECCRT_SIZE		; SEGMENT LIMIT
	DW	ECCRT@_LO_LO		; SEGMENT BASE ADDRESS - LOW WORD
	DB	ECCRT@_LO_HI		; SEGMENT BASE ADDRESS - HIGH BYTE
	DB	CPL0_DATA_ACCESS	; ACCESS RIGHTS BYTE
	DW	0			; RESERVED - MUST BE ZERO

;-----	SECOND PART OF EGA  - (E_CCRT_PTR2)

	DW	ECCRT_SIZE		; SEGMENT LIMIT
	DW	ECCRT@_HI_LO		; SEGMENT BASE ADDRESS - LOW WORD
	DB	ECCRT@_HI_HI		; SEGMENT BASE ADDRESS - HIGH BYTE
	DB	CPL0_DATA_ACCESS	; ACCESS RIGHTS BYTE
	DW	0			; RESERVED - MUST BE ZERO

;-----	CODE SEGMENT FOR POST CODE, SYSTEM IDT	- (SYS_ROM_CS)

	DW	MAX_SEG_LEN		; SEGMENT LIMIT
	DW	CSEG@_LO		; SEGMENT BASE ADDRESS - LOW WORD
	DB	CSEG@_HI		; SEGMENT BASE ADDRESS - HIGH BYTE
	DB	CPL0_CODE_ACCESS	; ACCESS RIGHTS BYTE
	DW	0			; RESERVED - MUST BE ZERO

;-----	TEMPORARY DESCRIPTOR FOR ES  - (ES_TEMP)

	DW	MAX_SEG_LEN		; SEGMENT LIMIT
	DW	NSEG@_LO		; SEGMENT BASE ADDRESS - LOW WORD
	DB	NSEG@_HI		; SEGMENT BASE ADDRESS - HIGH BYTE
	DB	CPL0_DATA_ACCESS	; ACCESS RIGHTS BYTE
	DW	0			; RESERVED - MUST BE ZERO

;-----	TEMPORARY DESCRIPTOR FOR CS AS A DATA SEGMENT  - (CS_TEMP)

	DW	MAX_SEG_LEN		; SEGMENT LIMIT
	DW	NSEG@_LO		; SEGMENT BASE ADDRESS - LOW WORD
	DB	NSEG@_HI		; SEGMENT BASE ADDRESS - HIGH BYTE
	DB	CPL0_DATA_ACCESS	; ACCESS RIGHTS BYTE
	DW	0			; RESERVED - MUST BE ZERO

;-----	TEMPORARY DESCRIPTOR FOR SS  - (SS_TEMP)

	DW	MAX_SEG_LEN		; SEGMENT LIMIT
	DW	NSEG@_LO		; SEGMENT BASE ADDRESS - LOW WORD
	DB	NSEG@_HI		; SEGMENT BASE ADDRESS - HIGH BYTE
	DB	CPL0_DATA_ACCESS	; ACCESS RIGHTS BYTE
	DW	0			; RESERVED - MUST BE ZERO

;-----	TEMPORARY DESCRIPTOR FOR DS  - (DS_TEMP)

	DW	MAX_SEG_LEN		; SEGMENT LIMIT
	DW	NSEG@_LO		; SEGMENT BASE ADDRESS - LOW WORD
	DB	NSEG@_HI		; SEGMENT BASE ADDRESS - HIGH BYTE
	DB	CPL0_DATA_ACCESS	; ACCESS RIGHTS BYTE
	DW	0			; RESERVED - MUST BE ZERO
PAGE
;-----	(POST_TR)
TR_LOC:
	DW	00800H			; SEGMENT LIMIT
	DW	0C000H			; SEGMENT BASE ADDRESS - LOW WORD
	DB	0			; SEGMENT BASE ADDRESS - HIGH BYTE
	DB	FREE_TSS		; ACCESS RIGHTS BYTE
	DW	0			; RESERVED	BE ZERO

;-----	(POST_TSS_PTR)

	DW	00800H			; SEGMENT LIMIT
	DW	TR_LOC			; SEGMENT BASE ADDRESS - LOW WORD
	DB	0			; SEGMENT BASE ADDRESS - HIGH BYTE
	DB	CPL0_DATA_ACCESS	; ACCESS RIGHTS BYTE
	DW	0			; RESERVED - MUST BE ZERO

;-----	(POST_LDTR)
LDT_LOC:
	DW	GDT_LEN 		; SEGMENT LIMIT
	DW	0D000H			; SEGMENT BASE ADDRESS - LOW WORD
	DB	0			; SEGMENT BASE ADDRESS - HIGH BYTE
	DB	LDT_DESC		; ACCESS RIGHTS BYTE
	DW	0			; RESERVED - MUST BE ZERO

;-----	(POST_LDT_PTR)

	DW	GDT_LEN 		; SEGMENT LIMIT
	DW	LDT_LOC 		; SEGMENT BASE ADDRESS - LOW WORD
	DB	0			; SEGMENT BASE ADDRESS - HIGH BYTE
	DB	CPL0_DATA_ACCESS	; ACCESS RIGHTS BYTE
	DW	0			; RESERVED - MUST BE ZERO

GDT_DATA_END	EQU	$

;-----	END OF PRE-ALLOCATED GDT


;-----	ENTRY POINTS FOR THE FIRST 32 SYSTEM INTERRUPTS

SYS_IDT_OFFSETS LABEL	WORD
					; INTERRUPTS AS DEFINED
	DW	OFFSET EXC_00		; EXCPT 00 - DIVIDE ERROR
	DW	OFFSET EXC_01		; EXCPT 01 - SINGLE STEP
	DW	OFFSET EXC_02		; EXCPT 02 - NMI, SYSTEM REQUEST FOR D1
	DW	OFFSET EXC_03		; EXCPT 03 - BREAKPOINT
	DW	OFFSET EXC_04		; EXCPT 04 - INTO DETECT
	DW	OFFSET EXC_05		; EXCPT 05 - BOUND
	DW	OFFSET EXC_06		; EXCPT 06 - INVALID OPCODE
	DW	OFFSET EXC_07		; EXCPT 07 - PROCESSOR EXT NOT AVAIL
	DW	OFFSET EXC_08		; EXCPT 08 - DOUBLE EXCEPTION
	DW	OFFSET EXC_09		; EXCPT 09 - PROCESSOR EXT SEGMENT ERR
	DW	OFFSET EXC_10		; EXCPT 10 - TSS BAD IN GATE TRANSFER
	DW	OFFSET EXC_11		; EXCPT 11 - SEGMENT NOT PRESENT
	DW	OFFSET EXC_12		; EXCPT 12 - STACK SEGMENT NOT PRESENT
	DW	OFFSET EXC_13		; EXCPT 13 - GENERAL PROTECTION
	DW	OFFSET EXC_14
	DW	OFFSET EXC_15
	DW	OFFSET EXC_16		; EXCPT 16 - PROCESSOR EXTENSION ERROR
	DW	OFFSET EXC_17
	DW	OFFSET EXC_18
	DW	OFFSET EXC_19
	DW	OFFSET EXC_20
	DW	OFFSET EXC_21
	DW	OFFSET EXC_22
	DW	OFFSET EXC_23
	DW	OFFSET EXC_24
	DW	OFFSET EXC_25
	DW	OFFSET EXC_26
	DW	OFFSET EXC_27
	DW	OFFSET EXC_28
	DW	OFFSET EXC_29
	DW	OFFSET EXC_30
	DW	OFFSET EXC_31

;-----	FORMAT INTERRUPT DESCRIPTORS (GATES) 32 - 255

FREE_INTS	DW	OFFSET IRET_ADDR	; DESTINATION OFFSET
		DW	SYS_ROM_CS		; DESTINATION SEGMENT
		DB	0,INT_GATE		; UNUSED AND ACCESS RIGHTS BYTE
SIDT_BLD	ENDP

CODE	ENDS
	END
