
/*
**
**
*/

#include "sys/types.h"
#include "sys/stream.h"
#include "sys/socket.h"
#include "/etc/conf/cf.d/config.h"

/*
** Definition for media type selection.
** The following definition should be the same as pnpinit.h
*/
#define MEDIA_UTP	0
#define MEDIA_BNC	1
#define MEDIA_AUI	2
#define MEDIA_AUTO	3
#define MEDIA_DEFAULT	-1


/*
** DE-220 card media selection. Can have one of the following values:
**
**	MEDIA_UTP	- twisted pair connection
**	MEDIA_BNC	- BNC connection
**	MEDIA_AUI	- AUI connection
**	MEDIA_AUTO	- Automatic detect connected media
**	MEDIA_DEFAULT	- Use EEPROM setting.
**
*/
#define ND22E_MediaType_0	MEDIA_AUTO
#define ND22E_MediaType_1	MEDIA_AUTO
#define ND22E_MediaType_2	MEDIA_AUTO
#define ND22E_MediaType_3	MEDIA_AUTO


/*
 *  Definition for early transmit option.
 */
#define EARLY_TX_DISABLED	0
#define EARLY_TX_ENABLED	1


/*
 *  DE-220 card early transmit option selection.
 */
#define ND22E_EarlyTx_0 	EARLY_TX_DISABLED
#define ND22E_EarlyTx_1 	EARLY_TX_DISABLED
#define ND22E_EarlyTx_2 	EARLY_TX_DISABLED
#define ND22E_EarlyTx_3 	EARLY_TX_DISABLED



#ifndef D22E_CNTLS
#define D22E_CNTLS	0
#endif


#if	D22E_CNTLS == 4

#define ND22EUNIT 4
int de220media[ND22EUNIT] = {
	ND22E_MediaType_0,
	ND22E_MediaType_1,
	ND22E_MediaType_2,
	ND22E_MediaType_3
	};

unsigned char de220earlytx[ND22EUNIT] = {
	ND22E_EarlyTx_0,
	ND22E_EarlyTx_1,
	ND22E_EarlyTx_2,
	ND22E_EarlyTx_3
	};


#elif	D22E_CNTLS == 3

#define ND22EUNIT 3
int de220media[ND22EUNIT] = {
	ND22E_MediaType_0,
	ND22E_MediaType_1,
	ND22E_MediaType_2,
	};

unsigned char de220earlytx[ND22EUNIT] = {
	ND22E_EarlyTx_0,
	ND22E_EarlyTx_1,
	ND22E_EarlyTx_2
	};

#elif	D22E_CNTLS == 2

#define ND22EUNIT 2
int de220media[ND22EUNIT] = {
	ND22E_MediaType_0,
	ND22E_MediaType_1,
	};

unsigned char de220earlytx[ND22EUNIT] = {
	ND22E_EarlyTx_0,
	ND22E_EarlyTx_1
	};

#elif	D22E_CNTLS == 1

#define ND22EUNIT 1
int de220media[ND22EUNIT] = {
	ND22E_MediaType_0,
	};

unsigned char de220earlytx[ND22EUNIT] = {
	ND22E_EarlyTx_0
	};

#endif

ulong DE220_BOARDS = ND22EUNIT;



