/*
    filename :  rsdevice.c

COPYRIGHT (c) 1989, 1990, 1991  Matrox Electronic Systems Ltd.
All Rights Reserved

*/
#include <stdio.h>

#include "imseries.h"
#include "imbind.h"
#include "proto.h"
#include "i_head.h"

#ifdef  I_MS_DOS
#include <sys\types.h>
#include <sys\timeb.h>
#include <time.h>
#endif

extern  I_IMGLOB    i_glob;

#if  defined(I_MS_DOS) || defined(I_OS2)
static short dummy;           /* use for dummy read */
#endif

/*****************/
#define DELAY 100L
/*****************/

#ifdef ANSI
static void delay(void);
#endif

/*/     Function:   iorsdevice()
*       Synopsis:   reset im-1280 board.
*
*       Date:       February 14, 1990
*
*       Parameter:  shrt type : reset type (#define : I_COLD or I_WARM)
*                                               
*       Return value:   no return value.
**/

#ifdef  ANSI
void    FTYPE iorsdevice(int handle, short type)
#else
FTYPE iorsdevice(handle, type)
int   handle;
short type;
#endif
{
#ifdef  I_UNIX
   ioctl(handle, IMG_RESET,&type);
#endif

/* #ifdef  I_MS_DOS !!!*/
#if  defined(I_MS_DOS) || defined(I_OS2)
    int keep_device;

    /* keep device handle */
    keep_device = i_glob.board;

    /* select device */
    iosldevice(handle);

    /* reset GSP */
    *(char far *) &(i_glob.imghra->hstctlh) = (char)0x80;

    /* wait */

    delay();

    /* dummy read */
    dummy = i_glob.imghra->hstctlh;

    /* second reset try for the cases were GSP is put in big endian mode */
    /* by PC boot sequence */
    *(char far *) &(i_glob.imghra->intenb) = (char)0x80;

    /* wait */
    delay();

    /* dummy read */
    dummy = i_glob.imghra->hstctlh;

    /* reset baseboard */
    i_glob.imghra->hctrl = 0x01;

    /* wait */
    delay();

    /* dummy read */
    dummy = i_glob.imghra->hstctlh;

    /* GSP CONFIG register: GSP in little endian, CBP bit set */
    i_glob.imghra->config = 0x0c0a;

    if (type == I_WARM)
    {
        /* restart shell */
        i_glob.imghra->hstctlh = 0x0300;

        /* wait */
        delay();

        /* poll until ready */
        while (( i_glob.imghra->hstctll ) & 0x10 );
    }

    /* restore device selection */
    iosldevice(keep_device);

#endif
    
#ifdef  I_OS2
#if 0 /*!!!*/
  DosDevIOCtl( (PUSHORT) 0,
               (PUSHORT) 0,
               (USHORT)  I_RESET,
               (USHORT)  0x80,
               (HFILE)   handle );
  DosSleep(5000L);
#endif /*!!!*/
#endif

}


#if  defined(I_MS_DOS) || defined(I_OS2)

#ifdef  ANSI
static void delay(void)
#else
static delay()
#endif
{
#ifndef I_OS2
    struct timeb	time0,time1;
	 signed long 	difference;
	 
	 ftime(&time0);

    do
      {
		ftime(&time1);
		difference  = ((signed long) time1.time) - ((signed long)time0.time);
      difference *= (signed long)1000L;
      difference += ((signed long) time1.millitm) - ((signed long)time0.millitm);
		} while (difference <= (signed long) DELAY);
#else /*I_OS2*/
    DosSleep(1000L);
#endif /* I_OS2 */


} /* delay() */ 

#endif

