/*
    filename:   imglob.h

COPYRIGHT (c) 1989, 1990, 1991  Matrox Electronic Systems Ltd.
All Rights Reserved

	This file contains definitions for the global structure maintained
	for the C-Binding layer.
*/

#ifndef __I_IMGLOB_H__
#define __I_IMGLOB_H__

/* Need imseries.h for I_UNIX defines */
#ifndef __I_IMSERIES_H__
#include "imseries.h"
#endif /* __I_IMSERIES_H__ */

#ifdef I_UNIX

#define IMGMAP           struct img_map
#define IMGHRA           struct hra

#define   OPEN_IMAGE(x)  open( "/dev/img", O_RDWR )
#define  CLOSE_IMAGE(x)  close(x)
#define    MAP_IMAGE(x)  (IMGMAP*)mmap((caddr_t)0,MAP_SIZE,PROT_READ|PROT_WRITE,MAP_SHARED|_MAP_NEW,x,0)
#define MUNMAP_IMAGE(x)  munmap(x,MAP_SIZE)

/* global structure to hold all global variables */

typedef struct i_imglob {
char    *driver[I_N_OF_DEVICES];    /* device driver names and path */
int     board;                      /* handle to current board */
int     vram;                       /* handle to current mem device */
int     channel;                    /* current communication channel */

#ifdef  I_PHYSMAP

int     handle[I_N_OF_DEVICES];
int     img_dev;
int     img_unit;         /* HRA unit ( 0 or 1 ) */
int     vram_dev;
int     vram_unit;         /* HRA unit ( 0 or 1 ) */
IMGMAP  *imgmap;
IMGMAP  *vrammap;
int     img_fd[I_N_OF_DEVICES];
IMGMAP  *img_addr[I_N_OF_DEVICES];
IMGMAP  *mem[I_N_OF_DEVICES];
int     fd[I_N_OF_DEVICES];
IMGHRA  *imghra;
IMGHRA  *vramhra;
int     keep_hctrl[I_N_OF_DEVICES];
unsigned int   ioerror;

#endif

}   I_IMGLOB;

#endif /* I_UNIX */


#ifdef I_MS_DOS

#define   OPEN_IMAGE(x)  x

#define   MAP_IMAGE(x)   (x<3)?(IMGMAP *)0xC4000000L:(IMGMAP *)0xCC000000L

#define IMGMAP           struct img_map far
#define IMGHRA           struct hra far

typedef  struct i_imglob {
int      board;               /* handle to current board */
int      vram;                /* handle to current mem device */
short    channel;             /* current communication channel */
short    img_dev;
short    img_unit;            /* HRA unit ( 0 or 1 ) */
short    vram_dev;
short    vram_unit;           /* HRA unit ( 0 or 1 ) */
IMGMAP   *imgmap;
IMGMAP   *vrammap;
short    img_fd[I_N_OF_DEVICES];
IMGMAP   *img_addr[I_N_OF_DEVICES];
IMGHRA   *imghra;
IMGHRA   *vramhra;
short    keep_hctrl[I_N_OF_DEVICES];
unsigned long high_map;  /* determines which 1M window to acces in high map */
unsigned char host_cpu_type; /* value returned by _cpuid in ioopdevice() */
unsigned short ioerror;
}   I_IMGLOB;

#endif /* I_MS_DOS */


#ifdef I_OS2

typedef struct i_imglob {
char    *driver[I_N_OF_DEVICES];    /* device driver names */
int     board;            /* current device handle */
int     vram;                     /* handle to current mem device */
short   channel;                    /* current communication channel */
short   host_cpu_type;

#ifdef  PHYSMAP

short   img_dev;          /* current device #define */
short   img_unit;         /* current device HRA unit ( 0 or 1 ) */
IMGMAP  *imgmap;          /* current device address */
IMGHRA  *imghra;          /* current device hra address */
short   vram_dev;
short   vram_unit;                 /* HRA unit ( 0 or 1 ) */
IMGMAP  *vrammap;
IMGHRA  *vramhra;

short   fd[I_N_OF_DEVICES];
IMGMAP  *img_addr[I_N_OF_DEVICES];
short   keep_hctrl[I_N_OF_DEVICES];
unsigned short ioerror;

#endif

}   I_IMGLOB;
#endif /* I_OS2 */
#endif /* __I_IMGLOB_H__ */

