/*
 * Decompiled with CFR 0.152.
 */
package com.ami.iusb;

import com.ami.iusb.IUSBRedirSession;
import com.ami.kvm.jviewer.gui.JViewerApp;
import com.supermicro.ipmi.IPMIAMIOEMCommand;
import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.ipmi.IPMINetworkInterface;
import com.supermicro.ipmi.IPMIVersion;
import com.supermicro.ipmi.ISessionController;
import java.util.HashMap;

public class SMCVMManager {
    private static SMCVMManager instance = new SMCVMManager();
    public HashMap<String, IUSBRedirSession> hosts = new HashMap();
    public HashMap<String, String> tokens = new HashMap();

    private SMCVMManager() {
    }

    public static SMCVMManager getInstance() {
        return instance;
    }

    public IUSBRedirSession createIUSBRedirSession(String ip) {
        if (this.hosts.get(ip) != null) {
            return this.hosts.get(ip);
        }
        JDummyViewerApp jDummyViewerApp = new JDummyViewerApp(null);
        IUSBRedirSession iusbRedirSession = new IUSBRedirSession(jDummyViewerApp);
        jDummyViewerApp.setIUSBRedirSession(iusbRedirSession);
        this.hosts.put(ip, iusbRedirSession);
        return iusbRedirSession;
    }

    public String helpGetKVMSessionToken(String ip, String id, String password) throws Exception {
        if (this.tokens.get(ip) != null) {
            return this.tokens.get(ip);
        }
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        config.setIp(ip);
        config.setUserName(id);
        config.setPassword(password);
        config.setPrivilege((byte)4);
        ISessionController sessionController = IPMIVersion.getSessionController(config);
        IPMIAMIOEMCommand ipmiAMIOEMCommand = new IPMIAMIOEMCommand(null);
        IPMINetworkInterface rmcp = sessionController.startup(config);
        if (rmcp == null) {
            throw new Exception("Can't login");
        }
        ipmiAMIOEMCommand.setIPMIInterface(rmcp);
        String token = ipmiAMIOEMCommand.getKVMSessionToken();
        sessionController.closeSession();
        this.tokens.put(ip, token);
        return token;
    }

    public void clearToken(String ip) {
        this.tokens.remove(ip);
    }

    public void clearAllTokens() {
        this.tokens.clear();
    }

    public void clearIUSBRedirSession(String ip) {
        this.hosts.remove(ip);
    }

    public void clearAllIUSBRedirSession() {
        this.hosts.clear();
    }

    public static void main(String[] args) {
        String ip = "192.168.12.177";
        String id = "ADMIN";
        String pw = "ADMIN";
        try {
            SMCVMManager smcVMManager = SMCVMManager.getInstance();
            IUSBRedirSession iUSBRedirSession = smcVMManager.createIUSBRedirSession(ip);
            String token = smcVMManager.helpGetKVMSessionToken(ip, id, pw);
            boolean result = iUSBRedirSession.simpleStartFloppyImageRedir(ip, token, "C:\\DOS50.img");
            System.out.println(result);
            try {
                Thread.sleep(1000000L);
            }
            catch (InterruptedException ex) {}
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public class JDummyViewerApp
    extends JViewerApp {
        IUSBRedirSession usbRedireSession;
        boolean isDebug = true;

        public JDummyViewerApp(IUSBRedirSession usbRedireSession) {
            this.usbRedireSession = usbRedireSession;
        }

        public void setIUSBRedirSession(IUSBRedirSession usbRedireSession) {
            this.usbRedireSession = usbRedireSession;
        }

        @Override
        public void generalErrorMessage(String message) {
            if (this.isDebug) {
                System.out.println(message);
            }
        }

        @Override
        public void reportFloppyAbnormal() {
            this.usbRedireSession.stopFloppyAbnormal();
        }

        @Override
        public void reportCDROMAbnormal() {
            this.usbRedireSession.stopCDROMAbnormal();
        }
    }
}

