/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.IPMIBMCFileCommand;
import com.supermicro.ipmi.lic.SWKeyExpiredException;
import com.supermicro.ipmi.lic.SWLicenseAdapter;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;
import java.io.File;

public class IPMIUploadBIOSConfigurationCommand
extends SuperBladeCommand {
    @Override
    public boolean preValidate() {
        if (this.parameters == null) {
            MOut.G(this).println("Filename is needed");
            this.usage();
            return false;
        }
        File file = new File(this.parameters[0]);
        if (!file.isFile()) {
            MOut.G(this).println("File(" + this.parameters[0] + ") not found");
            return false;
        }
        return true;
    }

    @Override
    public void runCommand() throws Exception {
        boolean result = false;
        String options = "";
        int optionFlag = 0;
        this.closeSessionIfExist();
        boolean isPassSWKey = false;
        try {
            if (SWLicenseAdapter.isSWFRUSupported(this.config) && SWLicenseAdapter.check_SFT_SUM_LIC_ProductKey(this.config)) {
                isPassSWKey = true;
            }
        }
        catch (SWKeyExpiredException e) {
            MOut.G(this).println("Node product key is expired");
            this.statusCode = 155;
            return;
        }
        this.createSession();
        if (!isPassSWKey && this.checkIfSWProductKeyNotActivated()) {
            MOut.G(this).println("The Node product key needs to be activated for this device");
            this.statusCode = 153;
            return;
        }
        IPMIBMCFileCommand ipmiBMCFileCommand = new IPMIBMCFileCommand(this.ipmiCMMOEMCommand.getIPMIInterface());
        if (this.parameters.length > 1) {
            for (int i = 1; i < this.parameters.length; ++i) {
                options = options + this.parameters[i] + " ";
            }
            if (options.toLowerCase().indexOf("-f") != -1) {
                MOut.G(this).println("Option: Forced to reset automatically");
                optionFlag |= 1;
            }
        }
        this.statusCode = (result = ipmiBMCFileCommand.uploadBIOSConfiguration(this.parameters[0], optionFlag)) ? 0 : 149;
    }

    public void usage() {
        MOut.G(this).println("Usage: bios configupload <filename> [options...]");
        MOut.G(this).println("Options: ");
        MOut.G(this).println("   -F: When BIOS config apply successfully, the server will be shutdown softly,");
        MOut.G(this).println("       and if not, the server will be forced reset automatically.");
        MOut.G(this).println("");
        MOut.G(this).println("* BIOS config upload command only supports part motherboards");
        MOut.G(this).println("* This function needs to activate Node product key");
    }
}

