/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.DeviceInfo;
import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.IPMINM20Command;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.NM20AbstractCommand;

public class NM20CpuMemoryTemperatureCommand
extends NM20AbstractCommand {
    @Override
    public void runNM20Command() throws Exception {
        DeviceInfo deviceID = this.ipmiNM20Command.getDeviceID();
        if (deviceID.productID[0] == 9) {
            MOut.G(this).println("Greenlow platform is not supported.");
            this.statusCode = 0;
            return;
        }
        try {
            IPMINM20Command.CpuMemoryTemperature cpuMemoryTemp = this.ipmiNM20Command.getCPUandMemoryTemperature();
            for (int i = 0; i < 4; ++i) {
                try {
                    byte value = this.ipmiNM20Command.getSensorReading((byte)(48 + i));
                    if (value == 0) continue;
                    cpuMemoryTemp.setTjmaxValue((byte)i, value);
                    continue;
                }
                catch (IPMIException ex1) {
                    byte[] getTempRawPECI = new byte[]{48, 5, 5, -95, 0, 16, 0, 0};
                    getTempRawPECI[0] = (byte)(48 + i);
                    try {
                        byte[] value2 = this.ipmiNM20Command.sendRawPECI(getTempRawPECI);
                        cpuMemoryTemp.setTjmaxValue((byte)i, value2[6]);
                        continue;
                    }
                    catch (IPMIException ex2) {
                        // empty catch block
                    }
                }
            }
            MOut.G(this).println(cpuMemoryTemp.toString());
        }
        catch (Exception ex) {
            MOut.G(this).println(ex.getMessage());
            this.statusCode = 148;
            return;
        }
        this.statusCode = 0;
    }
}

