/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.IPMINM20Command;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.NM20AbstractCommand;

public class NM20StatisticsCommand
extends NM20AbstractCommand {
    @Override
    public void runNM20Command() throws Exception {
        if (this.parameters == null || this.parameters.length < 3) {
            MOut.G(this);
            MOut.G().println("statistics <mode> <domainID> <policy ID>");
            MOut.G(this);
            MOut.G().println("mode:");
            MOut.G(this);
            MOut.G().println("  1(01h) \u2013 global power statistics in [Watts]");
            MOut.G(this);
            MOut.G().println("  2(02h) \u2013 global inlet temperature statistics in [Celsius]");
            MOut.G(this);
            MOut.G().println("  3(03h) \u2013 Global throttling statistics [%] (NM3.0)");
            MOut.G(this);
            MOut.G().println("  4(04h) \u2013 Global volumetric airflow statistics [1/10th of CFM] (NM3.0)");
            MOut.G(this);
            MOut.G().println("  5(05h) \u2013 Global outlet airflow temperature statistics [Celsius] (NM3.0)");
            MOut.G(this);
            MOut.G().println("  6(06h) \u2013 Global chassis power statistics [Watts] (NM3.0)");
            MOut.G(this);
            MOut.G().println(" 17(11h) \u2013 per policy power statistics in [Watts]");
            MOut.G(this);
            MOut.G().println(" 18(12h) \u2013 per policy trigger statistics in [Celsius]");
            MOut.G(this);
            MOut.G().println(" 19(13h) \u2013 Per policy throttling statistics in [%] (NM3.0)");
            MOut.G(this);
            MOut.G().println(" 27(1Bh) \u2013 global Host Unhandled Requests statistics");
            MOut.G(this);
            MOut.G().println(" 28(1Ch) \u2013 global Host Response Time statistics");
            MOut.G(this);
            MOut.G().println(" 29(1Dh) \u2013 global CPU throttling statistics");
            MOut.G(this);
            MOut.G().println(" 30(1Eh) \u2013 global memory throttling statistics");
            MOut.G(this);
            MOut.G().println(" 31(1Fh) \u2013 global Host Communication Failure statistics");
            MOut.G(this);
            MOut.G().println("Domain ID:");
            MOut.G(this);
            MOut.G().println(" 0 \u2013 Entire platform");
            MOut.G(this);
            MOut.G().println(" 1 \u2013 CPU subsystem");
            MOut.G(this);
            MOut.G().println(" 2 \u2013 Memory subsystem");
            MOut.G(this);
            MOut.G().println(" 3 \u2013 HW Protection (NM3.0)");
            MOut.G(this);
            MOut.G().println(" 4 \u2013 High Power I/O subsystem");
            MOut.G(this);
            MOut.G().println(" For mode in a range 1Bh to 1Fh Domain ID must be set to 00h");
            MOut.G(this);
            MOut.G().println("Policy ID:");
            MOut.G(this);
            MOut.G().println(" Apply for mode 11h or 12h. otherwise set to 0");
            this.statusCode = 0;
            return;
        }
        byte mode = -1;
        try {
            mode = Byte.parseByte(this.parameters[0]);
        }
        catch (NumberFormatException ex) {
            MOut.G(this);
            MOut.G().print(ex.getMessage());
            this.statusCode = 147;
            return;
        }
        byte did = -1;
        try {
            did = Byte.parseByte(this.parameters[1]);
        }
        catch (NumberFormatException ex) {
            MOut.G(this);
            MOut.G().print(ex.getMessage());
            this.statusCode = 147;
            return;
        }
        byte pid = -1;
        try {
            pid = Byte.parseByte(this.parameters[2]);
        }
        catch (NumberFormatException ex) {
            MOut.G(this);
            MOut.G().print(ex.getMessage());
            this.statusCode = 147;
            return;
        }
        IPMINM20Command.NodeManagerStatistics stat = null;
        try {
            stat = this.ipmiNM20Command.getNodeManagerStatistics(mode, did, pid);
        }
        catch (Exception ex) {
            MOut.G(this);
            MOut.G().println(ex.getMessage());
            this.statusCode = 148;
            return;
        }
        if (stat == null) {
            MOut.G(this);
            MOut.G().println("Call getNodeManagerStatistics failed");
        }
        if ((stat.domainIdAndPolicyState & 0x40) != 64) {
            MOut.G(this);
            MOut.G().println("Measurements are suspended");
            this.statusCode = 0;
            return;
        }
        String unit = "";
        unit = mode == 1 || mode == 6 || mode == 17 ? " w" : (mode == 2 || mode == 5 || mode == 18 ? " c" : (mode == 3 || mode == 19 ? " %" : (mode == 4 ? " 1/10th of CFM" : " ")));
        MOut.G(this);
        MOut.G().println("Current = " + ByteUtility.twoBytesToInt(stat.current) + unit);
        MOut.G(this);
        MOut.G().println("Minimum = " + ByteUtility.twoBytesToInt(stat.minimum) + unit);
        MOut.G(this);
        MOut.G().println("Maximum = " + ByteUtility.twoBytesToInt(stat.maximum) + unit);
        MOut.G(this);
        MOut.G().println("Average = " + ByteUtility.twoBytesToInt(stat.average) + unit);
        MOut.G(this);
        MOut.G().println("Time    = " + ByteUtility.fourByteToDateFormat2(stat.timeStamp));
        MOut.G(this);
        MOut.G().println("Reporting Period = " + ByteUtility.fourBytesToIntByLSBFirst(stat.statisticsReportingPeriod) + " sec");
        MOut.G(this);
        MOut.G().println("Domain ID:");
        if ((stat.domainIdAndPolicyState & 0xF) == 0) {
            MOut.G(this);
            MOut.G().println("    Entire platform");
        } else if ((stat.domainIdAndPolicyState & 0xF) == 1) {
            MOut.G(this);
            MOut.G().println("    CPU subsystem");
        } else if ((stat.domainIdAndPolicyState & 0xF) == 2) {
            MOut.G(this);
            MOut.G().println("    Memory subsystem");
        } else if ((stat.domainIdAndPolicyState & 0xF) == 3) {
            MOut.G(this);
            MOut.G().println("    HW Protection");
        } else if ((stat.domainIdAndPolicyState & 0xF) == 4) {
            MOut.G(this);
            MOut.G().println("    High Power I/O subsystem");
        }
        MOut.G(this);
        MOut.G().println("Policy/Global Administrative state:");
        if ((stat.domainIdAndPolicyState & 0x10) == 16) {
            MOut.G(this);
            MOut.G().println("    policy is enabled by user and NM Policy Control is Globally Enabled");
        } else if ((stat.domainIdAndPolicyState & 0x10) == 0) {
            MOut.G(this);
            MOut.G().println("    policy is not enabled");
        }
        MOut.G(this);
        MOut.G().println("Policy Operational state:");
        if ((stat.domainIdAndPolicyState & 0x20) == 32) {
            MOut.G(this);
            MOut.G().println("    Policy is monitoring defined trigger and will start enforcing the ");
            MOut.G(this);
            MOut.G().println("    power limit if defined trigger is exceeded");
        } else if ((stat.domainIdAndPolicyState & 0x20) == 0) {
            MOut.G(this);
            MOut.G().println("    Policy is suspended");
        }
        MOut.G(this);
        MOut.G().println("Measurements state:");
        if ((stat.domainIdAndPolicyState & 0x40) == 64) {
            MOut.G(this);
            MOut.G().println("    Measurements in progress");
        } else if ((stat.domainIdAndPolicyState & 0x40) == 0) {
            MOut.G(this);
            MOut.G().println("    Measurements are suspended");
        }
        MOut.G(this);
        MOut.G().println("Policy activation state:");
        if ((stat.domainIdAndPolicyState & 0xFFFFFF80) == -128) {
            MOut.G(this);
            MOut.G().println("    Policy is triggered and is actively limiting the defined power limit");
        } else if ((stat.domainIdAndPolicyState & 0xFFFFFF80) == 0) {
            MOut.G(this);
            MOut.G().println("    Policy is not triggered");
        }
        MOut.G(this);
        MOut.G().println("raw = " + ByteUtility.bytesToHex(stat.raw));
        this.statusCode = 0;
    }
}

