/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi;

import com.supermicro.ipmi.ByteUtility;

public class SDRRecordC0h_NMOEMSDR {
    private byte[] recordID;
    private byte SDRVersion;
    private byte recordType;
    private byte recordLength;
    private byte[] oemID;
    private byte recordSubtype;
    private byte subTypeVersion;
    private byte slaveAddress;
    private byte channel;
    private byte healthEventSensorNumber;
    private byte exceptionEventSensorNumber;
    private byte operationalCapailitiesSensorNumber;
    private byte alertThresholdExceededSensorNumber;
    private byte[] raw;

    public boolean isNMOEMSDR() {
        return this.oemID[0] == 87 && this.oemID[1] == 1 && this.oemID[2] == 0 && this.recordSubtype == 13;
    }

    public boolean isIPMB() {
        return this.slaveAddress != 32;
    }

    public void fromRaw(byte[] raw) {
        int index = 0;
        this.recordID = new byte[2];
        System.arraycopy(raw, index += 2, this.recordID, 0, this.recordID.length);
        this.SDRVersion = raw[index += this.recordID.length];
        this.recordType = raw[++index];
        this.recordLength = raw[++index];
        this.oemID = new byte[3];
        System.arraycopy(raw, ++index, this.oemID, 0, this.oemID.length);
        this.recordSubtype = raw[index += this.oemID.length];
        this.subTypeVersion = raw[++index];
        this.slaveAddress = raw[++index];
        this.channel = (byte)(raw[++index] >> 4);
        this.healthEventSensorNumber = raw[++index];
        this.exceptionEventSensorNumber = raw[++index];
        this.operationalCapailitiesSensorNumber = raw[++index];
        this.alertThresholdExceededSensorNumber = raw[++index];
        ++index;
        this.raw = raw;
        if (this.slaveAddress == 0) {
            this.slaveAddress = (byte)-120;
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Record ID          = " + ByteUtility.bytesToHex(this.recordID) + " \n");
        sb.append("SDR Version        = " + ByteUtility.byteToHex(this.SDRVersion) + "h \n");
        sb.append("Record Type        = " + ByteUtility.byteToHex(this.recordType) + "h \n");
        sb.append("Record Length      = " + ByteUtility.byteToHex(this.recordLength) + "h \n");
        sb.append("OEM ID             = " + ByteUtility.bytesToHex(this.oemID) + "h \n");
        sb.append("Record Subtype     = " + ByteUtility.byteToHex(this.recordSubtype) + "h \n");
        sb.append("SubType Version    = " + ByteUtility.byteToHex(this.subTypeVersion) + "h \n");
        sb.append("Slave Address      = " + ByteUtility.byteToHex(this.slaveAddress) + "h \n");
        sb.append("Channel            = " + ByteUtility.byteToHex(this.channel) + "h \n");
        sb.append("Health Event Sensor Number             = " + ByteUtility.byteToHex(this.healthEventSensorNumber) + "h \n");
        sb.append("Exception Event Sensor Number          = " + ByteUtility.byteToHex(this.exceptionEventSensorNumber) + "h \n");
        sb.append("Operational Capailities Sensor Number  = " + ByteUtility.byteToHex(this.operationalCapailitiesSensorNumber) + "h \n");
        sb.append("Alert Threshold Exceeded Sensor Number = " + ByteUtility.byteToHex(this.alertThresholdExceededSensorNumber) + "h \n");
        return sb.toString();
    }

    public void setRecordID(byte[] recordID) {
        this.recordID = recordID;
    }

    public void setSDRVersion(byte SDRVersion) {
        this.SDRVersion = SDRVersion;
    }

    public void setRecordType(byte recordType) {
        this.recordType = recordType;
    }

    public void setRecordLength(byte recordLength) {
        this.recordLength = recordLength;
    }

    public void setOemID(byte[] oemID) {
        this.oemID = oemID;
    }

    public void setRecordSubtype(byte recordSubtype) {
        this.recordSubtype = recordSubtype;
    }

    public void setSubTypeVersion(byte subTypeVersion) {
        this.subTypeVersion = subTypeVersion;
    }

    public void setSlaveAddress(byte slaveAddress) {
        this.slaveAddress = slaveAddress;
    }

    public void setChannel(byte channel) {
        this.channel = channel;
    }

    public void setHealthEventSensorNumber(byte healthEventSensorNumber) {
        this.healthEventSensorNumber = healthEventSensorNumber;
    }

    public void setExceptionEventSensorNumber(byte exceptionEventSensorNumber) {
        this.exceptionEventSensorNumber = exceptionEventSensorNumber;
    }

    public void setOperationalCapailitiesSensorNumber(byte operationalCapailitiesSensorNumber) {
        this.operationalCapailitiesSensorNumber = operationalCapailitiesSensorNumber;
    }

    public void setAlertThresholdExceededSensorNumber(byte alertThresholdExceededSensorNumber) {
        this.alertThresholdExceededSensorNumber = alertThresholdExceededSensorNumber;
    }

    public byte[] getRecordID() {
        return this.recordID;
    }

    public byte getSDRVersion() {
        return this.SDRVersion;
    }

    public byte getRecordType() {
        return this.recordType;
    }

    public byte getRecordLength() {
        return this.recordLength;
    }

    public byte[] getOemID() {
        return this.oemID;
    }

    public byte getRecordSubtype() {
        return this.recordSubtype;
    }

    public byte getSubTypeVersion() {
        return this.subTypeVersion;
    }

    public byte getSlaveAddress() {
        return this.slaveAddress;
    }

    public byte getChannel() {
        return this.channel;
    }

    public byte getHealthEventSensorNumber() {
        return this.healthEventSensorNumber;
    }

    public byte getExceptionEventSensorNumber() {
        return this.exceptionEventSensorNumber;
    }

    public byte getOperationalCapailitiesSensorNumber() {
        return this.operationalCapailitiesSensorNumber;
    }

    public byte getAlertThresholdExceededSensorNumber() {
        return this.alertThresholdExceededSensorNumber;
    }
}

