/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.FRUInfo;
import com.supermicro.ipmi.GlobalDefine;
import com.supermicro.ipmi.IPMIFRUCommand;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;

public class IPMIFRU1RestoreCommand
extends SuperBladeCommand {
    @Override
    public boolean preValidate() {
        if (this.parameters == null) {
            MOut.G(this).println("Filename is needed");
            return false;
        }
        if (this.parameters.length == 2) {
            File file = new File(this.parameters[0]);
            if (!file.isFile()) {
                MOut.G(this).println("File(" + this.parameters[0] + ") not found");
                return false;
            }
            if (this.parameters[1].equals(GlobalDefine.FRU1_EDIT_Password)) {
                return true;
            }
            MOut.G(this).println("Invalid password.");
            return false;
        }
        MOut.G(this).println("Invalid field.");
        MOut.G(this).println("");
        this.usage();
        return false;
    }

    public void usage() {
        MOut.G(this).println("Usage: fru1restore <filename> <password>");
    }

    @Override
    public void runCommand() throws Exception {
        IPMIFRUCommand ipmiFRUCommand = new IPMIFRUCommand(this.ipmiCMMOEMCommand.getIPMIInterface());
        File file = new File(this.parameters[0]);
        FileInputStream fileData = new FileInputStream(file);
        byte[] fruData = new byte[(int)file.length()];
        ((InputStream)fileData).read(fruData);
        FRUInfo fruInfo = FRUInfo.fromRaw(fruData);
        ipmiFRUCommand.unlockFRU();
        boolean result = ipmiFRUCommand.writeFRU1(fruInfo.fru);
        ipmiFRUCommand.lockFRU();
        if (result) {
            MOut.G(this).println("Restore FRU raw data successfully");
            this.statusCode = 0;
        } else {
            MOut.G(this).println("Restore FRU raw data failed");
            this.statusCode = 149;
        }
    }
}

