/*
 * Decompiled with CFR 0.152.
 */
package nn.pp.rc;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.ImageCapabilities;
import java.awt.RenderingHints;
import java.awt.image.ImagingOpException;
import java.awt.image.VolatileImage;
import java.io.IOException;
import nn.pp.rc.ByteColorRFBRenderer;

public class J14ByteColorRFBRenderer
extends ByteColorRFBRenderer {
    static RenderingHints rhsmoth = new RenderingHints(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
    private boolean repaint_done;
    private VolatileImage vvimg;
    private boolean interpolcabable = true;
    private boolean interpol = false;

    public J14ByteColorRFBRenderer(Component comp) {
        super(comp);
        comp.setFocusTraversalKeysEnabled(false);
    }

    @Override
    public void sendUpdateMsg() throws IOException {
        this.repaint();
    }

    @Override
    public void setRenderSize(Dimension d) {
        super.setRenderSize(d);
        this.mysize = d;
        this.createVImg(d);
    }

    @Override
    public void setInterpol(boolean ip) {
        if (this.interpol != ip) {
            this.interpol = ip;
            this.repaint();
        }
    }

    @Override
    public void paint(Graphics g, boolean scale, Dimension scalesize) {
        if (this.vimg == null) {
            return;
        }
        do {
            switch (this.vvimg.validate(this.comp.getGraphicsConfiguration())) {
                case 2: {
                    this.createVImg(this.mysize);
                }
                case 1: {
                    this.gvimg.dispose();
                    this.gvimg = this.vvimg.createGraphics();
                    this.gvimg.setColor(Color.black);
                    this.gvimg.fillRect(0, 0, this.mysize.width, this.mysize.height);
                    try {
                        this.rfb.writeFullFramebufferUpdateRequest();
                        break;
                    }
                    catch (IOException ignore) {
                        // empty catch block
                    }
                }
            }
            if (scale) {
                if (this.interpolcabable && this.interpol) {
                    Graphics2D g2d = (Graphics2D)g;
                    g2d.setRenderingHints(rhsmoth);
                }
                try {
                    this.paintContent(g, scale, scalesize);
                }
                catch (ImagingOpException e) {
                    this.interpolcabable = false;
                }
                continue;
            }
            this.paintContent(g, scale, scalesize);
        } while (this.vvimg.contentsLost());
    }

    @Override
    public void repaint() {
        this.comp.repaint();
    }

    private void createVImg(Dimension d) {
        if (this.vimg != null) {
            this.vimg.flush();
        }
        if (this.gvimg != null) {
            this.gvimg.dispose();
        }
        this.vvimg = this.comp.createVolatileImage(d.width, d.height);
        this.vimg = this.vvimg;
        this.gvimg = this.vvimg.createGraphics();
    }

    public String toString() {
        String isa;
        String tv;
        if (null == this.vvimg) {
            tv = "na";
            isa = "na";
        } else {
            ImageCapabilities ic = this.vvimg.getCapabilities();
            isa = "" + ic.isAccelerated();
            tv = "" + ic.isTrueVolatile();
        }
        return this.getClass().toString() + "Console: TrueVolatile=" + tv + " isAccelerated=" + isa;
    }
}

