/*
 * Decompiled with CFR 0.152.
 */
package nn.pp.rckbd;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import nn.pp.rc.GenericTimer;
import nn.pp.rckbd.KbdLayout;
import nn.pp.rckbd.KeyDef;
import nn.pp.rckbd.KeyboardEvent;
import nn.pp.rckbd.KeyboardListener;
import nn.pp.rckbd.ModifierOptions;
import nn.pp.rckbd.SoftKbd;

public class KeyEventHandler {
    private static final Object classLock = new Object();
    private SoftKbd softkbd = null;
    private Vector hardkbd = new Vector();
    private Hashtable lastmodifiers;
    private Hashtable keydefs;
    private KbdLayout actuallayout = null;
    private int ctrl_counter = 0;
    private Short hilfshort = new Short(0);
    private Vector keyboardlisteners = new Vector();
    private GenericTimer timer;
    private boolean strgFlag;
    private boolean altgrFlag = false;
    public static final Boolean KEYBOARD = new Boolean(false);
    public static final Boolean SOFTKEYBOARD = new Boolean(true);

    public KeyEventHandler(KbdLayout layout) {
        this.lastmodifiers = new Hashtable(3);
        this.keydefs = new Hashtable();
        this.init(layout);
    }

    public void init(KbdLayout layout) {
        if (this.actuallayout != layout) {
            this.actuallayout = layout;
            KeyDef[] kbd_layout = layout.getKeyDefs();
            this.keydefs.clear();
            for (int i = 0; i < kbd_layout.length; ++i) {
                this.keydefs.put(new Short(kbd_layout[i].keynr), kbd_layout[i]);
            }
            this.resetAllModifiers();
            if (this.softkbd != null) {
                this.softkbd.setLayout(layout);
            }
        }
        this.timer = new GenericTimer(30, new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                Object object = classLock;
                synchronized (object) {
                    if (KeyEventHandler.this.strgFlag) {
                        KeyEventHandler.this.strgFlag = false;
                        KeyEventHandler.this.internalPressed(new Short(54), KEYBOARD);
                    }
                }
            }
        });
        this.timer.setRepeats(false);
    }

    public void addSoftKbdSupport(SoftKbd kbd) {
        this.softkbd = kbd;
    }

    public void removeSoftKbdSupport() {
        this.softkbd = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pressed(Short shortnr, Boolean source) {
        Object object = classLock;
        synchronized (object) {
            if (shortnr.intValue() == 54 && source.equals(KEYBOARD) && !this.timer.isRunning()) {
                this.timer.start();
                this.strgFlag = true;
                return;
            }
            if ((shortnr.intValue() == 55 || shortnr.intValue() == 57) && source.equals(KEYBOARD)) {
                if (this.strgFlag) {
                    shortnr = new Short(57);
                    this.timer.stop();
                    this.strgFlag = false;
                    this.altgrFlag = true;
                } else if (this.altgrFlag) {
                    return;
                }
            }
            this.internalPressed(shortnr, source);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void internalPressed(Short shortnr, Boolean source) {
        Object object = classLock;
        synchronized (object) {
            KeyDef actualkd = (KeyDef)this.keydefs.get(shortnr);
            if (actualkd == null) {
                return;
            }
            if (actualkd.isModifier()) {
                ModifierOptions modopt = (ModifierOptions)this.lastmodifiers.get(shortnr);
                if (null != modopt) {
                    if (source.equals(KEYBOARD)) {
                        modopt.source = source;
                        this.setClicked(shortnr, true);
                        if (actualkd.isPermanentModifier()) {
                            this.lastmodifiers.remove(shortnr);
                        }
                    } else {
                        if (actualkd.isPermanentModifier()) {
                            this.setClicked(shortnr, true);
                        } else {
                            this.setClicked(shortnr, false);
                        }
                        this.lastmodifiers.remove(shortnr);
                        if (this.softkbd != null) {
                            this.setSoftKbdModifier();
                        }
                    }
                    return;
                }
                this.lastmodifiers.put(shortnr, new ModifierOptions((KeyDef)this.keydefs.get(shortnr), source));
                if (this.softkbd != null) {
                    this.setSoftKbdModifier();
                }
            }
            this.setClicked(shortnr, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void released(Short shortnr, Boolean source) {
        Object object = classLock;
        synchronized (object) {
            KeyDef actualkd;
            if (shortnr.intValue() == 54 && this.altgrFlag && source.equals(KEYBOARD)) {
                return;
            }
            if ((shortnr.intValue() == 55 || shortnr.intValue() == 57) && this.altgrFlag && source.equals(KEYBOARD)) {
                shortnr = new Short(57);
                this.altgrFlag = false;
            }
            if ((actualkd = (KeyDef)this.keydefs.get(shortnr)) == null) {
                return;
            }
            if (actualkd.isModifier() && !actualkd.isPermanentModifier()) {
                if (source.equals(SOFTKEYBOARD)) {
                    return;
                }
                this.lastmodifiers.remove(shortnr);
            }
            this.setClicked(shortnr, false);
            Short modwithmapping = new Short(0);
            boolean i = false;
            Enumeration e = this.lastmodifiers.keys();
            while (e.hasMoreElements()) {
                this.hilfshort = (Short)e.nextElement();
                ModifierOptions actualmod = (ModifierOptions)this.lastmodifiers.get(this.hilfshort);
                if (actualmod.keydef.isPermanentModifier() || !actualmod.source.equals(SOFTKEYBOARD)) continue;
                this.setClicked(this.hilfshort, false);
                this.lastmodifiers.remove(this.hilfshort);
            }
            if (this.softkbd != null) {
                this.setSoftKbdModifier();
            }
        }
    }

    public void handleHardKbdEvent(Short keynr, int id) {
        switch (id) {
            case 401: {
                if (!this.hardkbd.contains(keynr)) {
                    this.hardkbd.addElement(keynr);
                    this.pressed(keynr, KEYBOARD);
                    break;
                }
                KeyDef actualkd = (KeyDef)this.keydefs.get(keynr);
                if (actualkd == null || actualkd.isModifier() || actualkd.isPermanentModifier()) break;
                this.pressed(keynr, KEYBOARD);
                break;
            }
            case 400: {
                if (this.hardkbd.contains(keynr)) break;
                this.pressed(keynr, KEYBOARD);
                this.released(keynr, KEYBOARD);
                break;
            }
            case 402: {
                int i = this.hardkbd.indexOf(keynr);
                if (i >= 0) {
                    this.hardkbd.removeElementAt(i);
                } else {
                    this.pressed(keynr, KEYBOARD);
                }
                this.released(keynr, KEYBOARD);
            }
        }
    }

    public void releaseAllKeys() {
        for (int i = 0; i < this.hardkbd.size(); ++i) {
            this.released((Short)this.hardkbd.elementAt(i), KEYBOARD);
        }
        this.hardkbd.removeAllElements();
        this.resetModifiers((byte)1);
    }

    private byte getKeyCode(Short shortnr, boolean clicked) {
        KeyDef kd = (KeyDef)this.keydefs.get(shortnr);
        return kd.getKeyCode(this.lastmodifiers, clicked, this.ctrl_counter);
    }

    private void setClicked(Short shortnr, boolean clicked) {
        byte keycode = this.getKeyCode(shortnr, clicked);
        if ((keycode & 0x7F) == 54 || (keycode & 0x7F) == 58) {
            this.ctrl_counter = clicked ? ++this.ctrl_counter : --this.ctrl_counter;
        }
        KeyboardEvent keyevt = new KeyboardEvent(keycode);
        this.fireKeyboardEvent(keyevt);
        if (this.softkbd != null) {
            this.softkbd.setClicked(shortnr, clicked);
        }
    }

    private void fireKeyboardEvent(KeyboardEvent keyevt) {
        for (int i = 0; i < this.keyboardlisteners.size(); ++i) {
            KeyboardListener listener = (KeyboardListener)this.keyboardlisteners.elementAt(i);
            listener.fired(keyevt);
        }
    }

    public KbdLayout getActualLayout() {
        return this.actuallayout;
    }

    public void resetAllModifiers() {
        this.resetModifiers((byte)1);
        this.resetModifiers((byte)3);
    }

    private void resetModifiers(byte ModType) {
        Enumeration e = this.lastmodifiers.keys();
        while (e.hasMoreElements()) {
            Short actualmod = (Short)e.nextElement();
            KeyDef actualkd = (KeyDef)this.keydefs.get(actualmod);
            if (actualkd.isPermanentModifier()) {
                if (ModType != 3) continue;
                this.setClicked(actualmod, true);
                this.setClicked(actualmod, false);
                this.lastmodifiers.remove(actualmod);
                continue;
            }
            if (ModType != 1) continue;
            this.setClicked(actualmod, false);
            this.lastmodifiers.remove(actualmod);
        }
        if (this.softkbd != null) {
            this.setSoftKbdModifier();
        }
    }

    private void setSoftKbdModifier() {
        boolean i = false;
        this.softkbd.changeModifier(KeyDef.SHORTNOP);
        if (!this.lastmodifiers.isEmpty()) {
            Enumeration e = this.lastmodifiers.keys();
            while (e.hasMoreElements()) {
                this.hilfshort = (Short)e.nextElement();
                if (!this.softkbd.hasMapping(this.hilfshort)) continue;
                this.softkbd.changeModifier(this.hilfshort);
            }
        }
    }

    public String getKeyString(Short key) {
        if (this.softkbd == null) {
            return null;
        }
        String ret = null;
        String _ret = this.softkbd.getKeyString(key, KeyDef.SHORTNOP);
        if (_ret != null) {
            ret = _ret;
        }
        if (!this.lastmodifiers.isEmpty()) {
            Enumeration e = this.lastmodifiers.keys();
            while (e.hasMoreElements()) {
                this.hilfshort = (Short)e.nextElement();
                if (!this.softkbd.hasMapping(this.hilfshort) || (_ret = this.softkbd.getKeyString(key, this.hilfshort)) == null) continue;
                ret = _ret;
            }
        }
        return ret;
    }

    public synchronized void addKeyboardListener(KeyboardListener l) {
        this.keyboardlisteners.addElement(l);
    }

    public synchronized void removeKeyboardListener(KeyboardListener l) {
        this.keyboardlisteners.removeElement(l);
    }
}

