//  Header file containing equates for MultiSounds DSP implementation
//
//  Copyright 1992  Turtle Beach Systems Inc.  All rights reserved



#define SRAM_BANK_SIZE	0x8000
#define SRAM_CNTL_START	0x7F00

#define DSP_BASE_ADDR	0x4000
#define DSP_BANK_BASE	0x4000

#define	HP_ICR		(0x00)			// host port / dsp registers
#define	HP_CVR		(0x01)
#define	HP_ISR		(0x02)
#define	HP_IVR		(0x03)
#define HP_NU     (0x04)
#define	HP_TXH		(0x05)
#define	HP_RXH		(0x05)
#define	HP_TXM		(0x06)
#define	HP_RXM		(0x06)
#define	HP_TXL		(0x07)
#define	HP_RXL		(0x07)

            // host port / hw control regs
#define	HP_MEMM		(0x08)			// memory map reg
#define	HP_IRQM		(0x09)			// irq map reg
#define	HP_DSPR		(0x0A)			// dsp reset
#define	HP_PROR		(0x0B)			// proteus reset
#define	HP_BLKS		(0x0C)			// block(bank) select
#define	HP_WAIT		(0x0D)			// extra wait state select
#define	HP_BITM		(0x0E)			// bit memory bus mode: 8/16

#define	HPR_BLRC	(0x08)			// read - board level R/C timer
#define	HPR_SPR1	(0x09)
#define	HPR_SPR2	(0x0A)
#define	HPR_TCL0	(0x0B)			//  "   - TOPCAT chip level lsb
#define	HPR_TCL1	(0x0C)
#define	HPR_TCL2	(0x0D)
#define	HPR_TCL3	(0x0E)
#define	HPR_TCL4	(0x0F)			//  "        "     "     "  msb


#define	HPICR_INIT	(0x80)
#define HPICR_HM1   (0x40)
#define HPICR_HM0   (0x20)
#define HPICR_HF1   (0x10)
#define HPICR_HF0   (0x08)
#define	HPICR_TREQ	(0x02)
#define	HPICR_RREQ	(0x01)

#define HPCVR_HC    (0x80)

#define	HPISR_HREQ	(0x80)
#define HPISR_DMA   (0x40)
#define HPISR_HF3   (0x10)
#define HPISR_HF2   (0x08)
#define	HPISR_TRDY	(0x04)
#define	HPISR_TXDE	(0x02)
#define	HPISR_RXDF	(0x01)

#define	HPIO_290	(0)			// host port i/o mapping choices
#define	HPIO_260	(1)
#define	HPIO_250	(2)
#define	HPIO_240	(3)
#define	HPIO_230	(4)
#define	HPIO_220	(5)
#define	HPIO_210	(6)
#define	HPIO_3E0	(7)

#define	HPMEM_NONE	(0)			// host port - shared memory map choices
#define	HPMEM_B000	(1)
#define	HPMEM_C800	(2)
#define	HPMEM_D000	(3)
#define	HPMEM_D400	(4)			// (no longer hw supported)
#define	HPMEM_D800	(5)
#define	HPMEM_E000	(6)
#define	HPMEM_E800	(7)

#define	HPIRQ_NONE	(0)			// host port - IRQ choices
#define HPIRQ_5     (1)
#define HPIRQ_7     (2)
#define HPIRQ_9     (3)
#define HPIRQ_10    (4)
#define HPIRQ_11    (5)
#define HPIRQ_12    (6)
#define HPIRQ_15    (7)

#define	HPDSPRESET_OFF	(0)			// DSP reset off/on
#define HPDSPRESET_ON   (1)

#define	HPPRORESET_OFF	(0)			// Proteus reset off/on
#define HPPRORESET_ON   (1)

#define HPBLKSEL_0      (0)     // 32k shared memory window block select
#define HPBLKSEL_1      (1)

#define HPWAITSTATE_0   (0)     // added memory wait state select
#define HPWAITSTATE_1   (1)

#define HPBITMODE_16    (0)     // memory bus bit mode select
#define HPBITMODE_8     (1)

// 	*************************************************
// 	*     Host<->DSP Interface Constants Defined	*
// 	*************************************************

//  Host int message types: (TXH @ Int time)

#define	HIMT_PLAY_DONE			0x00			//  digital audio play (complete)
#define	HIMT_RECORD_DONE		0x01			//  digital audio record (complete)
#define	HIMT_MIDI_EOS				0x02 			//  midi long output (complete)

#define	HIMT_MIDI_IN_BYTE		0x0E			//  midi input buff has data, pc go check
#define	HIMT_DSP						0x0F			//  dsp special tales - TXM has reason
						//  TXM values for HIMT_DSP
#define	HIDSP_INT_PLAY_UNDER		0x00	//  dsp internal play buffer underflow
#define	HIDSP_INT_RECORD_OVER		0x01	//  dsp internal rec. buffer overflow
#define	HIDSP_INPUT_CLIPPING		0x02	//  digital audio input data is clipping
#define	HIDSP_MIDI_IN_OVER			0x10	//  shared midi input buffer overflow
#define	HIDSP_MIDI_OVERRUN_ERR	0x13	//  midi data port over-run error


//  Host -> DSP exceptions (CVR)

#define	HDEX_BASE				0x92

#define	HDEX_PLAY_START			 		0 + HDEX_BASE
#define	HDEX_PLAY_STOP			 		1 + HDEX_BASE
#define	HDEX_PLAY_PAUSE			 		2 + HDEX_BASE
#define	HDEX_PLAY_RESUME		 		3 + HDEX_BASE
#define	HDEX_RECORD_START		 		4 + HDEX_BASE
#define	HDEX_RECORD_STOP		 		5 + HDEX_BASE
#define	HDEX_MIDI_IN_START		 	6 + HDEX_BASE
#define	HDEX_MIDI_IN_STOP		 		7 + HDEX_BASE
#define	HDEX_MIDI_OUT_START		 	8 + HDEX_BASE
#define	HDEX_MIDI_OUT_STOP		 	9 + HDEX_BASE
#define	HDEX_AUX_REQ					 10 + HDEX_BASE

// 	 Aux requests (TXL)

#define	HDEXAR_CLEAR_PEAKS		 		1
#define	HDEXAR_IN_SET_POTS		 		2
#define	HDEXAR_AUX_SET_POTS		 		3
#define	HDEXAR_CAL_A_TO_D		 			4
#define	HDEXAR_RD_EXT_DSP_BITS	  5


