/*
 *	@(#) pnt.h 7.1 94/12/19 SCOINC
 *
 *      Copyright (C) The Santa Cruz Operation, 1994.
 *      This Module contains Proprietary Information of
 *      The Santa Cruz Operation and should be treated
 *      as Confidential.
 */

#define PCI             0x1         /* PCI bus flag                    */
#define PLUG_PLAY       0x2         /* P&P bus flag                    */
#define LOCAL           0x3         /* local bus flag                  */
#define ISA             0x4         /* ISA bus flag                    */
#define PCI1            0x5         /* PCI type 2 bus flag             */
#define PCI2            0x6         /* PCI type 2 bus flag             */
#define BUS_MAX           8         /* number of buses to scan         */
#define DEVICE_MAX        32         /* number of devices to scan      */
#define ISA_IRQ_DEF       3         /* default IRQ for ISA             */
#define ISA_DMA_DEF       5         /* default DMA for ISA             */
#define FUNCTION_MAX      8         /* number of functions to scan     */
#define CONFIG_ADDRESS    0x0cf8    /* CONFIG_ADDRESS register         */
#define CONFIG_DATA       0x0cfc    /* CONFIG_DATA register            */
#define PRESIDIO          0x20001022     /* device id for Presidio  */  

/*************** bit mask for above registors */

/* CSR registers */

#define CSR0    0x0             /* CSR0 register */
#define CSR1    0x1             /* CSR1 register */
#define CSR2    0x2             /* CSR2 register */ 
#define CSR3    0x3             /* CSR3 register */
#define CSR4    0x4             /* CSR4 register  - PCNetISA */
#define CSR88   0x58            /* CSR88 register - PCNetISA */

/* TxRing flags */

#define MORE    0x1000          /* more than one retry to send frame */
#define ONE     0x0800          /* one retry needed to send frame */
#define DEF     0x0400          /* channel busy when transmitting */

/* TxRing Errors */

#define TBUF    0x8000          /* buffer Error */
#define UFLO    0x4000          /* FIFO underflow */
#define RES     0x2000          /* reserved bit */
#define LCOL    0x1000          /* late collision */
#define LCAR    0x0800          /* loss of carrier */
#define RTRY    0x0400          /* retry error */
#define TXERRS  0xFC00          /* mask for all Tx errors */

/* RxRing flags */

#define FRAM    0x2000          /* framing error */
#define OFLO    0x1000          /* FIFO overflow error */
#define CRC     0x0800          /* frame checksum error */
#define RBUF    0x0400          /* buffer error */

/* common to RxRing and TxRing flags */

#define OWN     0x8000          /* discriptor ownership bit */
#define DERR    0x4000          /* general error bit */
#define STP     0x0200          /* start of packet used for chaining */
#define ENP     0x0100          /* End of packet, used for chaining */

/* CSR0 bits */

#define INIT    0x0001          /* when set cause AM79X initialization */
#define STRT    0x0002          /* enables the AM79X to Rx and Tx */
#define STOP    0x0004          /* diables AM79X form all activity */
#define TDMD    0x0008          /* cause lance to access TxDRing w/o wait */
#define TXON    0x0010          /* indicates Transmitt is enabled */
#define RXON    0x0020          /* indicates Receive is enabled */
#define INEA    0x0048          /* interrupt enable/diable */
#define INTR    0x0080          /* interrupt flag, if INEA */
#define IDON    0x0100          /* initialization done flag */
#define TINT    0x0200          /* Tx interrupt received flag */
#define RINT    0x0400          /* Rx interrupt received flag */
#define MERR    0x0800          /* memory error -> bus master fail */
#define MISS    0x1000          /* missed packet, ownership error */
#define CERR    0x2000          /* collision error */
#define BABL    0x4000          /* trasmitter timeout error */
#define ERR     0x8000          /* Error of any (BABL, CERR, MISS, MERR) */
#define CLEAR   0xFF08          /* Value to clear status after an interrupt */
#define RUNNING 0x0033          /* Value to check that the chip is running */
#define IMASK   0x0300          /* PCNetISA Interrupt MASK */
#define PLMSK   0x1800          /* Polling & AutoPad Bit Mask */

/* CSR3 bits */

#define BCON    0x0001          /* byte control */
#define ACON    0x0002          /* ALE control */
#define BSWP    0x0004          /* byte swap flag */

/* Register Addrees/Data ports */

#define RDP(x)       (x + 0x10)  /* Register data port */
#define RAP(x)       (x + 0x12)  /* Register address port */
#define RRP(x)       (x + 0x14)  /* Reset Register */
#define BDP(x)       (x + 0x16)  /* Register address port */

#define HL_RDP(x)       (x + 0x10)  /* Register data port */
#define HL_RAP(x)       (x + 0x14)  /* Register address port */
#define HL_RRP(x)       (x + 0x18)  /* Reset Register */
#define HL_BDP(x)       (x + 0x1c)  /* Register Config port*/

/* MISC */
/* Multicast address */
#define ISMULTICAST(ea) (((caddr_t)(ea))[0] & 1)

/* Broadcast address */
#define ISBROADCAST(ea) ((((caddr_t)(ea))[0] & 0xff) == 0xff && \
                         mdi_addrs_equal(pnt_broad, ea))


#define LanShark_ID     0x0943      /* LanShark ID, change later       */
#define HiLance_ID      0x0243      /* Hilance ID                      */
#define PCNetISA_ID     0x0003      /* PCNetISA ID                     */
#define PART_NO_MASK    0x0003      /* PCNetISA ID MASK                */
#define LANSHARK        0x1         /* LANSHARK dev ID  (offset 09)    */    
#define HILANCE         0x10        /* HILANCE   int dev ID (offset 09)*/    
#define PCNetISA        0x1         /* PCNetISA flag                   */
#define LANCE           0x0         /* LANCE present FLAG              */
#define BUFEXP          0x2000      /* exponent of Buffer size         */
#define RXBUFEXP        0x0020      /* exponent of Rx Buffer size      */
#define CASCADE         0xC0        /* cascade mode value for 8237 DMA */
#define ROT_PRIORITY    0x10        /* rotating priority mode          */
#define DMA_1_MODE_REGS 0x0B        /* 8237 DMA chip #1 mode register  */
#define DMA_1_MASK_REGS 0x0A        /* 8237 DMA chip #1 mask register  */
#define DMA_1_CMND_REGS 0x08        /* 8237 DMA chip #1 command regs.  */
#define DMA_2_MODE_REGS 0xD6        /* 8237 DMA chip #2 mode register  */
#define DMA_2_MASK_REGS 0xD4        /* 8237 DMA chip #2 mode register  */
#define DMA_2_CMND_REGS 0xD0        /* 8237 DMA chip #2 command regs.  */

#define MAX_D_SIZE    128
#define DEVICE_FAULT 0
#define SUCCESS      1
#define DOWN         0
#define NOT_OK       1
#define OK           0

#define STREAMS_MIN_PKT_SIZE   60
#define STREAMS_MAX_PKT_SIZE   1500

#define PNT_ETH_MINPACK         60      /* min with ethernet header */
#define PNT_ETH_MAXPACK         1514    /* max with ethernet header */

#define MAX_TX_BUF_SIZE 1514
#define MAX_RX_BUF_SIZE 1518

#define MAX_802_SIZE   1500
#define MIN_802_SIZE   60
#define ETHER_HDR 14

#define pntMTU 1500
#define NORMAL 0

#define DEAD 0
#define PRESENT 1
#define INITIALIZED 2
#define FAIL 0

/**************************** My Local Defines */

#define ON 1 
#define OFF 0
#define TRUE 1
#define FALSE 0
#define Intl_b(X)  ((((X) & 0x00FF) << 8) | (((X) & 0xFF00) >> 8))
#define Hi_WORD(X) (((unsigned short *)&X)[1])
#define Lo_WORD(X) (((unsigned short *)&X)[0])
#define PHYaddr(X) (ktop((paddr_t)(X)))  /* Physical address conversion */


#define MAX_MCAST 6

                      /* Anchorage stuff starts */
/*      At time of testing, the value of HI_LANCE_BASE was as defined
        below. It may not be the final address chosen. */

#define HI_LANCE_BASE   0x8800          /* Anchorage HiLance I/O base. */
#define CPQ_ANCH_BID    0x0107110e      /* Anchorage EISA board id. */

/*      The following board id structure is provided for convenience and is
        not a necessary part of this method. */

#pragma pack(1)

typedef struct
   {
   u_char zc80;
   u_char zc81;
   u_char zc82;
   u_char zc83;
   } BID_PORTS;         /* Compressed EISA board id port reference. */

typedef union
   {
   BID_PORTS port;      /* Individual ports. */
   ulong whole;         /* Compressed EISA board id as a long integer. */ 
   } BID;               /* EISA board id reference. */

#pragma pack()

                      /* Anchorage stuff ends */

/* Ethernet frame */
typedef struct  {
        macaddr_t       eh_daddr;       /* 48-bit destination address */
        macaddr_t       eh_saddr;       /* 48-bit source address */
        unsigned short  eh_type;        /* 16-bit type field */
} e_frame_t;

typedef struct {
   unsigned char d_addr[6];         /* source service access point */
   unsigned char s_addr[6];         /* destination service point */
   unsigned short e_type;           /* 1 or 2 bytes of control info */
} ether_type;

typedef struct {
   unsigned char mc_addr[6];       /* 48-bit multicast address */
} mcast_type;

typedef struct {
   unsigned char dsap;
   unsigned char ssap;
   unsigned char control[2];
} llc_type;

/* device structure as seen by Streams (minor_dev related parameters) */

struct DevState
{
        queue_t *       rq;     /* read queue for device */
        long            type;   /* type of packet bound to stream */
} ;

struct qid 
{
        int board;
        int dev;
        int type;
} pnt_qidpool[4][16];
                     /* Receive and transmit blocks tables */
struct RRABlock
{
mblk_t *   dp;
long  phys;
};

struct TDABlock
{
mblk_t *   dp;
mblk_t *   dp1;
  char * virt;                   /* virt address for the alignment storage */
  short ladr;                    /* low 16 bits of address */
  short hadr;                    /* high 8 bits */
};

/* 
 *  device initialization block structure
 */

struct am79X_initBlock 
{
   short mode;                   /* mode register */
   unsigned char padr[6];        /* physical address, 6 bytes */
   unsigned char ladr[8];        /* logical address filter, 8 bytes */
   short RxRingLo;               /* rx ring pointer upper 16 bit*/
   short RxRingHi;               /* rx ring pointer lower 16 bit*/
   short TxRingLo;               /* tx ring pointer upper 16 bit*/
   short TxRingHi;               /* tx ring pointer lower 16 bit*/
};

struct HiLance_initBlock 
{
   short mode;                   /* mode register */
   short len;
   unsigned char padr[6];        /* physical address, 6 bytes */
   short unused;
   unsigned char ladr[8];        /* logical address filter, 8 bytes */
   long RxRing;                  /* rx ring pointer */
   long TxRing;                  /* tx ring pointer */
};

/*
 *  transmit ring descriptor structure 
 */

struct am79X_TMDR 
{
  short ladr;                    /* low 16 bits of address */
  short hadr;                    /* high 8 bits + handshake/flags */
  short bcnt;                    /* buffer byte count */
  short errs;                    /* TDR + error bits */
};

struct HiLance_TMDR 
{
  long adr;                    /* 32 bits of address */
  short bcnt;                    /* buffer byte count */
  short flags;                    /* unused 8 bits + handshake/flags */
  short tx_retry;                 /* unused 12 bits + tx retry counter */
  short errs;                    /* TDR + error bits */
  long  unused;                  /* reserved locations */
};

struct am79X_RMDR 
{
  short ladr;                    /* low 16 bits of address */
  short hadr;                    /* high 8 bits + handshake/flags */
  short bcnt;                    /* buffer byte count */
  short mcnt;                    /* message byte count */
};

struct HiLance_RMDR 
{
  long adr;                    /* 32 bits of address */
  short bcnt;                    /* buffer byte count */
  short flags;                    /* unused 8 bits + handshake/flags */
  short mcnt;                    /* message byte count */
  short rx_stat;                 /* rx coll and runt packets counts */
  long  unused;                  /* reserved locations */
};

/* DOD statistics structure */

struct enetstat {
   unsigned int en_ipkt;
   unsigned int en_opkt;
   unsigned int en_coll;
   unsigned int en_fcs;
   unsigned int en_align;
   unsigned int en_length;
   unsigned int en_carrier;
};

/* local statistics structure */

struct localstat {
   unsigned int cerr;            /* collision error */
   unsigned int miss;            /* missed packet */
   unsigned int oflo;            /* overflow error */
   unsigned int rxbuf;           /* receive buffer error */
   unsigned int txbuf;           /* trasmit buffer error */
   unsigned int uflo;            /* underflow error */
   unsigned int lcol;            /* late collision */
   unsigned int col1;            /* */
   unsigned int colm;            /* */
   unsigned int rjct;
   unsigned int ono;
};


/* AM79XXX physical device structure as seen by OS */

static struct pnt_DeviceStruct {
   short index;                     /* board index */
   short minors;                    /* max minor devices allowed */
   short major;                     /* major device # */
   short iobase;                    /* I/O base address */
   short vec;                       /* interrupt vector # */
   short dma;                       /* DMA channel */
   short tx_buffers;                   /* Ring size for Transmit */
   short rx_buffers;                   /* Ring size for Receive */
   long  led0;                      /* LED value */
   long  led1;                      /* LED value */
   long  led2;                      /* LED value */
   long  led3;                      /* LED value */
   long  dmarotate;                 
   long  tp;                 
   long  fdup;                 
   short status;                    /* PRESENT/DEAD/DEVICE_FAULT/INITALIZED
   short mode;                      /* PROMISCUOUS/NOT! */
   short type;                      /* PCNetISA or ..... */
   int open;                        /* open flag */
   short  present;                  /* board present */
   int mdi_bound;                        /* bound flag */
   time_t lbolt;                    /* keep the up-time since driver boot */
   long diag;                      /* diag level for this board */
   long flags;                       /* flag */
   unsigned char opadr[6];          /* Orignal physical address */
   unsigned char npadr[6];          /* New physical address */
   struct RRABlock RRABlock[32];    /* RRA blocks pool */
   struct TDABlock TDABlock[32];    /* TDA blocks pool */
   struct localstat lstat;          /* local device statistics */
   struct enetstat dodstat;         /* DOD statistics */
   mac_stats_eth_t macstat;    /* MAC statistics */
   mctbl_t         mc;           /* multicast table */
   queue_t *           up_queue;       /* upstream queue */
   struct am79X_initBlock InitBlock; /* Initialization block */
   struct HiLance_initBlock HL_InitBlock; /* Initialization block */
   struct am79X_TMDR *TxRingPtr;    /* pointer to Transmit Descriptor Ring */
   struct am79X_RMDR *RxRingPtr;    /* pointer to Receive Descriptor Ring */
   struct HiLance_TMDR *HL_TxRingPtr; /* pointer to Transmit Descriptor Ring */
   struct HiLance_RMDR *HL_RxRingPtr; /* pointer to Receive Descriptor Ring */
   struct DevState DevState[16];    /* Minor device structures */
   short RxNext;                    /* Next Receive Ring  */
   short TxNext;                    /* Next Transmit Ring */
   short TxRet1;                    /* Number of retries for the current Tx */
   short TxRet2;                    /* Number of CSL in a row */
   short TxRet3;                    /* Number of retries in a row */
   short TxMsg;                     /* "Cable disconnect" message flag */
   char *TxBufPtr;                  /* pointer to Transmit Buffer */
   char *RxBufPtr;                  /* pointer to Receive Buffer */ 
   int     MissFlag;                /* packet "missed" flag */
   int     TxFlag;                  /* " Transmit in progress" flag */
   int     ResetFlag;                /* "Reset in progress" flag */
   long pci_bus;                    /* bus, device and function found */
   long pci_dev;
   long pci_func;
   struct pci_devinfo infptr;       /* pci info structure */
   long access_type;                /* access type */
   long access_value;                /* access value */
   long stop_set;                   /* power management interrupt flag */
   long board_found;              /* flag to indicate that AMD board is found */
   long chip_type ;                 /* AMD chip type */
   long mode_32   ;                 /* 0 - 16 bit mode, 1- 32 bit mode */
   long bustimer;                /* DMA bus access timer */
};


/*
 *  Stucture used in space.c to pass configuration to driver. This information
 *  is copied to the pnt_DeviceStruct structure.
 */

struct pnt_ConfigStruct {
   short index;                     /* board index */
   short minors;                    /* minor devices configured */
   short vec;                       /* interrupt vector # */
   short iobase;                    /* boards base memory address */
   short ioend;                     /* Ending base I/O address */
   short dma;                       /* DMA channel used by the board */
   short tx_buffers;                   /* Buffer size for Transmit */
   short rx_buffers;                   /* Buffer size for Receive */
   long  led0;                      /* LED value */
   long  led1;                      /* LED value */
   long  led2;                      /* LED value */
   long  led3;                      /* LED value */
   long  dmarotate;                 
   long  tp;                 
   long  fdup;                 
   long pci_bus;                    /* bus, device and function found */
   long pci_dev;
   long pci_func;
   long access_type;                /* access type */
   long bustimer;                /* DMA bus access timer */
};

/*
 * Global Variables:
 */
extern macaddr_t        pnt_broad;
