100 REM FILE: MM74C922.BAS,    WRITTEN IN QBASIC
102 REM
110 REM Inputs 4 bit data from National's MM74C922 matrix key pad encoder
120 REM via standard Centronics Parallel Printer Port. Output from the
130 REM '922 is read into the parallel port's ( Base Address + 1 ).  D6
140 REM of the (Base Address + 1), ACK, is used to input the '922 strobe
150 REM signal.  When D6 goes to an active HIGH, the new byte value is
160 REM displayed on the screen.
162 REM
164 REM Since data is comming in on printer port data bits D3, D4, D5, and D7,
166 REM data is reformated to output numbers between 0 and 15
168
180 INPUTBITS = 0: LptPortAddress = 0
190 LptPortAddress = 888: REM  base address of Graphic Card's printer port
200 REM                        use 632 for 3ed printer port base address
210 REM                        and 956 for Monochrome Card's printer port
220 CLS
230 LOCATE 10, 1: PRINT "Inputs = ";
240 REM
245 D6 = 64
260   INPUTBITS = INP(LptPortAddress + 1)
270   IF (INPUTBITS AND D6) <> 64 THEN 330
290   LOCATE 10, 10
292   INPUTBITS = INPUTBITS XOR 128: REM 10000000 invert the inverted bit
294   IF (INPUTBITS AND 128) <> 128 THEN GOTO 297:  REM format for 0-15 out
296       INPUTBITS = ((INPUTBITS - 128) * 2) + 128: GOTO 298
297       INPUTBITS = INPUTBITS * 2
298   INPUTBITS = INPUTBITS \ 16
300   PRINT INPUTBITS; : PRINT "   ";
310   IF (INP(LptPortAddress + 1) AND D6) = 64 THEN GOTO 310
320   LOCATE 10, 10: PRINT "      ";
330   IF INKEY$ = "" THEN GOTO 260: REM   press any key to exit
340 END

