100 REM PROGRAM OPTO_IN.BAS
110 REM
120 REM Input 8-bit opto-coupled data via a parallel printer port.
130 REM Output 4 opto-coupled control bits.
140 REM
150 REM written in QBASIC
160 REM
180 LptPortAddress = 888: REM   equals CGA card's printer port address
190 REM                         use 956 for MGA card's printer port address
200 REM                         use 632 for 3rd priinter port address
210 REM
220 OUT (LptPortAddress + 2), 4:  REM set all low nibble output bits high so
230 REM                         open collector inputs can be read
240 REM  -=[ read in data ]=-
250 LowNibble = INP(LptPortAddress + 2):  REM base + 2 address, bits D0 - D3
260 HighNibble = INP(LptPortAddress + 1): REM base + 1 address, bits D4 - D7
270 REM  -=[  process data ]=-
280 LowNibble = (LowNibble AND &HF): REM    00001111
290 LowNibble = (LowNibble XOR &HB): REM    00001011, reinvert inverted bits
300 HighNibble = (HighNibble AND &HF0): REM 11110000
310 HighNibble = (HighNibble XOR 128): REM  10000000, reinvert inverted bits
320 DataBit = (HighNibble OR LowNibble): REM  combine for output
330 REM -=[ display results ]=-
340 PRINT HighNibble, LowNibble, DataBit
350 IF INKEY$ = "" THEN GOTO 210 ELSE Ch$ = INKEY$
355 REM
360 REM -=[ send control bits, printer port's base address, bits D0 - D3 ]=-
370 REM
375 PowerOfTwo = 1
380 REM   
390 OUT LptPortAddress, PowerOfTwo
400 PRINT PowerOfTwo,
410 PowerOfTwo = PowerOfTwo * 2
420 IF INKEY$ <> "" THEN STOP
430 SLEEP (1)
440 IF PowerOfTwo > 8 THEN PRINT  ELSE GOTO 380
450 IF INKEY$ <> "" THEN STOP ELSE GOTO 375
460 END

