
100 REM SPEECH.BAS;    WRITTEN IN QBASIC
110 REM
120 REM  Produce speech using General Instrument's SPO256 Speech Processor.
130 REM  The chip has 64 address locations each identifying instructions for
140 REM  sounding an allophone.  The chip's output should be fed to an audio
150 REM  amplifier.
170 REM
180 REM Allophone information based on General Instruments' Data Sheets,
190 REM and Radio Shack Data sheet packaged with item 276-1784.
200 REM
210 REM
220 AA$ = CHR$(24): REM   
230 AE$ = CHR$(26): REM   a
240 AO$ = CHR$(23): REM   
250 AR$ = CHR$(59): REM   r
260 AW$ = CHR$(32): REM   ou
270 AX$ = CHR$(15): REM   u
280 AY$ = CHR$(6):   REM  
290 BB1$ = CHR$(28): REM  b   final position
300 REM                   b   between vowels, or in clusters
310 BB2$ = CHR$(63): REM  b   initial position before a vowel
320 CH$ = CHR$(50): REM   ch
330 DD1$ = CHR$(21): REM  d    final position
340 DD2$ = CHR$(33): REM  d    initial positin
350 DH1$ = CHR$(18): REM  th   word's initial position
360 DH2$ = CHR$(54): REM  th   word's final position
370 REM                   th   between vowels
380 EH$ = CHR$(7):   REM  e
390 EL$ = CHR$(62): REM   l
400 ER1$ = CHR$(51): REM  ar
410 ER2$ = CHR$(52): REM  ur
420 EY$ = CHR$(20): REM   
430 FF$ = CHR$(40): REM       silent, use singly in final position
440 GG1$ = CHR$(36): REM  g    before high front vowels: ir, , i, , e, er
450 GG2$ = CHR$(61): REM  g    before high back vowels: , oo, , oi, u
460 REM                   g    before clusters
470 GG3$ = CHR$(34): REM  g    before low vowels: a, ou, , r, , , r, ar, ur
480 REM                        medical clusters
490 REM                   g    final position
500 HH1$ = CHR$(27): REM  h    before front vowels: ir, , i, , e, er, a
510 HH2$ = CHR$(57): REM  h    before back vowels: , oo, , oi, , r, r
520 IH$ = CHR$(12): REM   i
530 IY$ = CHR$(19): REM   
540 JH$ = CHR$(10): REM   j
550 KK1$ = CHR$(42): REM  k    before front vowels
560 REM                          ir, , i, , e, er, , a, ar, ur, u
570 REM                   k    initial clusters
580 KK2$ = CHR$(41): REM  k    final position
590 KK3$ = CHR$(8):  REM  k    before back vowel:, oo, , oi, r, r, 
600 LL$ = CHR$(45): REM   L
610 MM$ = CHR$(16): REM   m
620 NG$ = CHR$(44): REM   ng
630 NN1$ = CHR$(11): REM  n    before front and central vowels:
640 REM                         ir, , i, , e, er, a, ar, ur, u, ou, , 
650 REM                   n    final clusters
660 NN2$ = CHR$(56): REM  n    before back vowels: oo, , oi, r, r, 
670 ORR$ = CHR$(58): REM  r
680 OW$ = CHR$(53): REM   
690 OY$ = CHR$(5):   REM  oi
700 PP1$ = CHR$(9):  REM  P
710 RR1$ = CHR$(14): REM  R    initial position = beginning of word
720 RR2$ = CHR$(39): REM  r    initial cluster
730 SH$ = CHR$(37): REM   sh
740 SS$ = CHR$(55): REM   silent
750 TH$ = CHR$(29): REM   silent
760 TT1$ = CHR$(17): REM  t     final cluster before SS
770 TT2$ = CHR$(13): REM  t     all other positions
780 UH$ = CHR$(30): REM   oo
790 UW1$ = CHR$(22): REM      after y
800 UW2$ = CHR$(31): REM      in one syllable words
810 VV$ = CHR$(35): REM   V
820 WH$ = CHR$(48): REM   hW
830 WW$ = CHR$(46): REM   W
840 XR$ = CHR$(47): REM   er
850 YR$ = CHR$(60): REM   ir
860 YY1$ = CHR$(49): REM  y     clusters
870 YY2$ = CHR$(25): REM  Y     initial position
880 ZH$ = CHR$(38): REM   Zh
890 ZZ$ = CHR$(43): REM   z
900 REM
910 PA1$ = CHR$(0): REM pause 10 ms, before BB, DD, GG, and JH
920 PA2$ = CHR$(1): REM pause 30 ms, before BB, DD, GG, and JH
930 PA3$ = CHR$(2): REM pause 50 ms, before PP, TT, KK, and CH, and between words
940 PA4$ = CHR$(3): REM pause 100 ms, between clauses and sentences
950 PA5$ = CHR$(4): REM pause 200 ms, between clauses and sentences
960 REM
961 REM -=[ define words by allophone sounds ]=-
962 REM
964 Computer$ = KK1$ + AX$ + PA1$ + MM$ + PP1$ + YY1$ + UW1$ + TT2$ + ER1$ + PA3$
966 Talking$ = TT2$ + AO$ + AO$ + PA3$ + KK1$ + IH4$ + NG$ + PA3$
968 Hello$ = HH1$ + EH$ + LL$ + AX$ + OW$ + PA5$
969 REM
970 REM -=[ transmit speech allophones via LPT1 ]=-
972 phrase$ = Computer$: GOSUB 1500
974 phrase$ = Talking$: GOSUB 1500
976 SLEEP (1)
978 phrase$ = Hello$: GOSUB 1500
980 REM
982 REM alternete method of sending speech allophones to LPT1, LPT2, or LPT3
984 REM Select_Printer_Port(Lpt_Num, Lpt_Port_Address
986 phrase$ = Computer$: GOSUB 2000
988 phrase$ = Talking$: GOSUB 2000
990 SLEEP (1)
992 phrase$ = Hello$: GOSUB 2000
993 STOP: REM end main
996 REM
1500 REM  -=[ subroutine, Speak ]=-
1510 REM
1520 REM  Transmit each allophone byte of phrase to SPO256.
1530 REM  Procedure will only transmit to LPT1.
1540 REM
1550 REM
1580 FOR N% = 1 TO LEN(phrase$)
1590 TEMP = ASC(MID$(phrase$, N%, 1))
1595 LPRINT CHR$(TEMP);
1600 NEXT N%
1610 RETURN
1620 REM end speak
1630 REM
2000 REM -=[ subroutine, SAY ]=-
2010 REM
2020 REM   Transmit each allophone byte of phrase to SPO256.
2030 REM   Will transmit to LPT1, LPT2, or LPT3.
2040 REM
2050 CONST D7% = 128
2065 LptPortAddress& = 888: REM CGA card printer port address
2066 REM                       use 956 for MGA card printer port address
2067 REM                       use 632 for 3rd printer port address
2070 REM
2080 FOR N% = 1 TO LEN(phrase$)
2090 REM  Check speech chip's standby line, LRQ, ( D7, at pin 10 on printer port
2100 REM  When LRQ is logic high, chip can accept new data.
2110 REM       ok to transmit?
2115 IF (INP(LptPortAddress& + 1) AND D7) <> D7 THEN GOTO 2115
2120 REM All four control lines, at LPT Port Address + 2, are set to inactive
2130 REM logic levels by sending 10, binary 00001010.
2140 REM Remember, Storbe line is inverted. High is 0, Low is 1.
2150 OUT (LptPortAddress& + 2), 10
2160 OUT LptPortAddress&, ASC(MID$(phrase$, N%, 1))
2170 OUT (LptPortAddress& + 2), 11
2180 OUT (LptPortAddress& + 2), 10
2185 NEXT N%
2190 RETURN
2200 REM  end say

