   /*                 PROGRAM Optos
		   Code conversion by Eugene Klein
      Repeatedly turn each opto-coupler in FIGURE OPTOS high and low
      until any key is pressed
   */

#include <dos.h>
#include <stdio.h>
#include <conio.h>
#include <stdlib.h>
#include <string.h>
#include <bios.h>
#include "My_TPU.h"



const int D0_High = 1;  // photo-transistor opto-coupler
const int D0_Low  = 0;
const int D1_High = 2;  // SCR opto-coupler
const int D1_Low  = 0;
const int D3_High = 8;  // triac opto-coupler
const int D3_Low  = 0;
const int D5_High = 32;  // SSR, solid state relay
const int D5_Low  = 0;
const int Time = 500;
int E;

void Transmit_Data(unsigned char High_Bit_Value,unsigned char Low_Bit_Value)

/* Send data out LPT1, parallel printer port.
   Sequence:
    set bit to active high
    delay
    set bit ti active low
    delay
*/
{
 putc(High_Bit_Value,stdprn);
 delay(Time);
 putc(Low_Bit_Value,stdprn);
 delay(Time);
}

void main()
{
 do
 {
  Transmit_Data(D0_High, D0_Low);  //{ photo-transistor opto-coupler
  Transmit_Data(D1_High, D1_Low);  //{ SCR opto-coupler
  Transmit_Data(D3_High, D3_Low);  //{ triac opto-coupler
  Transmit_Data(D5_High, D5_Low);  //{ SSR opto-coupler
 }while(!kbhit());
}
