 /*                       PROGRAM SPO256
		   Code conversion by Eugene Klein
 Produce speech using General Instrument's SPO256 Speech Processor.  The
 chip uses 64 addresses, each stored with an allophone.  The chip's output
 can be fed directly to an amplifier.
 */


#include <dos.h>
#include <stdio.h>
#include <conio.h>
#include <stdlib.h>
#include <string.h>
#include <bios.h>
#include "My_TPU.h"

void main()                //SPO256
{

 const int PA1 = 0,  PA2 = 1,  PA3 = 2,  PA4 = 3, PA5 = 4,  OY = 5,   AY = 6,
      EH = 7,   KK3 = 8,  PP = 9, JH = 10,   NN1 = 11, IH = 12,  TT2 = 13,
      RR1 = 14, AX = 15,  MM = 16, TT1 = 17, DH1 = 18, IY = 19,  EY =  20,
      DD1 = 21, UW1= 22,  AO = 23, AA  = 24, YY2 = 25, AE = 26,  HH1 = 27,
      BB1 = 28, TH = 29,  UH = 30, UW2 = 31, AW =  32, DD2 = 33, GG3 = 34,
      VV =  35, GG1 = 36, SH = 37, ZH = 38, RR2 = 39, FF = 40,  KK2 = 41,
      KK1 = 42, ZZ = 43,  NG = 44, LL = 45,  WW  = 46, XR = 47,  WH =  48,
      YY1 = 49, CH = 50,  ER1 = 51, ER2 =52,  OW = 53,  DH2 = 54, SS =  55,
      NN2 = 56, HH2 = 57, ORR = 58, AR = 59,  YR = 60,  GG2 = 61, EL =  62,
      BB2 = 63;

// write to speech chip, "hello, time equals six forty two.
fprintf(stdprn,"%i %i %i %i %i %i", HH1,EH,LL,AX,OW,PA5);              // hello
fprintf(stdprn,"%i %i %i %i",TT2,AA,AY,MM);                     // time
fprintf(stdprn,"%i %i %i %i %i %i %i %i",IH,PA2,PA3,KK3,WH,AX,EL,ZZ);       // equals
fprintf(stdprn,"%i %i %i %i %i %i %i",SS,SS,IH,IH,PA3,KK2,SS);           // six
fprintf(stdprn,"%i %i %i %i %i",FF,ORR,PA3,TT2,IY);                // forty
fprintf(stdprn,"%i %i",TT2,UW2);                          // two
// " date equals Monday, August twenty three "
fprintf(stdprn,"%i %i %i %i",DD2,EY,PA3,TT2);                   // date
fprintf(stdprn,"%i %i %i %i %i %i %i %i",IH,PA2,PA3,KK3,WH,AX,EL,ZZ);       // equals
fprintf(stdprn,"%i %i %i %i %i %i %i",MM, AX, AX, NN1,PA2,DD2,EY);       // monday
fprintf(stdprn,"%i %i %i %i %i %i %i %i",AO,AO,PA2,GG2,AX,SS,PA3,TT1);      // August
fprintf(stdprn,"%i %i %i %i %i %i %i %i",TT2,WH, EH, NN1, PA2,PA3,TT2,IY);  // twenty
fprintf(stdprn,"%i %i %i",TH,RR1,IY );                       // three
}
