/*                    PROGRAM TSR_DEMO  
		 Code conversion by Eugene Klein & Michael Mensch

  This program is a DEMO TSR HARDWARE INTERRUPT.
  The Parallel Prnter Port's ACK line, pin 10, can be used
  as a hardware interrupt. The interrupt is activated when
  The ACK line, pin 10, is pulled HIGH, form an inactive LOW.

  Ref 1: "MICRO CORNUCOPIA,#38,Nov-Dec 1987"
      2: "BYTE;Vol 10,Num 11, 'Inside the IBM PC's'"
      3: "Mastering Turbo Pascal 4.0,second edition, Tom Swan"
      4: "Programmer's Guide to the IBM PC, Peter Norton"
   The first working copy was finished at 2 pm, on Sept. 3, 1988
   thanks to the aid of my good friend, Michael Mensch.
*/

#include <dos.h>
#include <stdio.h>

void interrupt ( *oldhandler)(void);
int k, B, imask;
unsigned int LPTx;
int x,y;
typedef char screen_t[25][80][2];
screen_t far *screen;
screen_t sav_screen;

void save_screen(screen_t t_screen)
{
   int i,j,k;
   for (i=0;i<25;i++)
     for (j=0;j<80;j++)
       for (k=0;k<2;k++)
	  t_screen[i][j][k] = (*screen)[i][j][k];
}

void restore_screen(screen_t t_screen)
{
   int i,j,k;
   for (i=0;i<25;i++)
     for (j=0;j<80;j++)
       for (k=0;k<2;k++)
	   (*screen)[i][j][k] = t_screen[i][j][k];
}

void dputch(int x,int y,int ch,char attrib)
{
   (*screen)[y][x][0] = (char) ch;
   (*screen)[y][x][1] = attrib;
}

void writeln(unsigned char s_line[80])
{
  for (k=0;k<80;k++)
  {
    dputch(k,y,s_line[k],0x79);
  }
  y++;
}

void clrsss(void)
{
   int i,j,k;
   for (i=0;i<25;i++)
     for (j=0;j<80;j++)
       for (k=0;k<2;k++)
	   dputch(j,i,0x20,0x79);
}

void interrupt TSR_Code(void)
/*
  this is the section that remains resident in memory waiting to be called
  into action when the ACKnowledge pin is brought from a LOW, to HIGH,
  logic level.
*/
{
 save_screen(sav_screen);
 clrsss();
 y=0;
 writeln("     ͻ             ");
 writeln("       1     TSR ON       TSR ON       TSR ON       TSR ON                    ");
 writeln("       2                                                                      ");
 writeln("       3 TSR ON      TSR ON      TSR ON       TSR ON                          ");
 writeln("       4                                                                      ");
 writeln("       5     TSR ON       TSR ON       TSR ON       TSR ON                    ");
 writeln("       6                                                                      ");
 writeln("       7 TSR ON      TSR ON      TSR ON       TSR ON                          ");
 writeln("       8                                                                      ");
 writeln("       9     TSR ON       TSR ON       TSR ON       TSR ON                    ");
 writeln("      10                                                                      ");
 writeln("      11 TSR ON      TSR ON      TSR ON       TSR ON                          ");
 writeln("      12                                                                      ");
 writeln("      13     TSR ON       TSR ON       TSR ON       TSR ON                    ");
 writeln("      14                                                                      ");
 writeln("      15 TSR ON      TSR ON      TSR ON       TSR ON                          ");
 writeln("      16                                                                      ");
 writeln("      17     TSR ON       TSR ON       TSR ON       TSR ON                    ");
 writeln("      18                                                                      ");
 writeln("      19 TSR ON      TSR ON      TSR ON       TSR ON                          ");
 writeln("      20                                                                      ");
 writeln("     ͼ             ");
 k=0xff;
 while((k & 0x40) != 0)      //              ___
 {
   k = inport(LPTx + 1);     // Repeat until ACK line is high again
 };
 restore_screen(sav_screen);
 outport(0x0020,0x20);          //Nonspecific End Of Interrupt to               }
}

void main()
{
 LPTx = 888;
 screen = MK_FP(0xB800,0);
 oldhandler = getvect(0x0f);
 setvect(0x0f, TSR_Code);    // set interrupt vector 15 to TSR_code
 B = inport(LPTx + 2);
 if((B & 16) == 0)
  B = B + 16;
 outport(LPTx + 2,B);       // To enable the interrupt on the printer card   }
 imask = inport(33) && 127;
 outport(33,imask);         // To enable the interrupt in the  8259 PIC      }
 printf("\n -=[ INTERRUPT INSTALLED ]=- , Paul Bergsman, [215] 667-2449 \n");
 keep(0, (_SS + (_SP/16) - _psp));                 // install TSR                                   }
}
