
PROGRAM Adc_0809;
{
  Operate a multiplexed eight chanel A/D converter from a standard
  Centronic Parallel Printer Port.
}

USES CRT, DOS, My_Tpu;

CONST
  { input lines, BASE + 2 }
   D0 = 1;    { STROBE line line, base + 2, pin 1 on Cen. Par. Con. = D0   }
   D1 = 2;    { AUTO-FEED line, base + 2, pin 14 on Cen. Par. Con. = D1    }
   D2 = 4;    { INITIALIZE line, base + 2, pin 31 on Cen. Par. Con. = D2   }
   D3 = 8;    { SELECT-INPUT line, base + 2, pin 36 on Cen. Par. Con. = D3 }
  { input lines, BASE + 1 }
   D4 = 16;   { SELECT line, base + 1, pin 13, on Cen. Par. Con. = D4      }
   D5 = 32;   { PAPER-END line, base + 1, pin 12 on Cen. Par. Con. = D5    }
   D6 = 64;   { ACK line, base + 1, pin 10 on Cen. Par. Con. = D6          }
   D7 = 64;   { BUSY line, base + 1, pin 11 on Cen. Par. Con. = D7         }

   OE = 32;   { D5, base address,  pin 7 on Cen. Par. Connector            }
{ NOTE: pin numbers are for 36 pin Centronics Parallel Connector           }
   Max_Channels = 7; { max number of channels used on ADC-0809             }

VAR                         E : INTEGER;
                           Ch : CHAR;
    Lpt_Num, Lpt_Port_Address : WORD;
                         Data : BYTE;
                         Regs : REGISTERS;

PROCEDURE Start_Conversion(E : INTEGER; Lpt_Port_Address : WORD);
                     { pulse Start Conversion line, of selected channel E,  }
CONST Strobe = 8;    { data bit D3 is used to send 'start conversion' pulse }
VAR Pulse : BYTE;
  BEGIN { start }
  If E > Max_Channels THEN E := 0;
  Pulse := E OR Strobe;
  Port[Lpt_Port_Address] := E;     { select channel         }
  Port[Lpt_Port_Address] := Pulse; { strobe start line HIGH }
  Port[Lpt_Port_Address] := E;     { strobe start line LOW  }
  END;  { start }

PROCEDURE Read_ADC0809( E : INTEGER; Lpt_Port_Address : WORD; VAR Data : BYTE);
{
  REPEAT
    Read in raw data from the ADC-0809.
    Start conversion on next input channel.
    Digest and display the inputed data.
  UNTIL ESC key is pressed.
}
VAR  Temp1, Temp2, Carry : BYTE;
    High_Nibble, Low_Nibble : BYTE;
BEGIN { read 0809 }
Port[Lpt_Port_Address] :=  E OR OE; { turn on tri-state output                 }
 { set all pins HIGH so you can read from base + 2 }
Port[Lpt_Port_Address + 2] := Port[Lpt_Port_Address + 2] OR $0F;
delay(50);  { allow ADC-0809 time to digest instruction                        }
Low_Nibble :=  Port[Lpt_Port_Address + 2];
High_Nibble := Port[Lpt_Port_Address + 1];
Port[Lpt_Port_Address] :=  E; { turn off tri-state output                      }
Start_Conversion(E + 1, Lpt_Port_Address); { give A/D time for next conversion }
 { digest raw data }
High_Nibble := High_Nibble AND $F0;      { HEX F0 = 11110000                   }
Low_Nibble := Low_Nibble AND  $0F;       { HEX 0F = 00001111                   }
Data := High_Nibble OR Low_Nibble;
END;  { read 0809  }

PROCEDURE Display_Value(E : INTEGER; Data : BYTE);
VAR L, S, T, U  : INTEGER;

BEGIN { display value }
U := 1; S := 1; L := 3;
GOTOXY(1,E*3 + L);
WRITE( 'CHANNEL #',E, ':     D7    D6    D5    D4    D3    D2    D1    D0');
  REPEAT
  IF Data AND S = S THEN T := S ELSE  T := 0;
  GOTOXY(64 - (U * 6),E * 3 + L + 1); WRITE(T:3);
  S := S + S; U := U + 1;
  UNTIL U > 8;
GOTOXY(1,E*3 + L + 1); WRITE(DATA:3,' dec      =');
END; { display value }

BEGIN { main }
Select_Printer_Port(Lpt_Num, Lpt_Port_Address); { in My_Tpu }
Cursor_Off; ClrScr;
 WRITELN('           -=[ ADC-0809 MULTIPLEXED A/D CONVERTER ]=-              ');

  REPEAT
  Start_Conversion(0, Lpt_Port_Address);
  FOR E := 0 TO Max_Channels  DO
    BEGIN { for e }
    Read_ADC0809(E, Lpt_Port_Address, Data );
    Display_Value(E, Data);
    IF KeyPressed THEN Ch := ReadKey;  { check for request to exit             }
    END; { for e }
  UNTIL ORD(Ch) = 27;                  { pressing ESC exits program            }
ClrScr;
END.  { main }


