
PROGRAM DualFaze; { .pas }
 {
   DUAL PHASE opteration of a six wire stepping motor.

   This method will also work with 8-wire stepping motors configured for
   6-wire operation.
 }
USES CRT, PRINTER, My_Tpu;
CONST T = 300;
      D0 = 1;
      D1 = 2;
      D2 = 4;
      D3 = 8;
VAR                         E : INTEGER;
    Lpt_Num, Lpt_Port_Address : WORD;

BEGIN
   (* %%%%%%%%%%%%%%%%%%%%%%%%  -=[ METHOD ONE ]=-  %%%%%%%%%%%%%%%%% *)
{
   Dual Phase operation of 6-wire stepping motor.  Uses Pascal's
   WRITE command to transmit data through computer's LPT1 printer port.
   The WRITE commands sends data WITHOUT generating printer Line Feed, or
   Carriage Return instructions.
}
FOR E := 1 TO 10 DO  { step motor clockwise through 40 steps }
    BEGIN
    WRITE(LST, CHAR(D0 + D1)); DELAY(t);
    WRITE(LST, CHAR(D1 + D2)); DELAY(t);
    WRITE(LST, CHAR(D2 + D3)); DELAY(t);
    WRITE(LST, CHAR(D3 + D0)); DELAY(t);
    END; { for e }
  FOR E := 1 TO 10 DO  { step motor counter-clockwise through 40 steps }
    BEGIN
    WRITE(LST, CHAR(D3 + D0)); DELAY(t);
    WRITE(LST, CHAR(D2 + D3)); DELAY(t);
    WRITE(LST, CHAR(D1 + D2)); DELAY(t);
    WRITE(LST, CHAR(D0 + D1)); DELAY(t);
    END; { for e }
     (* %%%%%%%%%%%%%%%%%%%%%%%%  -=[ METHOD TWO ]=-  %%%%%%%%%%%%%%%%% *)
 {
   Dual Phase operation of 6-wire stepping motor.  Data is sent to printer port
   LPT1, LPT2, or LPT3.  From users keyboard input of the number 1, 2, or 3,
   port's address is computed, and used to route data.

   Since the printer port latches data sent to it, data sent to a printer
   port will remain on the output pins until new data replaces it.  That
   means stepping motors, directly driven by printer port logic, will hold
   there position between transmitted instructions.
 }
Select_Printer_Port(Lpt_Num, Lpt_Port_Address);
FOR E := 1 TO 10 DO    { step motor clockwise through 40 steps }
    BEGIN
    PORT[Lpt_Port_Address] := D0 + D1; DELAY(t);
    PORT[Lpt_Port_Address] := D1 + D2; DELAY(t);
    PORT[Lpt_Port_Address] := D2 + D3; DELAY(t);
    PORT[Lpt_Port_Address] := D3 + D0; DELAY(t);
    END; { for e }
  FOR E := 1 TO 10 DO  { step motor counter-clockwise through 40 steps }
    BEGIN
    PORT[Lpt_Port_Address] := D3 + D0; DELAY(t);
    PORT[Lpt_Port_Address] := D2 + D3; DELAY(t);
    PORT[Lpt_Port_Address] := D1 + D2; DELAY(t);
    PORT[Lpt_Port_Address] := D0 + D1; DELAY(t);
    END; { for e }
END. { dual phase }
