Program MM74C922;
{
 Inputs 4 bit data from National's MM74C922 matrix key-pad encoder via
 standard Centronics Parallel Printer Port. Output from the '922 is read
 into the parallel port's ( Base Address + 1 ).  D6 of the (Base Address + 1),
 the ACK line, is used to input the '922's strobe signal.  When D6 goes to an
 active LOW, the new value is displayed on the screen.

 Since data is comming in on printer port data lines D7, D5, D4, and D3,
 the data is reformated to ouput numbers between 0 and 15
}

USES CRT;
CONST D6 = 64;
VAR       Input_Bits : BYTE;
    Lpt_Port_Address : WORD;

BEGIN { main }
Lpt_Port_Address := 888; { 632 = IBM's 3ed parallel port address               }
                         { use 888 for Graphics Card's printer port,           }
                         { and 956 for Monochrome Card's printer port          }
ClrScr;
gotoxy(1,10); write('Inputs = ');
  REPEAT
  Input_Bits := PORT[Lpt_Port_Address + 1]; { read Base + 1 data bits          }
  IF Input_Bits AND D6 = 0 THEN             { is there new data to display?    }
    BEGIN  { reformat data bits D7, D5, D4, and D3, to D7, D6, D5, and D4      }
    Input_Bits := Input_Bits XOR 128;       { invert inverted bit, D7          }
    If (Input_Bits AND 128) = 128           { format data in high nibble       }
      THEN Input_Bits := (Input_Bits SHL 1) + 128
        ELSE Input_Bits := Input_Bits SHL 1;
    Input_Bits := Input_Bits SHR 4; { shift data to low nibble, D3, D2, D1, D0 }
    GOTOXY(10,10);                          { display new data                 }
    WRITE(Input_Bits:3);              
    REPEAT UNTIL (PORT[Lpt_Port_Address + 1] AND D6) = D6;  { switch released? }
    GOTOXY(10,10); WRITE('    ');           { clear data display               }
    END; { if }
  UNTIL KEYPRESSED;                         { press any key to exit            }
END.  { main }
