PROGRAM Mot_Clk;
{
  Bidirectional stepping motor control from parallel printer port using
  CLOCK PULSES. ClockWise pulses on D0, CounterClockWise pulses on D1.
}
USES CRT, My_Tpu, PRINTER;
CONST  CW = 1;   {        clockwise data bit, D0     }
      CCW = 2;   { counterclockwise data bit, D1 }
        t = 100; { time delay dependent on your computer's clock speed }
VAR                         E : INTEGER;
    Lpt_Num, Lpt_Port_Address : WORD;

BEGIN
   (* %%%%%%%%%%%%%%%%%%%%%%% -=[ METHOD ONE ]=- %%%%%%%%%%%%%%%%%%%% *)

{
   Advance stepper motor shaft 40 steps in clockwise direction.
   Strobe the ClockWise clock line, D0, 40 times.
   This method only works with LPT1.
}
WRITE(LST, CHAR(0)); { intitilize all control bits }
FOR E := 1 TO 40 DO
  BEGIN
  WRITE(LST, CHR(CW));    { 00000001 } DELAY(t);
  WRITE(LST, CHR(0));     { 00000000 } DELAY(t);
  END; { for e }
{
   Advance stepper motor shaft 40 steps in counter-clockwise direction.
   Strobe the counterclockwise clock line, D1, 40 times.
}
FOR E := 1 TO 40 DO
  BEGIN
  WRITE(LST, CHR(CCW));   { 00000010 }  DELAY(t);
  WRITE(LST, CHR(0));     { 00000000 }  DELAY(t);
  END; { for e }

   (* %%%%%%%%%%%%%%%%%%%%%%% -=[ METHOD TWO ]=- %%%%%%%%%%%%%%%%%%%% *)

Select_Printer_Port(Lpt_Num, Lpt_Port_Address);
{
   Advance stepper motor shaft 40 steps in clockwise direction.
   Strobe the Clockwise clock line, D0, 40 times.
   This method permits selection of LPT1, LPT2 or LPT3.
}

FOR E := 1 TO 40 DO
  BEGIN
  PORT[Lpt_Port_Address] :=  CW;      { 00000001 } DELAY(t);
  PORT[Lpt_Port_Address] :=  0;       { 00000000 } DELAY(t);
  END; { for e }
{
   Advance stepper motor shaft 40 steps in counter-clockwise direction.
   Strobe the counterclockwise clock line, D1, 40 times.
}
FOR E := 1 TO 40 DO
  BEGIN
  PORT[Lpt_Port_Address] :=  CCW;     { 00000010 } DELAY(t);
  PORT[Lpt_Port_Address] :=  0;       { 00000000 } DELAY(t);
  END; { for e }
END.
