
PROGRAM SPEECH;
{
  Produce speech using General Instrument's SPO256 Speech Processor.  The
  chip has 64 address locations each identifying instructions for sounding
  an allophone.  The chip's output should be fed to an audio amplifier.
}
USES CRT, PRINTER, My_Tpu;

TYPE    String80 = STRING[80];
     Set_Of_Char = SET OF CHAR;
{
    NOTE: The pound sign, "#", in front of a number, tells the Turbo
          Pascal compiler that the number is an ASCII value to be
          assigned to the character variable in front of the equal sign.
}

CONST
{
 Allophone information based on General Instruments' Data Sheets,
 and Radio Shack Data sheet packaged with item 276-1784.
}

{     DATA SHEET     DICTIONARY                         }
{     ALLOPHONE     PRONUNCIATION                       }
{      SYMBOL          SYMBOL                 NOTES     }

{*}   AA =  #24;     {      }
{*}   AE =  #26;     {   a   }
{*}   AO =  #23;     {      }
      AR =  #59;     {   r  }
{*}   AW =  #32;     {   ou  }
{*}   AX =  #15;     {   u   }
      AY =  #6;      {      }
      BB1 = #28;     {   b   final position }
                     {   b   between vowels, or in clusters }
      BB2 = #63;     {   b   initial position before a vowel }
      CH =  #50;     {   ch  }
      DD1 = #21;     {   d   final position }
      DD2 = #33;     {   d   initial positin }
      DH1 = #18;     {  th   word's initial position }
      DH2 = #54;     {  th   word's final position   }
                     {  th   between vowels          }
{*}   EH =  #7;      {   e   }
      EL =  #62;     {   l   }
      ER1 = #51;     {   ar  }
      ER2 = #52;     {   ur  }
      EY =  #20;     {      }
{*}   FF =  #40;     {        silent, use singly in final position }
      GG1 = #36;     {   g    before high front vowels: ir, , i, , e, er }
      GG2 = #61;     {   g    before high back vowels: , oo, , oi, u    }
                     {   g    before clusters }
      GG3 = #34;     {   g    before low vowels: a, ou, , r, , , r, ar, ur }
                     {        medical clusters }
                     {   g    final position }
      HH1 = #27;     {   h    before front vowels: ir, , i, , e, er, a }
      HH2 = #57;     {   h    before back vowels: , oo, , oi, , r, r }
{*}   IH =  #12;     {   i   }
      IY =  #19;     {      }
      JH =  #10;     {   j   }
      KK1 = #42;     {   k    before front vowels
                             ir, , i, , e, er, , a, ar, ur, u }
                     {   k    initial clusters }
      KK2 = #41;     {   k    final position }
      KK3 = #8;      {   k    before back vowel:, oo, , oi, r, r,  }
      LL  = #45;     {   L   }
      MM  = #16;     {   m   }
      NG  = #44;     {   ng  }
      NN1 = #11;     {   n    before front and central vowels:
                                   ir, , i, , e, er, a, ar, ur, u, ou, ,  }
                     {   n    final clusters }
      NN2 = #56;     {   n    before back vowels: oo, , oi, r, r,  }
      ORR  = #58;    {   r  }
      OW  = #53;     {      }
      OY  = #5;      {   oi  }
      PP1 =  #9;     {   P   }
      RR1 = #14;     {  _R    initial position = beginning of word }
      RR2 = #39;     {   r    initial cluster                      }
      SH =  #37;     {   sh  }
(*)   SS =  #55;     { silent }
(*)   TH =  #29;     { silent }
      TT1 = #17;     {   t     final cluster before SS }
      TT2 = #13;     {   t     all other positions }
{*}   UH =  #30;     {   oo   }
      UW1=  #22;     {       after y }
      UW2 = #31;     {       in one syllable words }
      VV =  #35;     {   V    }
      WH =  #48;     {   hW   }
      WW  = #46;     {   W    }
      XR =  #47;     {   er   }
      YR =  #60;     {   ir   }
      YY1 = #49;     {   y     clusters         }
      YY2 = #25;     {   Y     initial position }
      ZH =  #38;     {   Zh   }
      ZZ =  #43;     {   z    }

      PA1 = #0; { pause 10 ms, before BB, DD, GG, and JH                    }
      PA2 = #1; { pause 30 ms, before BB, DD, GG, and JH                    }
      PA3 = #2; { pause 50 ms, before PP, TT, KK, and CH, and between words }
      PA4 = #3; { pause 100 ms, between clauses and sentences               }
      PA5 = #4; { pause 200 ms, between clauses and sentences               }

{ allophones proceeded by "*", can be doubled }

VAR                                E : BYTE;
    Computer, Talking, Hello, Phrase : String80;
           Lpt_Num, Lpt_Port_Address : WORD;
                              Ok_Set : Set_Of_Char;

PROCEDURE Speak(Phrase : String80);
{
  Transmit each allophone byte of phrase to SPO256.
  Procedure will only transmit to LPT1.
}
CONST D6 = 64;
VAR    N : BYTE;

BEGIN { speek }
FOR N := 1 TO Length(Phrase) DO
  BEGIN { for n }
  WRITE(LST, CHR(ORD(Phrase[N]))
  );
  delay(30);                             { put data on data lines              }
  END; { for n }
END; { speek }

PROCEDURE Say(Phrase : String80);
{
  Transmit each allophone byte of phrase to SPO256.
  Will transmit on LPT1, LPT2, or LPT3.
}
CONST D7 = 128;
VAR N, Temp : Byte;

BEGIN { say }
FOR N := 1 TO Length(Phrase) DO
  BEGIN { for n }
{  Check speech chip's standby line, LRQ, ( D7, at pin 10 on printer port      }
{  When LRQ is logic high, chip can accept new data.                           }
  REPEAT UNTIL ( PORT[Lpt_Port_Address + 1] AND D7 ) = D7; { ok to transmit?   }
{ D0 set HIGH = 0. Why? Because you have to account for inverteed logic        }
{ All four control lines, at LPT Port Address + 2, are set to inactive         }
{   logic levels by sending 10, binary 00001010.                               }
{ Remember, Storbe line is inverted. High is 0, Low is 1.                      }
  PORT[Lpt_Port_Address + 2] := 10;         { set all control bits to inactive }
  PORT[Lpt_Port_Address] := ORD(Phrase[N]); { put data on data lines           }
  PORT[Lpt_Port_Address + 2] := 11;         { set strobe, D0, to active LOW    }
  PORT[Lpt_Port_Address + 2] := 10 ;        { set strobe, D0, to inactive HIGH }
  END; { for n }
END; { say }

BEGIN { main, speech }

 { define words by allophone sounds }
Computer := CONCAT(KK1, AX, pa1, MM, PP1, YY1, UW1, TT2, ER1, PA3);
Talking := CONCAT(TT2, AO, AO, PA3, KK1, IH, NG, PA3);
Hello := CONCAT(HH1, EH, LL, AX, OW, PA5);

 { transmit speech allophones via LPT1 }
Speak(Computer);
Speak(Talking);
DELAY(250);
Speak(Hello);

 { alternete method of sending speech allophones to LPT1, LPT2, or LPT3        }
Select_Printer_Port(Lpt_Num, Lpt_Port_Address);
Say(Computer);
Say(Talking);
DELAY(250);
Say(Hello);
END. { main, speech }
