/**********************************************************************/
/*                               D V I C                              */
/*--------------------------------------------------------------------*/
/*    Task           : Demonstrates direct access to video RAM.       */
/*--------------------------------------------------------------------*/
/*    Author         : MICHAEL TISCHER                                */
/*    Developed on   : 10/01/1988                                     */
/*    Last update    : 06/21/1989                                     */
/*--------------------------------------------------------------------*/
/*    (MICROSOFT C)                                                   */
/*    Creation       : CL /AS DVIC.C                                  */
/*    Call           : DVIC                                           */
/*--------------------------------------------------------------------*/
/*    (BORLAND TURBO C)                                               */
/*    Creation       : RUN menu command (no project file needed)      */
/**********************************************************************/

/*== Include files ===================================================*/

#include <dos.h>
#include <stdlib.h>
#include <string.h>
#include <stdarg.h>
#include <bios.h>

/*== Type definitions ================================================*/

typedef unsigned char BYTE;                          /* Create a byte */
typedef struct velb far * VP;        /* VP = FAR pointer in video RAM */
typedef BYTE BOOL;                    /* similar to BOOLEAN in Pascal */

/*== Structures ======================================================*/

struct velb {            /* Describes a 2-byte position on the screen */
             BYTE character,                            /* ASCII code */
                  attribute;                   /* Character attribute */
            };

/*== Macros ==========================================================*/

/*-- MK_FP creates a FAR pointer to an object from a segment   -------*/
/*-- address and offset address                                -------*/

#ifndef MK_FP                               /* MK_FP not defined yet? */
#define MK_FP(seg, ofs) ((void far *) ((unsigned long) (seg)<<16|(ofs)))
#endif

#define COLOR(VG, HG) ((VG << 3) + HG)

/*== Constants =======================================================*/

#define TRUE  1                        /* Constants for use with BOOL */
#define FALSE 0

/*-- The following constants return pointers to variables from the ---*/
/*-- BIOS variable segment at segment address 0x40                 ---*/

#define CRT_START ((unsigned far *) MK_FP(0x40, 0x4E))
#define ADDR_6845 ((unsigned far *) MK_FP(0x40, 0x63))

#define NORMAL        0x07          /* Character attribute definition */
#define BRIGHT        0x0f          /*  Based on monochrome video card*/
#define INVERSE       0x70
#define UNDERSCORED   0x01
#define BLINKING      0x80

#define BLACK         0x00         /* Color attributes for color card */
#define BLUE          0x01
#define GREEN         0x02
#define COBALTBLUE    0x03
#define RED           0x04
#define VIOLET        0x05
#define BROWN         0x06
#define LIGHTGRAY     0x07
#define DARKGRAY      0x01
#define LIGHTBLUE     0x09
#define LIGHTGREEN    0x0A
#define LIGHTCOBALT   0x0B
#define LIGHTRED      0x0C
#define LIGHTVIOLET   0x0D
#define YELLOW        0x0E
#define WHITE         0x0F

/*== Global variables ================================================*/

VP vptr;                   /* Pointer to first character in video RAM */

/***********************************************************************
*  Function         : D P R I N T                                      *
**--------------------------------------------------------------------**
*  Task             : Writes a string directly to video RAM            *
*                                                                      *
*  Input parameters : - COLUMN   = Output column                       *
*                     - LINES    = Output row                          *
*                     - COLOR    = Character attribute                 *
*                     - STRING   = Pointer to string                   *
*  Return value     : None                                             *
***********************************************************************/

void dprint(BYTE column, BYTE lines, BYTE color, char * string)

{
 register VP lptr;                   /* Floating pointer in video RAM */
 register BYTE i;                   /* Points to number of characters */

 /*-- Set pointer to output position in video RAM --------------------*/
 lptr = (VP) ((BYTE far *) vptr + *CRT_START) + lines * 80 + column;
 for (i=0 ; *string ; ++lptr, ++i)                  /* Execute string */
  {
   lptr->character = *(string++);           /* Character in video RAM */
   lptr->attribute = color;                /* Set character attribute */
  }
}

/***********************************************************************
*  Function         : I N I T _ D P R I N T                            *
**--------------------------------------------------------------------**
*  Task             : Determines video RAM segment address for DPRINT  *
*  Input parameters : None                                             *
*  Return value     : None                                             *
*  Info             : Allocates segment address of video RAM in VPTR   *
*                     global variable                                  *
***********************************************************************/

void init_dprint()

{
 vptr = (VP) MK_FP( (*ADDR_6845 == 0x3B4) ? 0xB000 : 0xB800, 0 );
}

/***********************************************************************
*  Function         : C L S                                            *
**--------------------------------------------------------------------**
*  Task             : Clears the screen with the help of DPRINT        *
*                                                                      *
*  Input parameters : - COLOR    = Character attribute                 *
*  Return value     : None                                             *
***********************************************************************/

void cls( BYTE color )

{
 static char blankline[81] =
  { ' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',
    ' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',
    ' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',
    ' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',
    ' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',
    ' ',' ',' ',' ',' ','\0'
  };

 register BYTE i;                                     /* Loop counter */

 for (i=0; i<24; ++i)                            /* Execute each line */
  dprint(0, i, color, blankline);               /* Display blank line */
}

/***********************************************************************
*  Function         : N O K E Y                                        *
**--------------------------------------------------------------------**
*  Task             : Tests for a keypress                             *
*  Input parameters : None                                             *
*  Return value     : TRUE if a key is pressed, otherwise FALSE        *
***********************************************************************/

BOOL nokey()

{
#ifdef __TURBOC__                     /* Compiling this with TURBO C? */
 return( bioskey( 1 ) == 0 );         /* YES, read keyboard from BIOS */
#else                                            /* Using Microsoft C */
 return( _bios_keybrd( _KEYBRD_READY ) == 0 );      /* Read from BIOS */
#endif
}

/**********************************************************************/
/**                           MAIN  PROGRAM                          **/
/**********************************************************************/

void main()
{
 BYTE firstcol,                /* Color of first square on the screen */
      color,                               /* Color of current square */
      column,                              /* Current output position */
      lines;

 init_dprint();             /* Determine segment address of video RAM */
 cls( COLOR(BLACK, GREEN) );                          /* Clear screen */
 dprint(22, 0, WHITE, "DVIC  - (c) 1988 by Michael Tischer");
 firstcol = BLACK  ;                              /* Start with black */
 while( nokey() )              /* Repeat until the user presses a key */
  {
   if (++firstcol > WHITE)                     /* Reached last color? */
    firstcol = BLUE;                       /* YES, continue with blue */
   color = firstcol;                 /* Set first color on the screen */

   /*-- Fill screen with squares -------------------------------------*/

   for ( column=0; column < 80; column += 4)
    for (lines=1; lines < 24; lines += 2)
     {
      dprint( column, lines,   color, "");/* Block characters can */
      dprint( column, lines+1, color, "");/* be created by press- */
      color = ++color & 15;                   /* ing <Alt><2><1><9>   */
     }
  }
}
