/**********************************************************************/
/*                              I N T D O S                           */
/*--------------------------------------------------------------------*/
/*    Task           : an example of an interrupt call, outputs       */
/*                     a string through a DOS function on             */
/*                     the display screen                             */
/*--------------------------------------------------------------------*/
/*    Author         : MICHAEL TISCHER                                */
/*    developed      : 08/30/87                                       */
/*    last update    : 04/08/89                                       */
/*--------------------------------------------------------------------*/
/*    (MICROSOFT C)                                                   */
/*    Creation       : MSC INTDOSC                                    */
/*                     LINK INTDOSC PEPO;                             */
/*    Call           : INTDOSC                                        */
/*--------------------------------------------------------------------*/
/*    (BORLAND TURBO C v2.0)                                          */
/*    Creation       : through the RUN command in the menu...or...    */
/*                     tcc -K intdosc                                 */
/*    Call           : intdosc                                        */
/**********************************************************************/

#include <dos.h>                          /* include header file      */
/* Microsoft C user must uncomment the following line                 */
/* extern short int peekb();              /* PEEKB must be linked to  */
/*                                           Microsoft C object code  */
/**********************************************************************/
/**                           MAIN PROGRAM                           **/
/**********************************************************************/

void main()

{
 static char AT[] = "\r\nthis computer is an AT\r\n$";
 static char XT[] = "\r\nthis computer is an XT\r\n$";
 static char PC[] = "\r\nthis computer is an PC\r\n$";

 union REGS Register;         /* Register variable for interrupt call */

 Register.h.ah = 9;           /* Function number for output of string */
 switch (peekb(0xF000, 0xFFFE))                 /* detect model of PC */
  {
   case 0xFE : Register.x.dx = (int) XT;        /* Address of XT text */
               break;
   case 0xFC : Register.x.dx = (int) AT;        /* Address of AT text */
               break;
   case 0xFF :
   default   : Register.x.dx = (int) PC;        /* Address of PC text */
  }
 intdos(&Register, &Register);           /*  Call DOS interrupt 21(h) */
}
