{**********************************************************************}
{*                              M E M P                               *}
{*--------------------------------------------------------------------*}
{*    Description    : displays the memory blocks allocated by DOS.   *}
{*--------------------------------------------------------------------*}
{*    Author         : MICHAEL TISCHER                                *}
{*    developed on   : 08/22/1988                                     *}
{*    last update    : 08/22/1988                                     *}
{**********************************************************************}

program MEMP;

uses DOS, CRT;                         { bind in the DOS and CRT units }

type BytePtr = ^byte;                              { pointer to a byte }
     Range = array[0..1000] of byte;       { an area, anywhere in RAM }
     RngPtr  = ^Range;                            { pointer to an area }
     MCB     = record                         { a memory control block }
                 IdCode   : char;   { "M" = a block follows, "Z" = end }
                 PSP      : word;         { segment address of the PSP }
                 Distance : word;           { number of paragraphs - 1 }
               end;
     MCBPtr  = ^MCB;                               { pointer to an MCB }
     MCBPtr2 = ^MCBPtr;                         { pointer to an MCBPtr }
     HexStr  = string[4];             { stores a four-digit hex string }

var  CvHStr  : HexStr;               { stores the converted hex string }

{**********************************************************************}
{* GetDosVer: determines the DOS version                              *}
{* Input  : none                                                      *}
{* Output : the DOS version number (30 for DOS 3.0, 33 for 3.3 etc.)  *}
{**********************************************************************}

function GetDosVer : byte;

var Regs : Registers;                 { stores the processor registers }


begin
  Regs.ah := $30;                 { function no. for "Get Dos Version" }
  MsDos( Regs );                              { call DOS interrupt $21 }
  GetDosVer := Regs.al * 10 + Regs.ah;            { get version number }
end;

{**********************************************************************}
{* MK_FP: creates a byte pointer out of the segment and offset        *}
{*        addresses passed.                                           *}
{* Input   : - Seg = segment to which the point should point          *}
{*           - Ofs = offset address to which the pointer should point *}
{* Output  : the pointer                                              *}
{* Info    : The pointer returned can be cast to any type pointer     *}
{**********************************************************************}

{$F+}             { This routine is intended for the FAR model and is  }
                  { also suited for binding into a unit.               }

function MK_FP( Seg, Ofs : word ) : BytePtr;

begin
  inline ( $8B / $46 / $08 /  { mov ax,[bp+8] (get segment address)    }
           $89 / $46 / $FE /  { mov [bp-2],ax (and put in pointer)     }
           $8B / $46 / $06 /  { mov ax,[bp+6] (get offset address)     }
           $89 / $46 / $FC ); { mov [bp-4],ax (and put in pointer)     }
end;

{$F-}                                   { NEAR routines possible again }

{**********************************************************************}
{* HexString: creates a 4-digit hex string out of the number passed   *}
{* Input   : - HexVal = the number to be converted                    *}
{* Output  : the hex string                                           *}
{**********************************************************************}

function HexString( HexVal : word ) : HexStr;

var Counter,                                            { loop counter }
    Nibble  : byte;                    { the lowest nibble of the word }

begin
  CvHStr := 'xxxx';                            { initialize the string }
  for Counter:=4 downto 1 do  { run through the 4 digits of the string }
    begin
      Nibble := HexVal and $000f;        { leave just the lower 4 bits }
      if ( Nibble > 9 ) then                    { convert to a letter? }
        CvHStr[ Counter ] := chr(Nibble - 10 + ord('A'))         { yes }
      else                                       { convert to a number }
        CvHStr[ Counter ] := chr(Nibble + ord('0'));
      HexVal := HexVal shr 4;       { shift HexVal 4 bits to the right }
    end;
  HexString := CvHStr;                     { return the created string }
end;

{**********************************************************************}
{* FirstMCB: Returns a pointer to the first MCB.                      *}
{* Input   : none                                                     *}
{* Output  : pointer to the firs MCB                                  *}
{**********************************************************************}

function FirstMCB : MCBPtr;

var Regs : Registers;                 { stores the processor registers }

begin
  Regs.ah := $52;        { ftn. no.: get address of the DOS info block }
  MsDos( Regs );                              { call DOS interrupt $21 }

  {*-- ES:(BX-4) points to the first MCB, create pointer -------------*}

  FirstMCB := MCBPtr2( MK_FP( Regs.ES-1, Regs.BX+12 ) )^;
end;

{**********************************************************************}
{* Dump: outputs hex and ASCII dump of a memory block.                *}
{* Input   : - DPtr  = pointer to the memory block to be dumped       *}
{*           - Num   = number of lines to dump (16 bytes each)        *}
{* Output  : none                                                     *}
{**********************************************************************}

procedure Dump( DPtr : RngPtr; Num{Num} : byte);

type HBStr = string[2];                   { stores 2-digit hex numbers }

var  Offset,                              { offset in the memory block }
     Z       : integer;                                 { loop Counter }
     HexStr  : HBStr;               { stores a hex number for hex dump }

procedure HexByte( HByte : byte );

begin
  HexStr[1] := chr( (HByte shr 4) + ord('0') );          { first digit }
  if HexStr[1] > '9' then                        { convert to letters? }
    HexStr[1] := chr( ord(HexStr[1]) +  7 );                     { yes }
  HexStr[2] := chr( (HByte and 15) + ord('0') );        { second digit }
  if HexStr[2] > '9' then                        { convert to letters? }
    HexStr[2] := chr( ord(HexStr[2]) +  7 );                     { yes }
end;

begin
  HexStr := 'zz';                          { initialize the hex string }
  writeln;
  write('DUMP  0123456789ABCDEF        00 01 02 03 04 05 06 07 08');
  writeln(' 09 0A 0B 0C 0D 0E 0F');
  write('');
  writeln('');
  Offset := 0;                { start with the first byte in the block }
  while Num>0 do                      { run through the loop ANZ times }
    begin
      write(HexString(Offset), '  ');
      for Z:=0 to 15 do                             { process 15 bytes }
        if (Dptr^[Offset+Z] >= 32) then       { valid ASCII character? }
          write( chr(Dptr^[Offset+Z]) )        { yes, output character }
        else                                                      { no }
          write(' ');              { output space instead of character }
      write('        ');               { set cursor to the hex portion }
      for Z:=0 to 15 do                             { process 15 bytes }
        begin
          HexByte( Dptr^[Offset+Z] );            { convert byte to hex }
          write(HexStr, ' ');                      { output hex string }
        end;
      writeln;
      Offset := Offset + 16;             { set offset in the next line }
      Dec( Num );                { decrement number of remaining lines }
    end;
  writeln;
end;

{**********************************************************************}
{* TraceMCB: runs through the list of MCB's.                          *}
{* Input   : none                                                     *}
{* Output  : none                                                     *}
{**********************************************************************}

procedure TraceMCB;

const ComSpec : array[0..7] of char = 'COMSPEC=';

var  CurMCB{CurMCB}  : MCBPtr;
     Done    : boolean;
     Key     : char;
     NrMCB,                                    { number of current MCB }
     Z       : integer;                                 { loop counter }
     MemPtr  : RngPtr;
     DosVer  : byte;                              { DOS version number }

begin
  DosVer := GetDosVer;                               { get DOS version }
  Done := false;
  NrMCB := 1;                              { the first MCB is number 1 }
  CurMCB := FirstMCB;                   { get pointer to the first MCB }
  repeat                                        { follow the MCB chain }
    if CurMCB^.IdCode = 'Z' then                   { last MCB reached? }
      Done := true;                                              { yes }
    writeln('MCB number    = ', NrMCB);
    writeln('MCB address   = ', HexString(seg(CurMCB^)), ':',
                                HexString(ofs(CurMCB^)) );
    writeln('Memory addr.  = ', HexString(succ(seg(CurMCB^))), ':',
                                HexString(ofs(CurMCB^)) );
    writeln('ID            = ', CurMCB^.IdCode);
    writeln('PSP address   = ', HexString(CurMCB^.PSP), ':0000');
    writeln('Size          = ', CurMCB^.Distance, ' paragraphs ',
            '( ', longint(CurMCB^.Distance) shl 4, ' bytes )');
    write('Contents      = ');


    {*-- is it an environment? ---------------------------------------*}

    Z := 0;                   { start the comparison at the first byte }
    MemPtr := RngPtr(MK_FP(succ(Seg(CurMCB^)), 0));   { pointer in RAM }
    while ( (Z<=7) and (ord(ComSpec[Z]) = MemPtr^[Z]) ) do
    Inc(Z);                              { set Z to the nest character }
    if Z>7 then                                { was the string found? }
      begin                              { yes, this is an environment }
        writeln('environment');
        MemPtr := RngPtr(MK_FP(succ(Seg(CurMCB^)), 0));
        if DosVer>= 30 then               { DOS Version 3.0 or higher? }
          begin                                { yes, get program name }
            write('Program name  = ');
            Z := 0;                        { start with the first byte }
            while not( (MemPtr^[Z]=0) and (MemPtr^[Z+1]=0) ) do
              Inc( Z );                      { search for empty string }
            Z := Z + 4;          { set Z to the start of the prog name }
            if MemPtr^[Z]<>0 then        { is there a prog. name here? }
              begin
                repeat                  { run through the program name }
                  write( chr(MemPtr^[Z]) );        { output characters }
                  Inc( Z );               { process the next character }
                until MemPtr^[Z]=0;         { to the end of the string }
                writeln;
              end
            else                              { program name not found }
             writeln('unknown');
          end;

        {*-- output the environment strings --------------------------*}

        writeln(#13,#10, 'Environment strings');
        Z := 0;     { start with the first byte in the allocated block }
        while MemPtr^[Z]<>0 do             { repeat until empty string }
          begin
            write('      ');
            repeat                                   { output a string }
              write( chr(MemPtr^[Z]) );            { print a character }
              Inc( Z );                   { process the next character }
            until MemPtr^[Z]=0;             { to the end of the string }
            Inc( Z );            { set to the start of the next string }
            writeln;                                        { end line }
          end
      end
    else                                              { no envrionment }
      begin

        {*-- is it a PSP? --------------------------------------------*}
        {*-- (starts with command INT 20 (code=$CD $20)) -------------*}

        MemPtr := RngPtr(MK_FP(succ(seg(CurMCB^)), 0));  { set pointer }
        if ( (MemPtr^[0]=$CD) and (MemPtr^[1]=$20) ) then
          begin                                           { it's a PSP }
            writeln('PSP (with program following)');
          end
        else                        { the command INT 20 was not found }
          begin
            writeln('unidentifiable (program or data)');
            Dump( MemPtr, 5);              { dump the first 5x16 bytes }
          end;
      end;

    write('');
    writeln(' Press a key ');
    if ( not Done ) then
     begin                               { set pointer to the next MCB }
       CurMCB := MCBPtr(MK_FP(seg(CurMCB^) + CurMCB^.Distance + 1, 0));
       Inc(NrMCB);                   { increment the number of the MCB }
       Key := ReadKey;
     end;
  until ( Done )              { repeat until the last MCB is processed }
end;

{**********************************************************************}
{**                           MAIN PROGRAM                           **}
{**********************************************************************}

begin
  ClrScr;                                           { clear the screen }
  TraceMCB;                                     { run through the MCBs }
end.
