;**********************************************************************; 
;*                            C E _ H A N D                           *;
;*--------------------------------------------------------------------*; 
;*    Description    : Forms the basic structure of an assembler      *;
;*                     program, in which the DOS Ctrl-Break and       *;
;*                     Critical Error Interrupt are captured          *; 
;*--------------------------------------------------------------------*; 
;*    Author         : MICHAEL TISCHER                                *; 
;*    developed on   : 9/5/1988                                       *; 
;*    last update    : 4/8/1989                                       *;
;*--------------------------------------------------------------------*; 
;*    assemble       : MASM CE_HAND;                                  *;
;*                     LINK CE_HAND;                                  *;
;*--------------------------------------------------------------------*; 
;*    call           : CE_HAND                                        *;
;*                     (please leave the disk drive open so that a    *; 
;*                      Critical Error occurs.)                       *; 
;**********************************************************************; 
;== constants ========================================================== 
 
;== stack ============================================================== 
stack     segment para stack      ;definition of the stack segment 
          dw 256 dup (?)          ;the stack is 256 words 
stack     ends                    ;end of the stack segment 
;== data =============================================================== 
data      segment para 'DATA'     ;definition of the data segment 
cr_err    db  0                   ;goes to 1, if a critical error occurs 
                                  ;during access to a peripheral device 
                                  ;(floppy, hard disk, or printer) 
cr_typ    db  0                   ;error number of the critical error 
cr_mes    db  "Critical error! (A)bort or (R)etry: $" 
next_line db  13,10,"$" 
end_mes   db  "Program ended normally.$" 
brk_mes   db  "Program aborted.$" 
dat_nam   db  "A:TEST.DAT",0      ;name of the test file 
data      ends                    ;end of the data segment 
;== code =============================================================== 
code      segment para 'CODE'     ;definition of the CODE segment 
          assume cs:code, ds:data, ss:stack 
start     proc far 
          ;-- install both Interrupt Handlers -------------------------- 
          push cs                 ;put CS on the stack 
          pop  ds                 ;and return as DS 
          mov  ax,2523h           ;fct.no.: set Ctrl-Break Handler 
          mov  dx,offset cbreak   ;DS:DX now contains the address of H.
          int  21h                ;call DOS Interrupt 
          mov  al,24h             ;now set Interrupt 24h 
          mov  dx,offset cerror   ;DS:DX contains the address of the new H.
          int  21h                ;call DOS Interrupt 
          mov  ax,data            ;load segment address of the data segment in 
          mov  ds,ax              ;in the DS register 
          ;-- you can add your program here  --------------------------- 
                                  ;
                                  ;
                                  ;
          ;-- for a demonstration, try to open a file  ----------------- 
          ;-- on the opened disk drive                 ----------------- 
dat_open: mov  ah,3dh             ;function number: open file 
          mov  al,0               ;file mode: read only 
          mov  dx,offset dat_nam  ;DS:DX = addresse of the filename 
          int  21h                ;call DOS Interrupt 21h 
          jnc  exit               ;no error? NO --> END
          cmp  cr_err,0           ;critical error? 
          je   exit               ;NO --> END
          call crit_err           ;a critical error occured 
          jmp  dat_open           ;CRIT_ERR returns only if the operation         
                                  ;should be retried 
                                  ;(IGNORE is not possible) 
          ;-- the handler must not be re-installed before the end ------ 
          ;-- of the program, since this is done by DOS           ------ 
exit:     mov  ah,9               ;function number: pass string
          mov  dx,offset end_mes  ;DS:DX = address of the message 
          int  21h                ;call DOS Interrupt 
          mov  ax,4C00h           ;function no.: end program (ERRCODE=0)
          int  21h                ;call DOS Interrupt and end the program 
                                  ;with it 
start     endp 
;-- CRIT_ERR: called within the program after discovery of a  ---------- 
;--           critical error                                  ---------- 
crit_err  proc near 
          ;-- output message and ask for user input  ------------------- 
ask:      mov  ah,9               ;function number: output string 
          mov  dx,offset cr_mes   ;DS:DX = address of the message 
          int  21h                ;call DOS Interrupt 
          mov  ah,1               ;function number: input character 
          int  21h                ;call DOS Interrupt 
          push ax                 ;note the input 
          mov  ah,9               ;function number: output string 
          mov  dx,offset next_line;DS:DX = address of the message 
          int  21h                ;call DOS Interrupt 
          ;-- interpret the user's input ------------------------------- 
          pop  ax                 ;retrieve the input 
          cmp  al,"A"             ;abort? 
          je   end_up             ;go to "clean-up" procedure 
          cmp  al,"a"             ;abort? 
          je   end_up             ;go to "clean-up" procedure 
          cmp  al,"r"             ;retry? 
          je   crend              ;go to end of procedure 
          cmp  al,"R"             ;retry? 
          jne  ask                ;no, ask again 
crend:    ret                     ;return to caller 
crit_err  endp 
;-- END_UP: executes a "clean" ending  --------------------------------- 
end_up    proc near 
          ;-- all opened files can be closed and the system memory  ---- 
          ;-- allocated by the program can be freed here            ---- 
                                  ;
                                  ;
                                  ;
          mov  ah,9               ;function number: output string 
          mov  dx,offset brk_mes  ;DS:DX = address of the message 
          int  21h                ;call DOS Interrupt
          mov  ax,4C00h           ;end the program normally with the
          int  21h                ;4Ch function 
end_up    endp 
;-- CBREAK: the new Ctrl-Break Handler --------------------------------- 
cbreak    proc far 
          ;-- all registers altered within this routine (excluding ---- 
          ;-- the Flag Register) have to be secured on the stack   ---- 
          push ds 
          mov  ax,data            ;load the segment address of the 
          mov  ds,ax              ;data segment in the DS-Register 
          ;-- for example, you can open a window here in which the ----- 
          ;-- user is asked if he really wants to end the program  -----
                                  ;
                                  ;
                                  ;
          jmp  go_on              ;don't end program 
          ;-- if the user decides to end the program, a routine with --- 
          ;-- which the program can be ended can be started here     --- 
          jmp   end_up            ;prepare termination of the program 
          ;-- the program should not be aborted, continue normal  ------ 
          ;-- execution                                           ------ 
go_on:    pop   ds                ;restore saved register
          iret                    ;back to DOS, where the interrupted 
                                  ;function is continued normally 
cbreak    endp 
;-- CERROR: the new Critical Error Handler ----------------------------- 
cerror    proc far 
          ;-- each of the registers (SS, SP, DX, ES, DX, CX und BX)  ---- 
          ;-- that was altered within this routine must be saved     ----
          ;-- on the stack                                           ---- 
          sti                     ;allow interrupts again 
          push ds 
          mov  ax,data            ;load segment address of the data segment 
          mov  ds,ax              ;in the DS-Register 
          mov  cr_err,1           ;point to critical error 
          mov  ax,di              ;error number to AX 
          mov  cr_typ,al          ;note error number 
          mov  al,3               ;end function call with error 
          pop  ds                 ;fetch DS again 
          iret 
cerror    endp 
;----------------------------------------------------------------------- 
code      ends                    ;end of the code segment 
          end  start              ;start program execution with 
                                  ;the START procedure 


