;********************************************************************;
;*                              D U M P                              *;
;*-------------------------------------------------------------------*;
;*    Task : A Filter which reads characters from the Standard input *;
;*           and outputs them as Hex- and ASCII-Dump on              *;
;*           the Standard output device                              *;
;*-------------------------------------------------------------------*;
;*    Author         : MICHAEL TISCHER                               *;
;*    developed on   : 08/01/87                                      *;
;*    last Update    : 04/08/89                                      *;
;*-------------------------------------------------------------------*;
;*    assemble       : MASM DUMPA;                                   *;
;*                     LINK DUMPA;                                   *;
;*   (important)...    EXE2BIN DUMPA DUMP.COM                        *;
;*-------------------------------------------------------------------*;
;*    Call           : DUMP [<Input] [>Output]                       *;
;*********************************************************************;

;== Constants ========================================================

      NUL    equ 0                ;ASCII-Code NUL-Character
      BEL    equ 7                ;ASCII-Code Bell
      BS     equ 8                ;ASCII-Code Backspace
      TAB    equ 9                ;ASCII-Code Tabulator
      LF     equ 10               ;ASCII-Code Linefeed
      CR     equ 13               ;ASCII-Code Carriage Return
      EOF    equ 26               ;ASCII-Code End of File
      ESC    equ 27               ;ASCII-Code Escape

;== Program starts here  ==============================

code      segment para 'CODE'     ;Definition of CODE-Segments

          org 100h

          assume cs:code, ds:code, es:code, ss:code

;-- Start routine -----------------------------------------------------

dump      label near

          ;-- Read in 9 Bytes from Standard input device --------------

          xor  bx,bx              ;Standard input has the handle 0
          mov  cx,9               ;read in 9 characters 
          mov  dx,offset newbyte  ;Address of the buffer 
          mov  ah,3Fh             ;Function code for handle reading 
          int  21h                ;Call DOS-Function 
          or   ax,ax              ;characters read in?
          jne  dodump             ;YES --> process line 
          jmp  dumpend            ;NO --> DUMPEND

dodump:   mov  dx,ax              ;record number of characters read

          ;-- Fill output buffer with Spaces --------------------------

          mov  cx,15              ;15 Words (30 Bytes)
          mov  ax,2020h           ;ASCII-Code of " " to AH and AL
          mov  di,offset dumpbuf  ;the Address of the output buffer 
          cld                     ;increment on String commands 
          rep stosw               ;Fill buffer with Spaces 

          ;-- Construct Output Buffer --------------------------------

          mov  cx,dx              ;Get number of characters read in 
          mov  di,offset dumpbuf+31 ;Position Ascii-Codes in the buffer 
          mov  bx,offset newbyte  ;Pointer to input buffer 
          mov  si,offset dumpbuf  ;Position for Hex-Codes in Buffer 

bytein:   mov  ah,[bx]            ;Read in Byte
          push si                 ;store SI on the Stack 
          mov  si,offset sotab    ;Address of special character table
          mov  dx,offset sotext-6 ;Address of special character text 
sotest:   add  dx,6               ;next entry in special text
          lodsb                   ;Load code from special char table
          cmp  al,255             ;Reached end of table?
          je   noso               ;YES --> no special character
          cmp  ah,al              ;do codes agree?
          jne  sotest             ;NO --> test next table element

          ;-- Code was a special character ---------------------------

          push cx                 ;Store Counter 
          mov  si,dx              ;copy DX to SI 
          lodsb                   ;read number of char control codes
          mov  cl,al              ;transfer number of characters to CL 
          rep  movsb              ;copy designation into buffer 
          pop  cx                 ;get counter 
          pop  si                 ;return SI from Stack 
          mov  al,ah              ;copy character to AL 
          jmp  short hex          ;calculate Hex-Code 

noso:     pop  si                 ;return SI from Stack 
          mov  al,ah              ;copy character to AL 
          stosb                   ;store in buffer 

hex:      mov  al,ah              ;Code of character to AL
          and  ah,1111b           ;mask upper 4 Bit in AH 
          shr  al,1               ;shift AL right 4 Bits 
          shr  al,1               
          shr  al,1
          shr  al,1
          or   ax,3030h           ;convert AH and AL into ASCII-Codes 
          cmp  al,"9"             ;is AL a letter ?
          jbe  nobal              ;NO --> no correction 
          add  al,"A"-"1"-9       ;correct AL 
nobal:    cmp  ah,"9"             ;is AH a letter ?
          jbe  hexout             ;NO --> no correction 
          add  ah,"A"-"1"-9       ;correct AH 
hexout:   mov  [si],ax            ;store Hex-Code in buffer 
          add  si,3               ;point to next Position 

          inc  bx                 ;set pointer to next Byte 
          loop bytein             ;process next Byte

          mov  al,219             ;set separator
          stosb

          mov  ax,LF shl 8 + CR   ;CR and LF terminate buffer 
          stosw                   ;write in buffer 

          ;-- Send Dump to the Standard output device ----------------

          mov  bx,1               ;Standard output is handle 1
          mov  cx,di              ;determine number of characters to be 
          sub  cx,offset dumpbuf  ;transmitted 
          mov  dx,offset dumpbuf  ;Address of buffer 
          mov  ah,40h             ;Function code for handle 
          int  21h                ;call DOS-function 
          jmp  dump               ;read in next 9 Bytes 

dumpend   label near

          mov  ax,4C00h           ;Function number for ending program 
          int  21h                ;end program with End code 

;== Data ==============================================================

newbyte   db 9 dup (?)            ;the 9 Bytes read in
dumpbuf   db 30 dup (?), 219      ;the output buffer 
          db 49 dup (?)

sotab     db NUL,BEL,BS,TAB       ;Table of control characters 
          db LF,CR,EOF,ESC
          db 255

sotext    equ this byte           ;Text of special characters 
          db 5,"<NUL>"            ;NUL
          db 5,"<BEL>"            ;Bell 
          db 4,"<BS> "            ;Backspace
          db 5,"<TAB>"            ;Tabulator
          db 4,"<LF> "            ;Linefeed
          db 4,"<CR> "            ;Carriage-Return
          db 5,"<EOF>"            ;End of File
          db 5,"<ESC>"            ;Escape

;== End ===============================================================

code      ends                    ;End of CODE-Segment
          end  dump
