;*********************************************************************;
;*                              E X E C                              *;
;*-------------------------------------------------------------------*;
;*    Task        :    Calls a program with the help of the          *;
;*                     EXEC function of DOS. In this example         *;
;*                     program the content of the current            *;
;*                     Directory of the current device is displayed. *;
;*-------------------------------------------------------------------*;
;*    Author         : MICHAEL TISCHER                               *;
;*    developed on   :  08/01/87                                     *;
;*    last Update    :  04/08/89                                     *;
;*-------------------------------------------------------------------*;
;*    assembly       : MASM EXEC;                                    *;
;*                     LINK EXEC;                                    *;
;*-------------------------------------------------------------------*;
;*    Call           : EXEC                                          *;
;*********************************************************************;

;== data ==============================================================

data      segment para 'DATA'     ;Definition of the data-segment

prgname   db "\command.com",0     ;Name of the program to be called
prgpara   db "/c dir",0           ;Parameters passed to program

data      ends                    ;end of data-segment

;== code ==============================================================

code      segment para 'CODE'     ;Definition of the CODE-segment

          assume cs:code, ds:data, ss:stack

exec      proc far

          mov  ax,data            ;Load segment address of the data segment
          mov  ds,ax              ;into the DS-register

          call setfree            ;release unused memory

          mov  dx,offset prgname  ;offset address of program name 
          mov  si,offset prgpara  ;offset address of command line 
          call exeprg             ;Call program 

          mov  ax,4C00h           ;end program with call of a DOS function
          int  21h                ;on return of error-code 0
exec      endp

;-- SETFREE: Release memory not used  ----------------
;-- Input    : ES = address of PSP
;-- Output   : none
;-- Register : AX, BX, CL and FLAGS are changed 
;-- Info     : Since the stack-segment is always the last segment in an 
;              EXE-file, ES:0000 points to the beginning and SS:SP
;              to the end of the program in memory. Through this the
;              length of the program can be calculated 

setfree   proc near

          mov  bx,ss              ;first subtract the two segment addresses
          mov  ax,es              ;from each other. The result is
          sub  bx,ax              ;number of paragraphs from PSP
                                  ;to the beginning of the stack
          mov  ax,sp              ;since the stackpointer is at the end of
          mov  cl,4               ;the stack segment, its content indicates
          shr  ax,cl              ;the length of the stack
          add  bx,ax              ;add to current length
          inc  bx                 ;as precaution add another paragraph

          mov  ah,4ah             ;pass new length to DOS
          int  21h

          ret                     ;back to caller

setfree   endp

;-- EXEPRG: call another program  ------------------------------
;-- Input    : DS:DX = address of the Program Name
;--            DS:SI = address of the Command Line 
;-- Output   : carry flag = 1 : Error (AX = Error-code)
;-- Register : only AX and FLAGS are changed 
;-- Info     : Program name and Command Line must be ASCII-String
;--            and terminated with ASCII-code 0

exeprg    proc near

          ;Transmit Command Line into own buffer  --
          ;and count characters                               --

          push bx                 ;Store all registers which are
          push cx                 ;destroyed by the call to the
          push dx                 ;DOS EXEC function
          push di
          push si
          push bp
          push ds
          push es

          mov  di,offset comline+1 ;address of chars in Command Line.
          push cs                 ;CS to stack
          pop  es                 ;back as ES 
          xor  bl,bl              ;Set character count to 0
copypara: lodsb                   ;read a character 
          or   al,al              ;is it a NUL-code (end)
          je   copyend            ;Yes --> copied enough
          stosb                   ;store in new buffer 
          inc  bl                 ;increment character count 
          cmp  bl,126             ;Maximum reached?
          jne  copypara           ;No --> continue 

copyend:  mov  cs:comline,bl      ;store number of characters
          mov  byte ptr es:[di],13 ;finish command line

          mov  cs:merkss,ss       ;SS and SP must be stored in
          mov  cs:merksp,sp       ;variables in code segment 

          mov  bx,offset parblock ;ES:BX points to parameter block
          mov  ax,4B00h           ;function number for EXEC function 
          int  21h                ;Call DOS-function 

          cli                     ;Set interrupts for a moment from 
          mov  ss,cs:merkss       ;stack segment and stackpointer to 
          mov  sp,cs:merksp       ;their old values 
          sti                     ;Switch interrupt on again 

          pop  es                 ;Get all Registers from stack again 
          pop  ds
          pop  bp
          pop  si
          pop  di
          pop  dx
          pop  cx
          pop  bx

          jc   exeend             ;Errors? YES --> end
          mov  ah,4dh             ;no errors, sense end-code of the 
          int  21h                ;program which was executed 

exeend:   ret                     ;back to caller 

         ;-- Variables of this routine only addressable through CS --

merkss    dw (?)                  ;accepts SS during program call 
merksp    dw (?)                  ;accepts SP during program call 
parblock  equ this word           ;Parameter block for EXEC function 
          dw 0                    ;environment block
          dw offset comline       ;offset and segment address of
          dw seg code             ;modified Command Line 
          dd 0                    ;no data in PSP #1
          dd 0                    ;no data in PSP #2

comline   db 128 dup (?)          ;accepts modified Command Line 

exeprg    endp

;== stack ==========================================================

stack     segment para stack      ;Definition of the stack-segment

          dw 256 dup (?)          ;the stack has 256 Words 

stack     ends                    ;End of the stack-segment

;== End =============================================================

code      ends                    ;End of the CODE-segment
          end  exec               ;for execution start with EXEC 
