;**********************************************************************;
;*                             P R O C P A                            *;
;*--------------------------------------------------------------------*;
;*    Task           : Determines the type of processor installed in  *;
;*                     a PC.                                          *;
;*                     This version is converted by INLINE statements *;
;*                     and then used by a Pascal program.             *;
;*--------------------------------------------------------------------*;
;*    Author         : MICHAEL TISCHER                                *;
;*    Developed on   : 08/22/1988                                     *;
;*    Last update    : 05/24/1989                                     *;
;*--------------------------------------------------------------------*;
;*    assembly       : MASM PROCPA;                                   *;
;*                     LINK PROCPA;                                   *;
;*                     EXE2BIN PROCPA PROCPA.BIN                      *;
;*                     ... convert to INLINE statements and add to    *;
;*                         Pascal programs                            *;
;**********************************************************************;
                                                                        
                                                                        
;== Constants ==========================================================
                                                                        
p_80386   equ   7                 ;Codes for different types of 
p_80286   equ   6                 ;processors
p_80186   equ   5
p_80188   equ   4
p_v30     equ   3
p_v20     equ   2
p_8086    equ   1
p_8088    equ   0
                                                                        
;== Code ===============================================================
                                                                        
code      segment para 'CODE'     ;Definition of CODE segment
                                                                        
          org  100h
                                                                        
          assume cs:code, ds:code, ss:code, es:code
                                                                        
getproc   proc near               ;This program is the essential main
                                  ;program
                                                                        
          pushf                   ;Get contents of flag registers       
          push cx                 ;Get contents of all altered registers
          push dx                 ;and push them onto stack
          push di
          push si
          push es
                                                                        
          ;-- Test for 80386/80286 -------------------------------------
                                                                        
          xor  ax,ax              ;Set AX to 0
          push ax                 ;and push onto stack
          popf                    ;Pop into flag register from stack
          pushf                   ;Return to stack
          pop  ax                 ;And pop back into AX
          and  ax,0f000h          ;Avoid clearing the to 4 bits
          cmp  ax,0f000h          ;Are bits 12-15 all equal to 1?
          je   not_a_386          ;YES->Not an 80386 or an 80286
                                                                        
          ;-- Test whether to handle it as an 80386 or 80286 -----------
                                                                        
          mov  dl,p_80286         ;This narrows it down to one of
          mov  ax,07000h          ;the two processors
          push ax                 ;Push value 7000(h) onto the stack
          popf                    ;Pop off as flag register
          pushf                   ;and push it back onto the stack
          pop  ax                 ;Pop off and return to AX register
          and  ax,07000h          ;Avoid masking bits 12-14
          je   pende              ;Are bits 12-14 all equal to 0?
                                  ;YES->Handle it as an 80286
                                                                        
          inc  dl                 ;NO->Handle it as an 80386
          jmp  pende              ;End of test
                                                                        
          ;-- Test for 80186 or 80188 ----------------------------------
                                                                        
not_a_386 label near
                                                                        
          mov  dl,p_80188         ;Load code for 80188
          mov  al,0ffh            ;Set all bits in AL register to 1
          mov  cl,021h            ;Number of shift operations after CL
          shr  al,cl              ;Shift AL CL times to the right
          jne  t88_86             ;If AL is unequal to 0 it must be  
                                  ;handled as an 80188 or 80186
                                                                        
          ;-- Test for NEC V20 or V30 ----------------------------------
                                                                        
          mov  dl,p_v20           ;Load code for NEC V20
          sti                     ;Interrupts should be enabled starting
          mov  si,0               ;with the first byte in ES
          mov  cx,0ffffh          ;Read a complete segment
          rep  lods byte ptr es:[si]      ;REP w/ segment override only
                                  ;works with NEC V20 and V30 processors
          or   cx,cx              ;Has complete segment been read?
          je   t88_86             ;YES-> V20 or V30
                                                                        
          mov  dl,p_8088          ;NO-> Must be an 8088 or 8086
                                                                        
          ;-- Test for 8088 or 8086/V20 or V30 -------------------------
                                                                        
t88_86    label near
                                                                        
          push cs                 ;Push CS onto stack
          pop  es                 ;Pop off to ES
          std                     ;Using string inst. count backwards
          mov  al,0fbh            ;Instruction code for "STI"
          mov  cx,3               ;Execute string instruction 3 times
          call get_di             ;Get starting address of DI
t86_1:    cli                     ;Suppress interrupts
          rep  stosb
          cld                     ;Using string inst. count backwards
          nop                     ;Fill queue with dummy instruction
          nop
          nop
                                                                        
          inc  dx                 ;Increment processor code
          nop
q_end:    sti                     ;Re-enable interrupts
                                                                        
          ;-------------------------------------------------------------
                                                                        
pende     label near              ;End testing
                                                                        
          mov  [bp-1],dl          ;Place processor code in return var.
          pop  es                 ;Pop saved registers from
          pop  si                 ;stack
          pop  di
          pop  dx
          pop  cx
          popf                    ;Pop flag register from stack and    
          jmp  endit              ;Return to calling program
                                                                        
getproc   endp                    ;End of PROG procedure
                                                                        
;-- GET_DI examines DI for 88/86 test ----------------------------------
                                                                        
get_di    proc near
                                                                        
          pop  di                 ;Pop return address off of stack
          add  di,9               ;Take first 9 bytes from there
          jmp  t86_1              ;Return to the testing routine
                                                                        
endit     label near
                                                                        
get_di    endp
                                                                        
;== End ================================================================
                                                                        
code      ends                    ;End of CODE segment
          end  getproc
