;*********************************************************************;
;*                           R A M D I S K                           *;
;*-------------------------------------------------------------------*;
;*    Task        : This Program is a Driver for a 160KB             *;
;*                  RAM-Disk.                                        *;
;*-------------------------------------------------------------------*;
;*    Author         : MICHAEL TISCHER                               *;
;*    developed onm  :  8.4.87                                       *;
;*    last Update    : 9.21.87                                       *;
;*-------------------------------------------------------------------*;
;*    assembly       : MASM RAMDISK;                                 *;
;*                     LINK RAMDISK;                                 *;
;*                     EXE2BIN RAMDISK RAMDISK.SYS                   *;
;*-------------------------------------------------------------------*;
;*    Call         : Copy into Root Directory, enter the command     *;
;*                     DEVICE=RAMDISK.SYS into  the CONFIG.SYS file  *;
;*                     and then boot the System.                     *;
;*********************************************************************;

code     segment

         assume cs:code,ds:code,es:code,ss:code

         org 0                   ;Program has no PSP therefore begin 
	                            ;at the offset address 0

;== Constants ========================================================

cmd_fld   equ 2                  ;Offset command field in data block
status   equ 3                   ;Offset status field in data block
num_dev  equ 13                  ;Offset number of supported devices 
changed  equ 14                  ;Offset medium changed?
end_adr  equ 14                  ;Offset driver end-aAdr. in data block
b_adr    equ 14                  ;Offset buffer address in data block
num_cmd  equ 16                  ;the functions 0-16 are supported 
num_db   equ 18                  ;Offset number in data block
bpb_adr  equ 18                  ;Offset Address of BPB of the media
sector   equ 20                  ;Offset first sector number
dev_des  equ 22                  ;Offset device-description of RAM-Disk

;== Data  =============================================================

erst_b   equ this byte           ;this is the first byte of the driver

;-- Header of the Device-Driver ---------------------------------------

         dw -1,-1                ;Connection to next driver
         dw 0100100000000000b    ;Driver attribute
         dw offset strat         ;Pointer to strategy routine
         dw offset intr          ;Pointer to interrupt routine
         db 1                    ;a device is supported 
         db 7 dup (0)            ;these bytes give the name 

;-- Jump Table for the individual functions  -------------------------

fkt_tab  dw offset init          ;Function  0: Initialization 
         dw offset med_test      ;Function  1: Media Test
         dw offset get_bpb       ;Function  2: created BPB
         dw offset read          ;function  3: direct reading 
         dw offset read          ;Function  4: Read 
         dw offset dummy         ;Function  5: Read, remain in Buffer 
         dw offset dummy         ;Function  6: Input-Status
         dw offset dummy         ;Function  7: Erase Input-Buffer
         dw offset write         ;Function  8: Write 
         dw offset write         ;Function  9: Write & Verification 
         dw offset dummy         ;Function 10: Output-Status
         dw offset dummy         ;Function 11: Erase Output-Buffer
         dw offset write         ;Function 12: direct Write 
         dw offset dummy         ;Function 13: Open (after DOS 3.0)
         dw offset dummy         ;Function 14: Close 
         dw offset no_rem        ;Function 15: changeable Medium?
         dw offset write         ;Function 16: Output until Busy 

db_ptr   dw (?),(?)              ;Address of the data block passed 
rd_seg   dw (?)                  ;RD_SEG:0000 beginning of the RAM-Disk

bpb_ptr  dw offset bpb,(?)       ;Accepts the address of the BPB 

boot_sek db 3 dup (0)            ;normally a jump command to the boot
                                 ;Routine is stored here 
         db "MITI 1.0"           ;Name of creator & version number 
bpb      dw 512                  ;512 bytes per sector
         db 1                    ;1 Sector per cluster
         dw 1                    ;1 reserved sector (boot-sector)
         db 1                    ;1 File-Allocation-Table (FAT)
         dw 64                   ;maximum 64 entries in root directory 
         dw 320                  ;total of 320 sectors = 160 KB
         db 0FEh                 ;Media descriptor (1 Side with 40
                                 ;Tracks of 8 sectors each)
         dw 1                    ;every FAT occupies one sector

         ;-- the Boot routine not included since a System can not-----
         ;-- be booted from a RAM-Disk 

vol_name db "RAMDISK    "        ;the actual volume-name
         db 8                    ;Attribute, defines volume-name

;== Routines and functions of the Driver ==============================

strat    proc far                ;Strategy routine

         mov  cs:db_ptr,bx       ;Store address of the data block 
         mov  cs:db_ptr+2,es     ;in the Variable DB_PTR 

         ret                     ;back to caller 

strat    endp

;----------------------------------------------------------------------

intr     proc far                ;Interrupt routine

         push ax                 ;Store registers on the stack 
         push bx
         push cx
         push dx
         push di
         push si
         push bp
         push ds
         push es
         pushf                   ;also store flag register 

         push cs                 ;Set data segment register 
         pop  ds                 ;Code identical with data here 

         les  di,dword ptr db_ptr;Address of data block to ES:DI
         mov  bl,es:[di+cmd_fld] ;Get command-code 
         cmp  bl,num_cmd         ;is command-code permitted?
         jle  bc_ok              ;YES --> bc_ok

         mov  ax,8003h           ;Code for "unknown Command"
         jmp  short intr_end     ;back to caller 

         ;-- Command-Code was o.k. --> Execute Command ----------------

bc_ok:   shl  bl,1               ;Calculate pointer in jump table 
         xor  bh,bh              ;erase BH 
         call [fkt_tab+bx]       ;Call function 

         ;-- Execution of the function completed ---------------------

intr_end label near
         push cs                 ;Set data segment register 
         pop  ds                 ;Code is identical with data here 

         les  di,dword ptr db_ptr;Address of the data block to ES:DI
         or   ax,0100h           ;Set finished-bit 
         mov  es:[di+status],ax  ;store everything in the status field 

         popf                    ;Restore flag register 
         pop  es                 ;restore other registers 
         pop  ds
         pop  bp
         pop  si
         pop  di
         pop  dx
         pop  cx
         pop  bx
         pop  ax

         ret                     ;back to caller 

intr     endp

;----------------------------------------------------------------------

init     proc near               ;Initialization routine

         ;-- the following code is overwritten after the installation -
         ;-- by the RAM-Disk 

         ;-- determine Device designation of the RAM-Disk ------------

         mov  ah,30h             ;Sense DOS Version with function 30(h)
         int  21h                ;of DOS-interrupt 21(h) 
         cmp  al,3               ;is it Version 3 or higher ?
         jb   prinm              ;YES --> PRINM

         mov  al,es:[di+dev_des] ;Get device designation 
         add  al,"A"             ;convert to letters 
         mov  im_ger,al          ;store in installation message 

prinm:   mov  dx,offset initm    ;Address of installation message
         mov  ah,9               ;output function number for string 
         int  21h                ;Call DOS-interrupt 

         ;-- Calculate Address of the first byte after the RAM-Disk --
         ;-- and set as End Address of the Driver 

         mov  word ptr es:[di+end_adr],offset ramdisk+8000h
         mov  ax,cs                      ;Size of RAM-Disk is 32KB plus
         add  ax,2000h                   ;2 * 64KB 
         mov  es:[di+end_adr+2],ax
         mov  byte ptr es:[di+num_dev],1          ;1 device supported 
         mov  word ptr es:[di+bpb_adr],offset bpb_ptr ;Address of the
         mov  es:[di+bpb_adr+2],ds                    ;BPB-Pointer

         mov  ax,cs              ;Segment address of RAM-Disk beginning
         mov  bpb_ptr+2,ds       ;Segment address of BPB in BPB-Pointer
         mov  dx,offset ramdisk  ;calculate to offset address 0 
         mov  cl,4               ;Divide offset address by 16 and thus 
         shr  dx,cl              ;convert into segment address 
         add  ax,dx              ;add the two segment addresses 
         mov  rd_seg,ax          ;and store 

         ;-- Create Boot-Sector ---------------------------------------

         mov  es,ax              ;transfer segment address to ES 
         xor  di,di              ;Boots. begins with the 1. byte of RD
         mov  si,offset boot_sek ;Address of the boot-sector in memory 
         mov  cx,15              ;only the first 15 words are used 
         rep  movsw              ;copy boot-sector into RAM-Disk 

         ;-- Create FAT -------------------------------------------

         mov  di,512             ;FAT begins with the byte 512 of RD
         mov  al,0FEh            ;Write media-descriptor into the first 
         stosb                   ;byte of the FAT 
         mov  ax,0FFFFH          ;Store code for bytes 2 and 3 of FAT
         stosw                   ;in FAT 
         mov  cx,236             ;remaining 236 words occupied by FAT
         inc  ax                 ;Set AX to 0 
         rep  stosw              ;Set all FAT-entries to unoccupied 

         ;-- Create Root Directory with Volume-Name -------------

         mov  di,1024            ;Root Directory starts in 3rd Sector
         mov  si,offset vol_name ;Address of volume-name in memory 
         mov  cx,6               ;the volume-name is 6 words long 
         rep  movsw              ;Copy volume-name into RD 

         mov  cx,1017            ;Fill the rest of the directories in
         xor  ax,ax              ;Sectors 2, 3, 4 and 5 with zeros 
         rep  stosw

         xor  ax,ax              ;everything o.k.
         ret                     ;back to caller 

init     endp

;----------------------------------------------------------------------

dummy    proc near               ;This Routine does nothing 

         xor  ax,ax              ;Erase busy-bit 
         ret                     ;back to caller 

dummy    endp

;----------------------------------------------------------------------

med_test proc near               ;Media of RAM-Disk 
                                 ;can not be changed 

         mov  byte ptr es:[di+changed],1
         xor  ax,ax              ;Erase busy-bit 
         ret                     ;back to caller 

med_test endp

;----------------------------------------------------------------------

get_bpb  proc near               ;Pass address of BPB to DOS 

         mov  word ptr es:[di+bpb_adr],offset bpb
	 mov  word ptr es:[di+bpb_adr+2],ds

         xor  ax,ax              ;Erase busy-bit 
         ret                     ;back to caller 

get_bpb  endp

;----------------------------------------------------------------------

no_rem   proc near               ;Media of RAM-Disk can not be changed
         mov  ax,20              ;Set busy-bit 
         ret                     ;back to caller 

no_rem   endp

;----------------------------------------------------------------------

write proc near

         xor  bp,bp              ;Transmission DOS --> RAM-Disk
         jmp  short move         ;Copy data 

write endp

;----------------------------------------------------------------------

read    proc near

         mov  bp,1               ;Transmission RAM-Disk --> DOS

read    endp

;-- MOVE: Move a certain number of sectors between RD and DOS 
;-- Input  : BP = 0 : transmit from DOS to RD (Write)
;--                 1 : transmit from RD to DOS (Read)
;-- Output  : none
;-- Registers : AX, BX, CX, DX, SI, DI, ES, DS and FLAGS are changed 
;-- Info     : Information required (number, first sector)
;--            is taken from the data block passed by DOS

move     proc near

         mov  bx,es:[di+num_db]  ;Number of sectors read 
         mov  dx,es:[di+Sector]  ;Number of first sector
         les  di,es:[di+b_adr]   ;Address of buffer to ES:DI

move_1:  or   bx,bx              ;More sectors to read ?
         je   move_e             ;No more sectors --> END
         mov  ax,dx              ;Sector number to AX
         mov  cl,5               ;Calculate number of paragraphs
         shl  ax,cl              ;(Segment units) by Multiplication
         add  ax,cs:rd_seg       ;with 32, add to Segment start of RD 
         mov  ds,ax              ;transmit to DS 
         xor  si,si              ;Offset address is 0
         mov  ax,bx              ;Number of sectors to be read to AX
         cmp  ax,128             ;more than 128 sectors to read 
         jbe  move_2             ;NO --> read all sectors 
         mov  ax,128             ;YES --> read 128 sectors (64 KB) 
move_2:  sub  bx,ax              ;subtract number of sectors read 
         add  dx,ax              ;add to sectorsto be read next 
         mov  ch,al              ;Number  sect. to be read * 256 words
         xor  cl,cl              ;Set Lo-byte of word-counter to 0 
         or   bp,bp              ;Should be read ?
         jne  move_3             ;NO --> MOVE_3
         mov  ax,es              ;Store ES in AX 
         push ds                 ;Store DS on the stack 
         pop  es                 ;read ES 
         mov  ds,ax              ;ES and DS are reversed now 
         xchg si,di              ;exchange SI and DI 
move_3:  rep  movsw              ;copy data into DOS-buffer 
         or   bp,bp              ;read ?
         jne  move_1             ;NO --> maybe other sectors to copy
         mov  ax,es              ;Store ES in AX 
         push ds                 ;Store DS on the stack 
         pop  es                 ;read ES 
         mov  ds,ax              ;ES and DS have been exchanged 
         xchg si,di              ;exchange SI and DI again 
         jmp  short move_1       ;additional sectors to copy

move_e:  xor  ax,ax              ;everything o.k.
         ret                     ;back to caller 

move     endp

;-- RAM-Disk starts here ----------------------------

    if ($-erst_b) mod 16         ;must start on a memory address 
      org ($-erst_b) + 16 - (($-erst_b) mod 16) ; divisible by 16
    endif
ramdisk  equ this byte

initm    db "**** 160 KB RAMDISK as Device"
im_ger   db "?"
         db ": installed (c) 1987 by MICHAEL TISCHER$",13,10,10

;----------------------------------------------------------------------

code     ends
         end

