100 '***************************************************************'
110 '*                     D I S K M O N B                         *'
120 '*-------------------------------------------------------------*'
130 '*  Task           : Diskmon is a small Diskette monitor based *'
140 '*                   on the BIOS-Interrupt 13(h)               *'
150 '*  Author         : MICHAEL TISCHER                           *'
160 '*  developed on   : 7.24.87                                   *'
170 '*  last Update    : 9.21.87                                   *'
180 '***************************************************************'
190 '
200 CLS : KEY OFF
210 PRINT"WARNING: This Program should only be started if GWBASIC was "
220 PRINT"started from the DOS level with <GWBASIC  /m60000>."
230 PRINT : PRINT"If this was not the case, please input <s> for Stop."
240 PRINT"Else press any key ...";
250 A$ = INKEY$ : IF A$ = "s" THEN END
260 IF A$ = "" THEN 250
270 DIM SECTOR%[255]  'accepts Sectors to be read or written
280 DIM FD%[29]       'Formatting data (maximum 0-29 = 30 Words)
290 GOSUB 60000       'Initialize Interrupt-Routine 
300 CLS               'Clear Screen 
310 KEY OFF           'Turn off Function key assignment 
320 COLOR 0,7        'dark characters on light background (invers)
330 PRINT" DISKMON (c) 1987 by Michael Tischer               ? = Help "
340 COLOR 7,0        'light characters on dark background
350 VIEW PRINT 2 TO 25       'Lines 2 to 25 form a window 
360 DR% = 0                  'access unit 0 (A) first 
370 SIDE% = 0                'access the first Diskette side 
380 FTYP% = 3                '1.2 MB Diskettes in 1.2 MB drive 
390 DEF SEG = &HF000         'Set BIOS-Segment 
400 IF PEEK(&HFFFE) = &HFC THEN AT% = - 1 ELSE AT% = 0     'test if AT
410 DEF SEG                  'Set BIOS-Segment again 
420 GOSUB 50000              'Execute Reset 
430 GOSUB 51000              'Output Error message if necessary 
440 INPUT"DISK-MON>",E$      'User input prompt 
450 IF E$ = "" THEN 440      'no input  --> repeat input prompt 
460 IF E$ = "?" THEN GOSUB 53000 : GOTO 440       'Display Help-Text 
470 IF E$ = "r" THEN GOTO 420                     'Reset
480 IF E$ = "s" THEN GOSUB 54000 : GOTO 430       'fill a Sector 
490 IF E$ = "f" THEN GOSUB 55000 : GOTO 430       'format a Track 
500 IF E$ = "g" THEN GOSUB 56000 : GOTO 430    'Read Sector and display
510 IF E$ = "c" THEN GOSUB 57000 : GOTO 440         'Input Constants 
520 IF E$ = "e" THEN VIEW PRINT 1 TO 25: CLS : END    'End Program
530 PRINT"unknown Command!" : GOTO 440
540 '
50000 '***************************************************************'
50010 '* Execute Reset of all Disk drives                            *'
50020 '*-------------------------------------------------------------*'
50030 '* Input: none                                                 *'
50040 '* Output: DST% = the Diskette-Status                          *'
50050 '* Info   : Z% is a Dummy-Variable                             *'
50060 '***************************************************************'
50070 '
50080 DST% = 0                  'Function number for Reset
50090 INR% = &H13               'Call BIOS-Diskette-Interrupt 13(h) 
50100 CALL IA(INR%,DST%,Z%,Z%,Z%,Z%,Z%,Z%,Z%,Z%,Z%,Z%,Z%)
50110 RETURN                    'back to caller 
50120 '
51000 '***************************************************************'
51010 '* Output Error Message based on the Diskette-Status           *'
51020 '*-------------------------------------------------------------*'
51030 '* Input: DST% = Status of the last Diskette operation         *'
51040 '* Output: none                                                *'
51050 '***************************************************************'
51060 '
51070 IF DST% = 0 THEN RETURN     '0 = everything o.k.
51080 PRINT "ERROR: ";
51090 IF DST% = &H1 THEN PRINT"Function number not allowed " : GOTO 50000
51100 IF DST% = &H2 THEN PRINT"Address-Marking not found" : GOTO 50000
51110 IF DST% = &H3 THEN PRINT"Write attempt on protected Disk" : GOTO 50000
51120 IF DST% = &H4 THEN PRINT"Sector not found" : GOTO 50000
51130 IF DST% = &H6 THEN PRINT"Diskette changed" : GOTO 50000
51140 IF DST% = &H8 THEN PRINT"DMA Overrun" : GOTO 50000
51150 IF DST% = &H9 THEN PRINT"Data transmission beyond segment border" : GOTO 50000
51160 IF DST% = &H10 THEN PRINT"Read Error" : GOTO 50000
51170 IF DST% = &H20 THEN PRINT"Error of Disk-Controller" : GOTO 50000
51180 IF DST% = &H40 THEN PRINT"Track not found" : GOTO 50000
51190 IF DST% = &H80 THEN PRINT"Time Out Error" : GOTO 50000
51200 PRINT"Error ";DST%;" unknown" : GOTO 50000
51210 '
53000 '***************************************************************'
53010 '* Display Help-Text on the screen                             *'
53020 '*-------------------------------------------------------------*'
53030 '* Input: none                                                 *'
53040 '* Output: none                                                *'
53050 '***************************************************************'
53060 '
53070 PRINT
53080 PRINT"C O M M A N D   O V E R V I E W"
53090 PRINT"-------------------------------"
53100 PRINT"e = End"
53110 PRINT"g = Get (Read)"
53120 PRINT"s = Sector fill"
53130 PRINT"r = Reset"
53140 PRINT"f = Format"
53150 PRINT"c = Constants"
53160 PRINT"? = Help"
53170 PRINT
53180 RETURN                                        'back to caller 
53190 '
54000 '***************************************************************'
54010 '* Fill a Sector                                               *'
54020 '*-------------------------------------------------------------*'
54030 '* Input: DR%    = the Number of the unit addressed            *'
54040 '*          SIDE% = the number of the Disk side addressed      *'
54050 '* Output: DST%   = the Diskette status                        *'
54060 '* Info   : Z% is a Dummy-Variable                             *'
54070 '***************************************************************'
54080 '
54090 INPUT "Track  : ",TRACK%    'Track in which the Sector is located 
54100 INPUT "Sector : ",SECTOR%   'Sector to be filled 
54110 INPUT "Character: ",Z$      'Fill Character 
54120 IF Z$ = "" THEN Z$ = CHR$(0)
54130 FOR I% = 0 TO 511 : POKE VARPTR(SECTOR%[0])+I%,ASC(Z$) : NEXT
54140 DST% = 3                    'Function number for writing 
54150 INR% = &H13                 'Call BIOS-Diskette-Interrupt 13(h) 
54160 NUM% = 1                    'Number of Sectors 
54170 OFSLO% = 0 : OFSHI% = 0     'initialize Variables 
54180 SEG% = -1                   'Use BASIC DS for ES 
54190 NUM% = 1                    'Number of Sectors to be read 
54200 OFSLO% = VARPTR(SECTOR%[0]) AND 255  'LO & HI-Byte of the Offset
54210 OFSHI% = INT(VARPTR(SECTOR%[0]) / 256)'addresse of Var. SECTOR%[0]
54220 CALL IA(INR%,DST%,NUM%,OFSHI%,OFSLO%,TRACK%,SECTOR%,SIDE%,DR%, Z%,Z%,SEG%,Z%)
54230 RETURN                                        'back to caller 
54240 '
55000 '***************************************************************'
55010 '* Format a Track                                              *'
55020 '*-------------------------------------------------------------*'
55030 '* Input: DR%    = the number of the unit                      *'
55040 '*          SIDE% = the number of the disk side                *'
55050 '*          FTYP%  = Type of Disk drive                        *'
55060 '*          AT%    = -1 if computer is an AT, otherwise 0      *'
55070 '* Output: DST%   = the Diskette status                        *'
55080 '* Info   : Z% is a  Dummy-Variable                            *'
55090 '***************************************************************'
55100 '
55110 IF NOT(AT%) THEN 55150 'if not AT, then no format fitting 
55120 FKT% = &H17            'Set Function number for DASD Type
55130 INR% = &H13            'Call BIOS-Diskette-Interrupt 13(h) 
55140 CALL IA(INR%,FKT%,FTYP%,Z%,Z%,Z%,Z%,Z%,DR%,Z%,Z%,Z%,Z%)
55150 INPUT "Track  : ",TRACK%  'Number of Track to be formatted 
55160 INPUT "Number Sectors: ",NUM%  'Number of Sectors to be installed 
55170 IF NUM% > 15 THEN 55160   'maximum of 15 Sectors can be installed 
55180 FOR I% = 0 TO NUM%-1      'one entry for every Sector
55190 POKE VARPTR(FD%[0])+I%*4,TRACK%       'Enter number of Track 
55200 POKE VARPTR(FD%[0])+I%*4+1,SIDE%      'Enter number of side 
55210 POKE VARPTR(FD%[0])+I%*4+2,I%+1       'Enter Sector number 
55220 POKE VARPTR(FD%[0])+I%*4+3,2        'Format Sector with 512 Bytes 
55230 NEXT                      'Process Entry for next Sector 
55240 DST% = 5                  'Function number for Formatting 
55250 INR% = &H13               'Call BIOS-Diskette-Interrupt 13(h) 
55260 OFSLO% = 0 : OFSHI% = 0   'initialize Variables 
55270 SEG% = -1                 'Use BASIC DS for ES 
55280 OFSLO% = VARPTR(FD%[0]) AND 255      'LO and HI-Byte of Offset
55290 OFSHI% = INT(VARPTR(FD%[0]) / 256)   'address of Var. FD%[0]
55300 CALL IA(INR%,DST%,NUM%,OFSHI%,OFSLO%,TRACK%,Z%,SIDE%,DR%, Z%,Z%,SEG%,Z%)
55310 RETURN                                        'back to caller 
55320 '
56000 '***************************************************************'
56010 '* read a Sector and display                                   *'
56020 '*-------------------------------------------------------------*'
56030 '* Input: DR%    = the Number of the drive to be accessed      *'
56040 '*          SIDE% = the number of the Diskette side            *'
56050 '* Output: DST%   = the Diskette status                        *'
56060 '* Info   : Z% is a Dummy-Variable                             *'
56070 '***************************************************************'
56080 '
56090 INPUT "Track  : ",TRACK%  'Track in which the Sector is located 
56100 INPUT "Sector: ",SECTOR%  'the Sector to be filled 
56110 DST% = 2                  'Function number for reading 
56120 INR% = &H13               'Call BIOS-Diskette-Interrupt 13(h) 
56130 NUM% = 1                  'Read a Sector 
56140 OFSLO% = 0 : OFSHI% = 0   'Create Variables 
56150 SEG% = -1                 'Use BASIC DS for ES 
56160 OFSLO% = VARPTR(SECTOR%[0]) AND 255   'LO and HI-Byte of Offset
56170 OFSHI% = INT(VARPTR(SECTOR%[0]) / 256)'address of the Var. SECTOR%[0]
56180 CALL IA(INR%,DST%,NUM%,OFSHI%,OFSLO%,TRACK%,SECTOR%,SIDE%,DR%, Z%,Z%,SEG%,Z%)
56190 IF DST% <> 0 THEN RETURN        'on error do not output data 
56200 PRINT STRING$(80,"-");
56210 FOR I% = 0 TO 511  'process all Bytes of the Sector read 
56220 Z% = PEEK(VARPTR(SECTOR%[0]) + I%)  'get a Byte from the Sector 
56230 IF Z% = 0 THEN PRINT "<NUL>"; : GOTO 56350
56240 IF Z% = 7 THEN PRINT "<BEL>"; : GOTO 56350
56250 IF (Z% = 8) OR (Z% = 29) THEN PRINT "<BS>"; : GOTO 56350
56260 IF Z% = 9 THEN PRINT "<TAB>"; : GOTO 56350
56270 IF Z% = 10 THEN PRINT "<LF>"; : GOTO 56350
56280 IF Z% = 11 THEN PRINT "<HOM>"; : GOTO 56350
56290 IF Z% = 12 THEN PRINT "<FF>"; : GOTO 56350
56300 IF Z% = 13 THEN PRINT "<CR>"; : GOTO 56350
56310 IF Z% = 27 THEN PRINT "<ESC>"; : GOTO 56350
56320 IF Z% = 30 THEN PRINT "<CUP>"; : GOTO 56350
56330 IF Z% = 31 THEN PRINT "<CDN>"; : GOTO 56350 
56340 PRINT CHR$(Z%);                   'output Byte as ASCII character 
56350 NEXT                              'output next Byte 
56360 PRINT
56370 PRINT STRING$(80,"-");
56380 RETURN                                       'back to caller 
56390 '
57000 '*************************************************************'
57010 '* Input Constants (Unit number, Diskette side, etc.)        *'
57020 '*-----------------------------------------------------------*'
57030 '* Input: AT%    = -1 if computer is an AT, else 0           *'
57040 '* Output: DR%    = Number of unit to be accessed            *'
57050 '*          SIDE% = Number of disk. side                     *'
57060 '*          FTYP%  = Type of Disk drive                      *'
57070 '**************************************************************'
57080 '
57090 INPUT "Unit-Number (0-3)   : ",DR%
57100 INPUT "Diskette side (0 or 1): ",SIDE%
57110 IF NOT(AT%) THEN RETURN    'Diskette format only for AT 
57120 PRINT"Formatting Parameter:"
57130 PRINT"  1 = 320/360 KB diskette in 320/360 KB Drive"
57140 PRINT"  2 = 320/360 KB diskette in 1.2 MB Drive"
57150 INPUT"  3 = 1.2 MB diskette in 1.2 MB Drive -- Please input: ",FTYP%
57160 RETURN                                        'back to caller 
57170 '
60000 '***************************************************************'
60010 '* initialize the Routine for Interrupt call                   *'
60020 '*-------------------------------------------------------------*'
60030 '* Input: none                                                 *'
60040 '* Output: IA is the Start address of the Interrupt-Routine    *'
60050 '***************************************************************'
60060 '
60070 IA=60000!      'Start address of the Routine in the BASIC-Segment
60080 DEF SEG        'Set BASIC-Segment 
60090 RESTORE 60130
60100 FOR I% = 0 TO 160 : READ X% : POKE IA+I%,X% : NEXT  'Poke Routine 
60110 RETURN         'back to caller 
60120 '
60130 DATA  85,139,236, 30,  6,139,118, 30,139,  4,232,140,  0,139,118
60140 DATA  12,139, 60,139,118,  8,139,  4, 61,255,255,117,  2,140,216
60150 DATA 142,192,139,118, 28,138, 36,139,118, 26,138,  4,139,118, 24
60160 DATA 138, 60,139,118, 22,138, 28,139,118, 20,138, 44,139,118, 18
60170 DATA 138, 12,139,118, 16,138, 52,139,118, 14,138, 20,139,118, 10
60180 DATA 139, 52, 85,205, 33, 93, 86,156,139,118, 12,137, 60,139,118
60190 DATA  28,136, 36,139,118, 26,136,  4,139,118, 24,136, 60,139,118
60200 DATA  22,136, 28,139,118, 20,136, 44,139,118, 18,136, 12,139,118
60210 DATA  16,136, 52,139,118, 14,136, 20,139,118,  8,140,192,137,  4
60220 DATA  88,139,118,  6,137,  4, 88,139,118, 10,137,  4,  7, 31, 93
60230 DATA 202, 26,  0, 91, 46,136, 71, 66,233,108,255
