/*******************************************************************/
/*                              P R I N T C                        */
/*-----------------------------------------------------------------*/
/*    Task        : Makes a function available for sending a       */
/*                     string to a printer. If any errors occur    */
/*                     during printing, the program will display   */
/*                     errors on the screen                        */
/*-----------------------------------------------------------------*/
/*    Author         : MICHAEL TISCHER                             */
/*    developed on   : 8/13/87                                     */
/*    last update    : 6/09/89                                     */
/*-----------------------------------------------------------------*/
/*    (MICROSOFT C)                                                */
/*    Creation     : MSC PRINTC                                    */
/*                     LINK PRINTC;                                */
/*    Call         : PRINTC                                        */
/*-----------------------------------------------------------------*/
/*    (BORLAND TURBO C)                                            */
/*    Creation      : with the RUN command in the command line     */
/*******************************************************************/

#include <dos.h>                           /* include header files */
#include <io.h>

/*== Type definitions =============================================*/

typedef unsigned char byte;                       /* Create a byte */
#define FALSE 0                  /* Constants make reading of the  */
#define TRUE 1                    /* program text easier           */

/********************************************************************/
/* PRINTERROR: displays error message                               */
/* Input : 0 stands for o.k., else error code                       */
/* Output : TRUE  if no error is displayed, else FALSE              */
/********************************************************************/

byte PrintError(Status)
int Status;                                       /* Printer status */

{
 if (Status)                                /* Did an error occur ? */
  {                                                          /* YES */
   printf("Error during printer access:");
   if (Status & 1)                               /* Time-Out Error? */
    printf("Time-Out Error\n");                              /* YES */
     else if (Status & 8)                             /* I/O error? */
      printf("I/O error\n");                                 /* YES */
       else if (Status & 32)                     /* No more paper ? */
        printf("no more paper\n");                           /* YES */
         else printf("Error unknown\n");
   return(FALSE);
  }
 else return(TRUE);                               /* Error detected */
}

/********************************************************************/
/* PRINTCHARACTER: sends a character to the printer                 */
/* Input : see below                                                */
/* Output : FALSE if no error occurred, else                        */
/*          error number                                            */
/********************************************************************/

byte PrintCharacter(Character, Printer)
char Character;                         /* The character for output */
unsigned int Printer;           /* Number of the designated printer */

{
 union REGS Register;      /* Register variables for interrupt call */

 Register.h.ah = 0;       /* Function number for character printing */
 Register.h.al = Character;                       /* Character code */
 Register.x.dx = Printer;                         /* Printer number */
 int86(0x17, &Register, &Register);  /* call BIOS printer interrupt */
 return(Register.h.ah & 0x29);             /* Leave only error bits */
}

/********************************************************************/
/* PRINTSTRING: sends a string to the selected printer              */
/* Input : see below                                                */
/* Output : FALSE, if no error occurred, else                       */
/*          error number                                            */
/********************************************************************/

byte PrintString(Text, Printer)
char *Text;               /* String to be output (character vector) */
unsigned int Printer;                      /* Number of the printer */

{
 byte Status;                                 /* The printer status */

 Status = FALSE;                   /* Initialize if string is empty */

 /* Output string until end is reached or error occurs during output*/
 while (*Text && !(Status = PrintCharacter(*Text++, Printer)))
  ;
 return(Status);
}

/********************************************************************/
/* INITPRINTER: initialize the printer interface                    */
/* Input : see below                                                */
/* Output : FALSE if no error occurred, else                        */
/*          error number                                            */
/********************************************************************/

byte InitPrinter(Printer)
int Printer;                 /* Printer interface to be initialized */

{
 union REGS Register;      /* Register variables for interrupt call */

 Register.h.ah = 2;                     /* Function number for Init */
 Register.x.dx = Printer ;              /* Printer/interface number */
 int86(0x17, &Register, &Register);  /* Call BIOS printer interrupt */
 return(Register.h.ah & 0x29);             /* Leave only error bits */
}

/*******************************************************************/
/**                           MAIN PROGRAM                        **/
/*******************************************************************/

void main()

{
 printf("\nPRINT (c) 1987 by Michael Tischer\n\n");
 printf("If a parallel printer is interfaced to this PC\n");
 printf(" the following text should appear soon:\n\n");
 printf("a test of the printer routines...\n\notherwise ");
 printf("an error message is displayed on the monitor screen.\n\n");
 if (PrintError(InitPrinter(0)))
  PrintError(PrintString("a test of the printer routines...\r\n"),0);

}
