
/*********************************************************************/
/*                                V I D E O C                        */
/*-------------------------------------------------------------------*/
/*    Task           : makes functions available which are not       */
/*                     available from the Library of MICROSOFT and   */
/*                     the TURBO C-Compilers                         */
/*-------------------------------------------------------------------*/
/*    Author         : MICHAEL TISCHER                               */
/*    developed on   : 08/13/87                                      */
/*    last Update    : 05/14/89                                      */
/*-------------------------------------------------------------------*/
/*    (MICROSOFT C)                                                  */
/*    Creation       : MSC VIDEOC;                                   */
/*                     LINK VIDEOC;                                  */
/*    Call           : VIDEOC                                        */
/*-------------------------------------------------------------------*/
/*    (BORLAND TURBO C)                                              */
/*    Creation       : through the RUN command on the menu bar       */
/*********************************************************************/

#include <dos.h>                             /* include Header-Files */
#include <io.h>

#define NORMAL        0x07  /* Definition of the character Attribute */
#define BOLD          0x0F            /* in relation to a monochrome */
#define INVERS        0x70                           /* Display card */
#define UNDERLINE     0x01
#define BLINK         0x80

/*********************************************************************/
/* GETVIDEOMODE: Read current Video mode and Parameters              */
/* Input       : none                                                */
/* Output      : see below                                           */
/*********************************************************************/

void GetVideoMode(VideoMode, Number, Page)
int *VideoMode;                      /* the Number of the Video mode */
int *Number;                           /* Number of Columns per line */
int *Page;                         /* Number of current display page */

{
 union REGS Register;        /* Register variable for Interrupt-Call */

 Register.h.ah = 15;                              /* Function number */
 int86(0x10, &Register, &Register);          /* Call Interrupt 10(h) */
 *VideoMode = Register.h.al;                 /* Number of Video mode */
 *Number = Register.h.ah;           /* Number of Characters per line */
 *Page = Register.h.bh;            /* Number of current display page */
}

/*********************************************************************/
/* SETCURSORTYPE: defines the appearance of the blinking display     */
/*                cursor                                             */
/* Input        : see below                                          */
/* Output       : none                                               */
/* Info         : for a monochrome display card the parameters       */
/*                can be between 0 and 13. For a color               */
/*                display card between 0 and 7                       */
/*********************************************************************/

void SetCursorType(Beginline, Endl)
int Beginline;                       /* Beginning line of the cursor */
int Endl;                                  /* End line of the cursor */

{
 union REGS Register;        /* Register variable for Interrupt-Call */

 Register.h.ah = 1;                               /* Function number */
 Register.h.ch = Beginline;              /* Beginning line of cursor */
 Register.h.cl = Endl;                         /* End line of cursor */
 int86(0x10, &Register, &Register);          /* Call Interrupt 10(h) */
}

/*********************************************************************/
/* SETCURSORPOS: defines the position of the cursor in the indicated */
/*               display page                                        */
/* Input       : see below                                           */
/* Output      : none                                                */
/* Info        : The position of the blinking display cursor changes */
/*               only if the call of this function refers to         */
/*               current display page                                */
/*********************************************************************/

void SetCursorPos(Page, Column, Line)
int Page;               /* Display page where the cursor will be set */
int Column;                                     /* new cursor Column */
int Line;                                         /* new cursor line */

{
 union REGS Register;        /* Register variable for Interrupt-Call */

 Register.h.ah = 2;                               /* Function number */
 Register.h.bh = Page;                               /* Display page */
 Register.h.dh = Line;                               /* Display line */
 Register.h.dl = Column;                           /* Display Column */
 int86(0x10, &Register, &Register);          /* Call Interrupt 10(h) */
}

/*********************************************************************/
/* GETCURSORPOS: Get the position of the cursor in a certain         */
/*               display page and its start and end line             */
/* Input       : none                                                */
/* Output      : see below                                           */
/*********************************************************************/

void GetCursorPos(Page, Column, Line, Beginline, Endl)
int Page;                                  /* Number of display page */
int *Column;                  /* Column, where the cursor is located */
int *Line;                      /* Line, where the cursor is located */
int *Beginline;                          /* Start line of the cursor */
int *Endl;                                 /* End line of the cursor */

{
 union REGS Register;        /* Register variable for Interrupt-Call */

 Register.h.ah = 3;                               /* Function number */
 Register.h.bh = Page;                               /* Display page */
 int86(0x10, &Register, &Register);          /* Call Interrupt 10(h) */
 *Column = Register.h.dl;             /* Read result of the Function */
 *Line = Register.h.dh;                        /* from the Registers */
 *Beginline = Register.h.ch;                 /* and assign to proper */
 *Endl = Register.h.cl;                                 /* Variables */
}

/*********************************************************************/
/* SETDISPLAYPAGE: sets the display Page which is to be represented  */
/*                 on the display                                    */
/* Input         : see below                                         */
/* Output        : none                                              */
/*********************************************************************/

void SetDisplayPage(Page)
int Page;                  /* Number of the new current display page */

{
 union REGS Register;        /* Register variable for Interrupt call */

 Register.h.ah = 5;                               /* Function number */
 Register.h.al = Page;                               /* Display page */
 int86(0x10, &Register, &Register);          /* Call Interrupt 10(h) */
}

/*********************************************************************/
/* SCROLLUP: Scrolls a display area up one or several                */
/*           lines or erases it                                      */
/* Input   : see below                                               */
/* Output  : none                                                    */
/* Info    : If 0 is passed as number, the display                   */
/*           area is filled with blanks                              */
/*********************************************************************/

void ScrollUp(Number, Color, ColumnUL, LineUL, ColumnLR, LineLR)
int Number;                        /* Number of lines to be scrolled */
int Color;                 /* Color or Attribute for the blank lines */
int ColumnUL;     /* Column in upper left corner of the display area */
int LineUL;         /* Line in upper left corner of the display area */
int ColumnLR;    /* Column in lower right corner of the display area */
int LineLR;        /* Line in lower right corner of the display area */

{
 union REGS Register;        /* Register variable for Interrupt call */

 Register.h.ah = 6;                               /* Function number */
 Register.h.al = Number;                          /* Number of lines */
 Register.h.bh = Color;                    /* Color of blank line(s) */
 Register.h.ch = LineUL;                   /* Set Coordinates of the */
 Register.h.cl = ColumnUL;          /* display Window to be scrolled */
 Register.h.dh = LineLR;                                /* or erased */
 Register.h.dl = ColumnLR;
 int86(0x10, &Register, &Register);          /* Call Interrupt 10(h) */
}

/*********************************************************************/
/* SCROLLDOWN: Scroll a display area by one or more                  */
/*             lines down or erase it                                */
/* Input     : see below                                             */
/* Output    : none                                                  */
/* Info      : If 0 is passed as number, the display                 */
/*             area is filled with blanks                            */
/*********************************************************************/

void ScrollDown(Number, Color, ColumnUL, LineUL, ColumnLR, LineLR)
int Number;                        /* Number of lines to be scrolled */
int Color;                 /* Color or Attribute for the blank lines */
int ColumnUL;     /* Column in upper left corner of the display area */
int LineUL;         /* Line in upper left corner of the display area */
int ColumnLR;    /* Column in lower right corner of the display area */
int LineLR;        /* Line in lower right corner of the display area */

{
 union REGS Register;        /* Register variable for Interrupt call */

 Register.h.ah = 7;                               /* Function number */
 Register.h.al = Number;                          /* Number of lines */
 Register.h.bh = Color;                    /* Color of blank line(s) */
 Register.h.ch = LineUL;                  /* Set Coordinates for the */
 Register.h.cl = ColumnUL;                   /* display window to be */
 Register.h.dh = LineLR;                       /* scrolled or erased */
 Register.h.dl = ColumnLR;
 int86(0x10, &Register, &Register);          /* Call Interrupt 10(h) */
}

/*********************************************************************/
/* GETCHAR: Read from a designated display position                  */
/*          a character and its Attribute-Byte                       */
/* Input  : see below                                                */
/* Output : see below                                                */
/*********************************************************************/

void GetChar(Page, Column, Line, Character, Color)
int Page;     /* Display page from which the character is to be read */
int Column;                       /* Display column of the character */
int Line;                           /* Display line of the character */
char *Character;                   /* the character at this position */
int *Color;                            /* its Attribute-Byte (Color) */

{
 union REGS Register;        /* Register variable for Interrupt call */
 int Dummy;                  /* for Variables which are not required */
 int CurPage;                            /* the current display page */
 int CurLine;                            /* the current display line */
 int CurColumn;                        /* the current display Column */

 GetVideoMode(&Dummy, &Dummy, &CurPage); /* Get current display page */
 GetCursorPos(&CurPage, &CurColumn, &CurLine,  /* Get current cursor */
              &Dummy, &Dummy);                           /* position */
 SetCursorPos(Page, Column, Line);                     /* Set cursor */
 Register.h.ah = 8;                               /* Function number */
 Register.h.bh = Page;                               /* display page */
 int86(0x10, &Register, &Register);          /* Call Interrupt 10(h) */
 *Character = Register.h.al;      /* Read results from the Registers */
 *Color = Register.h.ah;                               /* and assign */
 SetCursorPos(CurPage, CurColumn, CurLine);/* cursor to old position */
}

/*********************************************************************/
/* WRITECHAR: writes a character with an Attribute                   */
/*            at the current cursor position in the page indicated   */
/* Input    : see below                                              */
/* Output   : none                                                   */
/*********************************************************************/

void WriteChar(Page, Character, Color)
int Page;              /* The character appears in this display page */
char Character;                        /* the character to be output */
int Color;                                 /* its Attribute or Color */

{
 union REGS Register;        /* Register variable for Interrupt call */

 Register.h.ah = 9;                               /* Function number */
 Register.h.al = Character;            /* the character to be output */
 Register.h.bh = Page;                               /* display page */
 Register.h.bl = Color;           /* Color of character to be output */
 Register.x.cx = 1;                    /* output character only once */
 int86(0x10, &Register, &Register);          /* Call Interrupt 10(h) */
}

/*********************************************************************/
/* WRITETEXT: Writes a character string with constant color          */
/*            starting at a designated position within a display page*/
/* Input    : see below                                              */
/* Output   : none                                                   */
/* Info     : Text is a pointer to a character vector which contains */
/*            the text to be output and is terminated                */
/*            with a '\0' character                                  */
/*********************************************************************/

void WriteText(Page, Column, Line, Color, Text)
int Page;                 /* the Text is output in this display page */
int Column;                             /* display Column for Output */
int Line;                                 /* display line for Output */
int Color;                            /* Color/Attribute of the Text */
char *Text;                                       /* Text for output */

{
 union REGS Register;        /* Register variable for Interrupt call */

 SetCursorPos(Page, Column, Line);                     /* Set cursor */
 while (*Text)                   /* Output Text up to '\0' character */
  {
   WriteChar(Page, ' ', Color);              /* Color for characters */
   Register.h.ah = 14;                            /* Function number */
   Register.h.bh = Page;                             /* display page */
   Register.h.al = *Text++;              /* the character for output */
   int86(0x10, &Register, &Register);              /* Call Interrupt */
  }
}

/*********************************************************************/
/* CLEARSCREEN: erase the 80*25 character Text display and set       */
/*              cursor into the upper left display corner            */
/* Input      : none                                                 */
/* Output     : none                                                 */
/*********************************************************************/

void ClearScreen()

{
 int CurPage;                                /* current display page */
 int Dummy;                                        /* Dummy variable */

 ScrollUp(0, NORMAL, 0, 0, 79, 24);                  /* clear screen */
 GetVideoMode(&Dummy, &Dummy, &CurPage); /* Get current display page */
 SetCursorPos(CurPage, 0, 0);                          /* Set cursor */
}

/*********************************************************************/
/**                           MAIN PROGRAM                          **/
/*********************************************************************/

void main()

{
 int i, j, k, l;                                   /* Loop variables */
 char Arrows[3];         /* accepts number of Arrows as ASCII-String */

 ClearScreen();                                      /* Clear Screen */
 for (i = 1; i < 25; i++)                       /* process all lines */
  for (j = 0; j < 80; j++)                    /* process all Columns */
   {
    SetCursorPos(0, j, i);                        /* position cursor */
    WriteChar(0, i*80+j&255, NORMAL);            /* write characters */
   }
 ScrollDown(0, NORMAL, 5, 8, 19, 22);              /* erase Window 1 */
 WriteText(0, 5, 8, INVERS, "   Window 1   ");
 ScrollDown(0, NORMAL, 60, 2, 74, 16);             /* erase Window 2 */
 WriteText(0, 60, 2, INVERS, "   Window 2   ");
 WriteText(0, 24, 12, INVERS | BLINK, " >>> PC SYSTEM PROGRAMMING <<< ");
 WriteText(0, 0, 0, INVERS, "                           There are    ");
 WriteText(0, 40, 0, INVERS,"arrows left to draw                     ");
 for (i = 49; i >= 0 ; i--)                        /* draw 50 Arrows */
  {
   sprintf(Arrows, "%2d", i);   /* Convert number of Arrows to ASCII */
   WriteText(0, 37, 0, INVERS, Arrows);                /* and output */
   for (j = 1; j < 16; j+= 2)    /* every Arrow consists of 16 lines */
    {
     for (k = 0; k < j; k++)           /* create a line of the Arrow */
      {
       SetCursorPos(0, 12-(j>>1)+k, 9);            /* Arrow Window 1 */
       WriteChar(0, '*', BOLD);
       SetCursorPos(0, 67-(j>>1)+k, 16);           /* Arrow Window 2 */
       WriteChar(0, '*', BOLD);
      }
     ScrollDown(1, NORMAL, 5, 9, 19, 22);    /* Scroll Window 1 down */
     ScrollUp(1, NORMAL, 60, 3, 74, 16);       /* Scroll Window 2 up */
     for (l = 0; l < 4000 ; l++)                        /* Wait Loop */
      ;
    }
   }
 ClearScreen();                                      /* Clear Screen */
}
