{********************************************************************}
{*                             D U M P                              *}
{*------------------------------------------------------------------*}
{*    Task        : a Filter, which reads in characters from the    *}
{*                  Standard input device and outputs them          *}
{*                  as Hex and ASCII dump on                        *}
{*                  the Standard output device                      *}
{*------------------------------------------------------------------*}
{*    Author         : MICHAEL TISCHER                              *}
{*    developed on   : 08/08/87                                     *}
{*    last Update    : 05/04/89                                     *}
{*------------------------------------------------------------------*}
{*    Info           : This program can only be called from the     *}
{*                     DOS level after compiling to an EXE file     *}
{*                     with TURBO                                   *}
{********************************************************************}

program DUMP;


Uses Dos;                                             { Add DOS unit }

{$V-}                              { suppress length test on strings }

const NUL = 0;                        { ASCII-Code NUL-character     }
      BEL = 7;                        { ASCII-Code Bell character    }
      BS  = 8;                        { ASCII-Code Backspace         }
      TAB = 9;                        { ASCII-Code Tab               }
      LF  = 10;                       { ASCII-Code Linefeed          }
      CR  = 13;                       { ASCII-Code Carriage Return   }
      EOF = 26;                       { ASCII-Code End of File       }
      ESC = 27;                       { ASCII-Code Escape            }

type SZText = string[3];    { passes the name of a special character }
     DumpBf = array[1..80] of char;        { accepts the output Dump }

{********************************************************************}
{* SZ     : writes the name of a control character into a Buffer    *}
{* Input  : see below                                               *}
{* Output : none                                                    *}
{* Info   : after the call of this procedure the pointer            *}
{*          which was passed, points behind the last character of   *}
{*          the control character name in the Dump-Buffer           *}
{********************************************************************}

procedure SZ(var Buffer  : DumpBf;               { Text entered here }
                 Text    : SZText;              { Text to be entered }
             var Pointer : integer);       { addr. of text in buffer }

var Counter : integer;

begin
 Buffer[Pointer] := '<';                   { leads control character }
 for Counter := 1 to length(Text) do      { transfer Text to Buffer  }
  Buffer[Pointer + Counter] := Text[Counter];
 Buffer[Pointer + Counter + 1] := '>';     { terminates control char }
 Pointer := Pointer + Counter + 2;       { Pointer to next character }
end;

{********************************************************************}
{* DODUMP : reads characters in and outputs them as Dump            *}
{* Input  : none                                                    *}
{* Output : none                                                    *}
{********************************************************************}

procedure DoDump;

var Regs     : Registers;     { Register-Variable for Interrupt call }
    NewByte  : array[1..9] of char;  {accepts the characters read in }
    DumpBuf  : DumpBf;                      { accepts a line of DUMP }
    HexChr,
    Counter,
    NextA    : integer;           { Pointer in Buffer for ASCII-Code }
    Endc     : boolean;                      { another Byte read in? }

begin
 Endc := false;                                        { not the End }
 repeat
  Regs.ah := $3F;               { Function number for reading handle }
  Regs.bx := 0;              { the Standard input device is handle 0 }
  Regs.cx := 9;                               { read in 9 characters }
  Regs.ds := seg(NewByte);           { Segment address of the buffer }
  Regs.dx := ofs(NewByte);            { Offset address of the buffer }
  MsDos( Regs );                          { Call DOS-Interrupt 21(h) }
  if (Regs.ax = 0) then Endc := true;           { no character read? }
  if not(Endc) then
   begin                                                        { NO }
    for Counter := 1 to 30                 { Fill buffer with blanks }
     do DumpBuf [Counter] := ' ';
    DumpBuf[31] := #219;     { Place Separator between Hex and ASCII }
    NextA := 32;                 { ASCII-characters follow separator }
    for Counter := 1 to Regs.ax do     { start processing characters }
     begin                                                 { read in }
      HexChr := ord(NewByte[Counter]) shr 4 + 48;   { Hex top 4 bits }
      if (HexChr > 57) then HexChr := HexChr + 7;     { convert char }
      DumpBuf[Counter * 3 - 2] := chr(HexChr);     { store in buffer }
      HexChr := ord(NewByte[Counter]) and 15 + 48; { Hex bot. 4 bits }
      if (HexChr > 57) then HexChr := HexChr + 7;   { convert number }
      DumpBuf[Counter * 3 - 1] := chr(HexChr);     { store in buffer }
      case ord(NewByte[Counter]) of                { test ASCII-Code }
       NUL : SZ(DumpBuf, 'NUL', NextA);              { NUL-character }
       BEL : SZ(DumpBuf, 'BEL', NextA);             { Bell character }
       BS  : SZ(DumpBuf, 'BS' , NextA);                  { Backspace }
       TAB : SZ(DumpBuf, 'TAB', NextA);                        { Tab }
       LF  : SZ(DumpBuf, 'LF' , NextA);                   { Linefeed }
       CR  : SZ(DumpBuf, 'CR' , NextA);            { Carriage Return }
       EOF : SZ(DumpBuf, 'EOF', NextA);                { End of File }
       ESC : SZ(DumpBuf, 'ESC', NextA);                     { Escape }
       else
        begin                                     { normal character }
         DumpBuf[NextA] := NewByte[Counter]; { Store ASCII-character }
         NextA := succ(NextA)        { Set pointer to next character }
        end
      end;
     end;
    DumpBuf[NextA] := #219;                      { Set End character }
    DumpBuf[NextA+1] := chr(CR); { Carriage-Return followed by Line- }
    DumpBuf[NextA+2] := chr(LF);                { feed to buffer end }
    Regs.ah := $40;             { Function number for writing handle }
    Regs.bx := 1;               { Standard output device is handle 1 }
    Regs.cx := NextA+2;                       { Number of characters }
    Regs.ds := seg(DumpBuf);         { Segment address of the buffer }
    Regs.dx := ofs(DumpBuf);          { Offset address of the buffer }
    MsDos( Regs );                        { Call DOS-Interrupt 21(h) }
   end;
 until Endc;         { repeat until no more characters are available }
end;

{********************************************************************}
{*                           MAIN PROGRAM                           *}
{********************************************************************}

begin
  DoDump;                                              { Output Dump }
end.
