{**********************************************************************}
{*                            L E D P                                 *}
{*--------------------------------------------------------------------*}
{*    Description    : sets the various bits in the BIOS keyboard     *}
{*                     status byte causing the LEDs on the AT         *}
{*                     keyboard to turn on.                           *}
{*--------------------------------------------------------------------*}
{*    Author         : MICHAEL TISCHER                                *}
{*    developed on   : 08/16/1988                                     *}
{*    last update    : 08/17/1988                                     *}
{**********************************************************************}

program LEDP;

uses CRT,                                       { bind in the CRT unit }
     DOS;                                       { bind in the DOS unit }

const SCRL =  16;                                    { Scroll Lock bit }
      NUML =  32;                                       { Num Lock bit }
      CAPL =  64;                                      { Caps Lock bit }
      INS  = 128;                                         { Insert bit }

{**********************************************************************}
{* SETFLAG: sets one the flags in the BIOS keyboard status byte       *}
{* Input  : the flag to be set (see constants)                        *}
{* Output : none                                                      *}
{**********************************************************************}

procedure SetFlag(Flag : byte);

var BiosTSByte : byte absolute $0040:$0017;{ BIOS keyboard status byte }
    Regs       : Registers;   { processor registers for interrupt call }

begin
  BiosTSByte := BiosTSByte or Flag;   { mask out the corresponding bit }
  Regs.AH := 1;                     {   function no.: character ready? }
  intr($16, Regs);                      { call BIOS keyboard interrupt }
end;


{**********************************************************************}
{* CLRFLAG: clears one of the flags in the BIOS keyboard status byte  *}
{* Input  : the flag to be cleared (see constants)                    *}
{* Output : none                                                      *}
{**********************************************************************}

procedure ClrFlag(Flag : byte);

var BiosTSByte : byte absolute $0040:$0017;   { BIOS keyb. status byte }
    Regs       : Registers;   { processor registers for interrupt call }

begin
  BiosTSByte := BiosTSByte and ( not Flag );            { mask out bit }
  Regs.AH := 1;                       { function no.: character ready? }
  intr($16, Regs);                     { call BIOS keyboard interrupt  }
end;

{**********************************************************************}
{**                           MAIN PROGRAM                           **}
{**********************************************************************}

var counter : integer;

begin
  writeln('LEDP  -  (c) 1988 by Michael Tischer');
  writeln(#13,#10, 'Watch the LEDs on your keyboard!');

  for counter:=1 to 10 do              { run through the loop 10 times }
    begin
      SetFlag( CAPL);                                   { turn on CAPS }
      Delay( 100 );                            { wait 100 milliseconds }
      ClrFlag( CAPL );                           { turn CAPS off again }
      SetFlag( NUML);                                    { turn on NUM }
      Delay( 100 );                            { wait 100 milliseconds }
      ClrFlag( NUML );                            { turn NUM off again }
      SetFlag( SCRL);                           { turn SCROLL LOCK off }
      Delay( 100 );                            { wait 100 milliseconds }
      ClrFlag( SCRL );                    { turn SCROLL LOCK off again }
    end;

  for counter:=1 to 10 do                  { run through loop 10 times }
    begin
      SetFlag(CAPL or SCRL or NUML);              { all three flags on }
      Delay( 200 );                            { wait 200 milliseconds }
      ClrFlag(CAPL or SCRL or NUML);             { all flags off again }
      Delay( 200 );                            { wait 200 milliseconds }
    end;
end.
