{*********************************************************************}
{*                              M O V E P                            *}
{*-------------------------------------------------------------------*}
{*    Task     : With the help of a procedure, Data are              *}
{*               copied in RAM below and above 1 MB                  *}
{*-------------------------------------------------------------------*}
{*    Author         : MICHAEL TISCHER                               *}
{*    developed on   :  8.8.87                                       *}
{*    last Update    : 9.21.87                                       *}
{*-------------------------------------------------------------------*}
{*    Info        : This program runs only on ATs and                *}
{*                  only if RAM beyond 1 MB                          *}
{*                  is available                                     *}
{*********************************************************************}

program MOVEP;


Uses Crt, Dos;                                  {add Crt and Dos units}

var Keypress : char;

{*********************************************************************}
{* GETPAGE: returns the segment address of the current display page  *}
{* Input :  none                                                     *}
{* Output : the segment address of the current display page          *}
{*********************************************************************}

function GetPage : Longint;

var Regs : Registers;         {Processor registers for interrupt calls}

begin
 Regs.ah := 15;                                     { Function number }
 intr($10, Regs);                         { Call BIOS video interrupt }
 if Regs.al = 7 then GetPage := $B000               { Monochrome card }
                else GetPage := $B800;                   { Color card }
end;

{************************************************************************}
{* MOVE:    moves memory areas                                          *}
{* Input :  see below                                                   *}
{* Output : none                                                        *}
{* Info: Direction:             0 = from below 1 MB--> to below 1 MB    *}
{*                              1 = from below 1 MB--> to above 1 MB    *}
{*                              2 = from above 1 MB--> to below 1 MB    *}
{*                              3 = from above 1 MB--> to above 1 MB    *}
{*               Addresses above the 1MB boundary are given relative    *}
{*               to this value                                          *}
{************************************************************************}

{$F+}
procedure HiMove(StartSeg,         { Segment address of the start buffer }
          StartOfs,                 { Offset address of the start buffer }
          DestSeg,               { Segment address of destination buffer }
          DestOfs,                { Offset address of destination buffer }
          Size,                           { Number of words to be copied }
          Direction : integer);             { Direction in which to copy }
begin
 inline(
        $8B/$7E/$10/$8B/$76/$0E/$8B/$46/$0C/$8E/$C0/$8B/$5E/$0A/
        $8B/$46/$08/$8B/$4E/$06/$8A/$E9/$55/$E8/$5E/$00/$00/$00/
        $00/$00/$00/$00/$00/$00/$00/$00/$00/$00/$00/$00/$00/$00/
        $FF/$FF/$00/$00/$10/$92/$00/$00/$FF/$FF/$00/$00/$00/$92/
        $00/$00/$00/$00/$00/$00/$00/$00/$00/$00/$00/$00/$00/$00/
        $00/$00/$00/$00/$50/$8C/$C0/$F6/$C5/$01/$E8/$28/$00/$2E/
        $88/$56/$1C/$2E/$89/$46/$1A/$8B/$C7/$8B/$DE/$F6/$C5/$02/
        $E8/$16/$00/$2E/$88/$56/$14/$2E/$89/$46/$12/$B4/$87/$0E/
        $07/$59/$8B/$F5/$CD/$15/$EB/$17/$5D/$EB/$CF/$8A/$D4/$B1/
        $04/$D2/$EA/$75/$03/$80/$CA/$10/$D3/$E0/$03/$C3/$73/$02/
        $FE/$C2/$C3/$5D
       );
end;

{*********************************************************************}
{*                          MAIN PROGRAM                             *}
{*********************************************************************}

begin
  clrscr;                                              { Clear Screen }
  writeln('MOVEP (c) 1987 by Michael Tischer');
  writeln(#13#10'This Program uses Function 87(h) of  '+
         'Interrupt 15(h) to move blocks of storage ');
  writeln('between the "normal" RAM and the RAM beyond the 1 Mega-'+
          'Byte storage boundary');
  if mem[$F000:$FFFE] <> $FC then         { test if computer is an AT }
   begin
    writeln('Since this computer is not an AT, '+
            'but a PC or');
    writeln('an XT, and these can not have storage '+
            'beyond the 1 MB boundary,');
    writeln('this program can not execute on your PC! ');
    writeln('Sorry....');
   end
  else
   begin
   writeln('First this display page is moved immediately '+
            'beyond the 1 MB storage ');
    writeln('boundary. The screen is then cleared. '+
            'After a key has been activated, ');
    writeln('the old display page is restored.');
    writeln(''#13#10'Please activate a key now to '+
            'start the program...');
    repeat until keypressed;                         { Wait for a key }
    Keypress := ReadKey;                                   { Read key }
    HiMove(GetPage,$0000,$0000,$0000,$2000,$1);      { Copy video RAM }
    clrscr;                                            { Clear screen }
    writeln('Please press a key ...');
    Keypress:= ReadKey;                                    { Read key }
    HiMove($0000,$0000,GetPage,$0000,$2000,$2);   { Restore video RAM }
    gotoxy(1,15);
    writeln('That`s All!');
   end;
end.

